/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.framework;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.config.util.ChangePropertiesRequest;
import com.openexchange.ajax.framework.config.util.ChangePropertiesResponse;
import com.openexchange.ajax.writer.ResponseWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public abstract class AbstractConfigAwareAjaxSession
extends AbstractAJAXSession {
    JSONObject oldData;

    protected AbstractConfigAwareAjaxSession(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Map<String, String> map = this.getNeededConfigurations();
        if (!map.isEmpty()) {
            ChangePropertiesRequest req = new ChangePropertiesRequest(map, this.getScope());
            ChangePropertiesResponse response = this.client.execute(req);
            this.oldData = ResponseWriter.getJSON((Response)response.getResponse()).getJSONObject("data");
        }
    }

    @Override
    protected void tearDown() throws Exception {
        super.setUp();
        if (this.oldData != null) {
            Map map = this.oldData.asMap();
            HashMap<String, String> newMap = new HashMap<String, String>();
            for (Map.Entry entry : map.entrySet()) {
                try {
                    newMap.put((String)entry.getKey(), (String)entry.getValue());
                }
                catch (ClassCastException cce) {
                    return;
                }
            }
            if (!map.isEmpty()) {
                ChangePropertiesRequest req = new ChangePropertiesRequest(newMap, "server");
                ChangePropertiesResponse response = this.client.execute(req);
                this.oldData = ResponseWriter.getJSON((Response)response.getResponse());
            }
        }
    }

    protected Map<String, String> getNeededConfigurations() {
        return Collections.emptyMap();
    }

    protected String getScope() {
        return "server";
    }
}

