/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.find.tasks;

import com.openexchange.ajax.find.AbstractFindTest;
import com.openexchange.ajax.find.actions.QueryRequest;
import com.openexchange.ajax.find.actions.QueryResponse;
import com.openexchange.ajax.find.tasks.FindTasksTestEnvironment;
import com.openexchange.exception.OXException;
import com.openexchange.find.facet.ActiveFacet;
import com.openexchange.groupware.tasks.Task;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractFindTasksTest
extends AbstractFindTest {
    public AbstractFindTasksTest(String name) {
        super(name);
    }

    protected static final JSONArray getResults(QueryResponse qr) {
        JSONArray ret = null;
        if (qr.getData() != null && qr.getData() instanceof JSONObject) {
            ret = ((JSONObject)qr.getData()).optJSONArray("results");
        }
        return ret;
    }

    protected final void assertResults(int expectedResultCount, List<ActiveFacet> f) throws OXException, IOException, JSONException {
        this.assertResults(expectedResultCount, f, -1, -1);
    }

    protected final void assertResults(int expectedResultCount, List<ActiveFacet> f, int start, int size) throws OXException, IOException, JSONException {
        ArrayList<ActiveFacet> facets = new ArrayList<ActiveFacet>();
        facets.add(FindTasksTestEnvironment.createGlobalFacet());
        facets.addAll(f);
        QueryResponse queryResponse = this.client.execute(new QueryRequest(start, size, facets, "tasks"));
        AbstractFindTasksTest.assertNotNull((Object)((Object)queryResponse));
        JSONArray results = AbstractFindTasksTest.getResults(queryResponse);
        int actualResultCount = results.asList().size();
        AbstractFindTasksTest.assertEquals((int)expectedResultCount, (int)actualResultCount);
        for (Object o : results.asList()) {
            Map m = (Map)o;
            Task t = FindTasksTestEnvironment.getInstance().getTask((Integer)m.get("id"));
            AbstractFindTasksTest.assertNotNull((String)"Expected object not found", (Object)t);
            AbstractFindTasksTest.assertEquals((String)"Not the same", (Object)t.getTitle(), m.get("title"));
        }
    }
}

