/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.find.mail;

import com.openexchange.ajax.find.actions.AutocompleteRequest;
import com.openexchange.ajax.find.actions.AutocompleteResponse;
import com.openexchange.ajax.find.mail.AbstractMailFindTest;
import com.openexchange.find.Module;
import com.openexchange.find.facet.DefaultFacet;
import com.openexchange.find.facet.Facet;
import com.openexchange.find.facet.FacetType;
import com.openexchange.find.facet.FacetValue;
import com.openexchange.find.facet.Option;
import com.openexchange.find.mail.MailFacetType;
import java.util.ArrayList;
import java.util.List;

public class Bug42970Test
extends AbstractMailFindTest {
    public Bug42970Test(String name) {
        super(name);
    }

    public void testBccFieldIsIncludedInContacts() throws Exception {
        ArrayList<String> folders = new ArrayList<String>(4);
        folders.add(this.client.getValues().getInboxFolder());
        folders.add(this.client.getValues().getSentFolder());
        folders.add(this.client.getValues().getDraftsFolder());
        folders.add(this.client.getValues().getTrashFolder());
        for (String folder : folders) {
            this.assertBccFieldInFolder(folder);
        }
    }

    private void assertBccFieldInFolder(String folder) throws Exception {
        String prefix = this.defaultAddress.substring(0, 3);
        AutocompleteRequest autocompleteRequest = new AutocompleteRequest(prefix, Module.MAIL.getIdentifier(), this.prepareFacets(folder));
        AutocompleteResponse autocompleteResponse = this.client.execute(autocompleteRequest);
        List<Facet> facets = autocompleteResponse.getFacets();
        DefaultFacet contactFacet = (DefaultFacet)Bug42970Test.findByType((FacetType)MailFacetType.CONTACTS, facets);
        Bug42970Test.assertNotNull((Object)contactFacet);
        Option option = this.findOption(((FacetValue)contactFacet.getValues().get(0)).getOptions(), "to");
        Bug42970Test.assertEquals((String)"to", (String)option.getId());
        this.assertFields(option.getFilter().getFields(), "bcc");
    }

    private Option findOption(List<Option> options, String optionName) {
        for (Option option : options) {
            if (!option.getId().equals(optionName)) continue;
            return option;
        }
        throw new IllegalArgumentException("The option '" + optionName + "' was not found in the 'options' list");
    }

    private void assertFields(List<String> fields, String fieldName) {
        Bug42970Test.assertNotNull((String)"The fields list is null", fields);
        Bug42970Test.assertFalse((String)"The fields list is empty", (boolean)fields.isEmpty());
        boolean foundBcc = false;
        for (String field : fields) {
            if (!field.equals(fieldName)) continue;
            foundBcc = true;
            break;
        }
        Bug42970Test.assertTrue((String)"The 'bcc' field is not included in the contacts facet", (boolean)foundBcc);
    }
}

