/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.find.mail;

import com.openexchange.ajax.find.PropDocument;
import com.openexchange.ajax.find.actions.AutocompleteRequest;
import com.openexchange.ajax.find.actions.AutocompleteResponse;
import com.openexchange.ajax.find.actions.TestDisplayItem;
import com.openexchange.ajax.find.mail.AbstractMailFindTest;
import com.openexchange.ajax.mail.actions.GetRequest;
import com.openexchange.ajax.mail.actions.GetResponse;
import com.openexchange.configuration.MailConfig;
import com.openexchange.exception.OXException;
import com.openexchange.find.Module;
import com.openexchange.find.common.CommonFacetType;
import com.openexchange.find.facet.ActiveFacet;
import com.openexchange.find.facet.DefaultFacet;
import com.openexchange.find.facet.Facet;
import com.openexchange.find.facet.FacetType;
import com.openexchange.find.facet.FacetValue;
import com.openexchange.find.facet.Filter;
import com.openexchange.find.facet.Option;
import com.openexchange.find.facet.SimpleFacet;
import com.openexchange.find.mail.MailFacetType;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.java.util.TimeZones;
import com.openexchange.mail.MailField;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailListField;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.io.FileUtils;
import org.json.JSONException;

public class BasicMailTest
extends AbstractMailFindTest {
    private FolderObject testFolder;

    public BasicMailTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        String inboxFolder = this.client.getValues().getInboxFolder();
        String folderName = "findApiMailTestFolder_" + System.currentTimeMillis();
        this.testFolder = new FolderObject();
        this.testFolder.setModule(7);
        this.testFolder.setFullName(inboxFolder + "/" + folderName);
        this.testFolder.setFolderName(folderName);
        this.testFolder = this.folderManager.insertFolderOnServer(this.testFolder);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAutocomplete() throws Exception {
        com.openexchange.ajax.user.actions.GetRequest getRequest = new com.openexchange.ajax.user.actions.GetRequest(this.client.getValues().getUserId(), this.client.getValues().getTimeZone());
        com.openexchange.ajax.user.actions.GetResponse getResponse = this.client.execute(getRequest);
        Contact ownContact = getResponse.getContact();
        Contact modified = new Contact();
        modified.setObjectID(ownContact.getObjectID());
        MailConfig.init();
        String testDataDir = MailConfig.getProperty(MailConfig.Property.TEST_MAIL_DIR);
        byte[] image = FileUtils.readFileToByteArray((File)new File(testDataDir, "contact_image.png"));
        modified.setImage1(image);
        modified.setImageContentType("image/png");
        modified.setLastModified(new Date());
        this.contactManager.updateAction(ownContact.getParentFolderID(), modified);
        Contact distributionList = new Contact();
        distributionList.setParentFolderID(this.client.getValues().getPrivateContactFolder());
        distributionList.setSurName(BasicMailTest.randomUID());
        distributionList.setGivenName(BasicMailTest.randomUID());
        distributionList.setDisplayName(distributionList.getGivenName() + " " + distributionList.getSurName());
        distributionList.setDistributionList(new DistributionListEntryObject[]{new DistributionListEntryObject("displayname a", "a@a.de", 0), new DistributionListEntryObject("displayname b", "b@b.de", 0)});
        distributionList = this.contactManager.newAction(distributionList);
        String prefix = this.defaultAddress.substring(0, 3);
        AutocompleteRequest autocompleteRequest = new AutocompleteRequest(prefix, Module.MAIL.getIdentifier(), this.prepareFacets());
        AutocompleteResponse autocompleteResponse = this.client.execute(autocompleteRequest);
        List<Facet> facets = autocompleteResponse.getFacets();
        FacetValue found = this.detectContact(facets);
        BasicMailTest.assertNotNull((String)"own contact was missing in response", (Object)found);
        String mailAddress = ((TestDisplayItem)found.getDisplayItem()).getDetail();
        BasicMailTest.assertEquals((String)this.defaultAddress, (String)mailAddress);
        String imageUrl = ((TestDisplayItem)found.getDisplayItem()).getImageUrl();
        BasicMailTest.assertNotNull((String)"image_url missing in contact", (Object)imageUrl);
        List<ActiveFacet> activeFacets = this.prepareFacets();
        activeFacets.add(BasicMailTest.createActiveFacet((FacetType)MailFacetType.CONTACTS, found.getId(), ((Option)found.getOptions().get(0)).getFilter()));
        facets = this.autocomplete(prefix, activeFacets);
        found = this.detectContact(facets);
        BasicMailTest.assertNull((String)"Own contact should've been missing in response", (Object)found);
        facets = this.autocomplete(distributionList.getSurName().substring(0, 10));
        DefaultFacet contactFacet = (DefaultFacet)BasicMailTest.findByType((FacetType)MailFacetType.CONTACTS, facets);
        boolean dlFound = false;
        for (FacetValue v : contactFacet.getValues()) {
            if (!v.getDisplayItem().getDisplayName().contains(distributionList.getSurName())) continue;
            dlFound = true;
            break;
        }
        BasicMailTest.assertFalse((String)"Distribution list was found but should not", (boolean)dlFound);
    }

    public void testSearch() throws Exception {
        String[][] mailIds = this.importMail(this.testFolder.getFullName(), this.defaultAddress, "Find me", "");
        BasicMailTest.assertNotNull((String)"mail was not imported", (Object)mailIds);
        ArrayList<String> addressFields = new ArrayList<String>(3);
        addressFields.add("from");
        addressFields.add("to");
        addressFields.add("cc");
        List<ActiveFacet> facets = this.prepareFacets();
        facets.add(BasicMailTest.createActiveFacet((FacetType)MailFacetType.CONTACTS, "some/id", new Filter(addressFields, this.defaultAddress)));
        facets.add(BasicMailTest.createQuery("Find me"));
        List<PropDocument> documents = this.query(facets);
        BasicMailTest.assertEquals((String)"Did not find mail", (int)1, (int)documents.size());
        PropDocument document = documents.get(0);
        Object mailId = document.getProps().get("id");
        BasicMailTest.assertEquals((String)"Wrong mail found", (Object)mailIds[0][1], (Object)mailId);
        facets.add(BasicMailTest.createActiveFacet((FacetType)MailFacetType.CONTACTS, "some/other/id", new Filter(addressFields, "unknown@example.com")));
        documents = this.query(facets);
        BasicMailTest.assertEquals((String)"Mail found but should not", (int)0, (int)documents.size());
    }

    public void testMultipleGlobalFacets() throws Exception {
        String[][] mailIds = this.importMail(this.testFolder.getFullName(), this.defaultAddress, "Find me", "");
        BasicMailTest.assertNotNull((String)"mail was not imported", (Object)mailIds);
        List<ActiveFacet> facets = this.prepareFacets();
        facets.add(BasicMailTest.createQuery("Find"));
        facets.add(BasicMailTest.createQuery("me"));
        List<PropDocument> documents = this.query(facets);
        BasicMailTest.assertEquals((String)"Did not find mail", (int)1, (int)documents.size());
        PropDocument document = documents.get(0);
        Object mailId = document.getProps().get("id");
        BasicMailTest.assertEquals((String)"Wrong mail found", (Object)mailIds[0][1], (Object)mailId);
        facets.add(BasicMailTest.createQuery("again"));
        documents = this.query(facets);
        BasicMailTest.assertEquals((String)"Mail found but should not", (int)0, (int)documents.size());
    }

    public void testPagination() throws Exception {
        String[][] mailIds = this.importMails(this.testFolder.getFullName(), 3, this.defaultAddress, this.defaultAddress);
        BasicMailTest.assertNotNull((String)"mails not imported", (Object)mailIds);
        BasicMailTest.assertEquals((String)"mails not imported", (int)3, (int)mailIds.length);
        List<ActiveFacet> facets = this.prepareFacets();
        facets.add(BasicMailTest.createActiveFacet((FacetType)MailFacetType.CONTACTS, "", "from", this.defaultAddress));
        List<PropDocument> documents = this.query(facets, 0, 5);
        BasicMailTest.assertEquals((String)"Should only find 3 mails", (int)3, (int)documents.size());
        documents = this.query(facets, 1, 5);
        BasicMailTest.assertEquals((String)"Should only find 2 mails", (int)2, (int)documents.size());
        documents = this.query(facets, 2, 5);
        BasicMailTest.assertEquals((String)"Should only find 1 mails", (int)1, (int)documents.size());
        documents = this.query(facets, 3, 5);
        BasicMailTest.assertEquals((String)"Should only find 0 mails", (int)0, (int)documents.size());
    }

    public void testDateFilter() throws Exception {
        GregorianCalendar calWithinLastWeek = new GregorianCalendar(TimeZones.UTC);
        ((Calendar)calWithinLastWeek).add(3, -1);
        ((Calendar)calWithinLastWeek).add(6, 1);
        String idWithinLastWeek = this.importMail(this.testFolder.getFullName(), this.defaultAddress, this.defaultAddress, BasicMailTest.randomUID(), BasicMailTest.randomUID(), calWithinLastWeek.getTime())[0][1];
        GregorianCalendar calWithinLastMonth = new GregorianCalendar(TimeZones.UTC);
        ((Calendar)calWithinLastMonth).add(2, -1);
        ((Calendar)calWithinLastMonth).add(6, 1);
        String idWithinLastMonth = this.importMail(this.testFolder.getFullName(), this.defaultAddress, this.defaultAddress, BasicMailTest.randomUID(), BasicMailTest.randomUID(), calWithinLastMonth.getTime())[0][1];
        GregorianCalendar calWithinLastYear = new GregorianCalendar(TimeZones.UTC);
        ((Calendar)calWithinLastYear).add(1, -1);
        ((Calendar)calWithinLastYear).add(6, 1);
        String idWithinLastYear = this.importMail(this.testFolder.getFullName(), this.defaultAddress, this.defaultAddress, BasicMailTest.randomUID(), BasicMailTest.randomUID(), calWithinLastYear.getTime())[0][1];
        GregorianCalendar calBeforeLastYear = new GregorianCalendar(TimeZones.UTC);
        ((Calendar)calBeforeLastYear).add(1, -1);
        ((Calendar)calBeforeLastYear).add(6, -1);
        String idBeforeLastYear = this.importMail(this.testFolder.getFullName(), this.defaultAddress, this.defaultAddress, BasicMailTest.randomUID(), BasicMailTest.randomUID(), calBeforeLastYear.getTime())[0][1];
        List<ActiveFacet> facets = this.prepareFacets();
        facets.add(BasicMailTest.createActiveFacet((FacetType)CommonFacetType.DATE, "last_week", "date", "last_week"));
        List<PropDocument> documents = this.query(facets);
        BasicMailTest.assertEquals((String)"Should only find 1 mails", (int)1, (int)documents.size());
        BasicMailTest.assertNotNull((String)"Mail not found", (Object)BasicMailTest.findByProperty(documents, "id", idWithinLastWeek));
        BasicMailTest.assertNull((String)"Wrong mail found", (Object)BasicMailTest.findByProperty(documents, "id", idBeforeLastYear));
        String timeRange = "[" + calWithinLastWeek.getTime().getTime() + " TO " + System.currentTimeMillis() + "]";
        facets = this.prepareFacets();
        facets.add(BasicMailTest.createActiveFacet((FacetType)CommonFacetType.DATE, timeRange, Filter.NO_FILTER));
        documents = this.query(facets);
        BasicMailTest.assertEquals((String)"Should only find 1 mails", (int)1, (int)documents.size());
        BasicMailTest.assertNotNull((String)"Mail not found", (Object)BasicMailTest.findByProperty(documents, "id", idWithinLastWeek));
        BasicMailTest.assertNull((String)"Wrong mail found", (Object)BasicMailTest.findByProperty(documents, "id", idBeforeLastYear));
        facets = this.prepareFacets();
        facets.add(BasicMailTest.createActiveFacet((FacetType)CommonFacetType.DATE, "last_month", "date", "last_month"));
        documents = this.query(facets);
        BasicMailTest.assertEquals((String)"Should only find 2 mails", (int)2, (int)documents.size());
        BasicMailTest.assertNotNull((String)"Mail not found", (Object)BasicMailTest.findByProperty(documents, "id", idWithinLastWeek));
        BasicMailTest.assertNotNull((String)"Mail not found", (Object)BasicMailTest.findByProperty(documents, "id", idWithinLastMonth));
        BasicMailTest.assertNull((String)"Wrong mail found", (Object)BasicMailTest.findByProperty(documents, "id", idBeforeLastYear));
        timeRange = "[" + calWithinLastMonth.getTime().getTime() + " TO *]";
        facets = this.prepareFacets();
        facets.add(BasicMailTest.createActiveFacet((FacetType)CommonFacetType.DATE, timeRange, Filter.NO_FILTER));
        documents = this.query(facets);
        BasicMailTest.assertEquals((String)"Should only find 2 mails", (int)2, (int)documents.size());
        BasicMailTest.assertNotNull((String)"Mail not found", (Object)BasicMailTest.findByProperty(documents, "id", idWithinLastWeek));
        BasicMailTest.assertNotNull((String)"Mail not found", (Object)BasicMailTest.findByProperty(documents, "id", idWithinLastMonth));
        BasicMailTest.assertNull((String)"Wrong mail found", (Object)BasicMailTest.findByProperty(documents, "id", idBeforeLastYear));
        facets = this.prepareFacets();
        facets.add(BasicMailTest.createActiveFacet((FacetType)CommonFacetType.DATE, "last_year", "date", "last_year"));
        documents = this.query(facets);
        BasicMailTest.assertEquals((String)"Should only find 3 mails", (int)3, (int)documents.size());
        BasicMailTest.assertNotNull((String)"Mail not found", (Object)BasicMailTest.findByProperty(documents, "id", idWithinLastWeek));
        BasicMailTest.assertNotNull((String)"Mail not found", (Object)BasicMailTest.findByProperty(documents, "id", idWithinLastMonth));
        BasicMailTest.assertNotNull((String)"Mail not found", (Object)BasicMailTest.findByProperty(documents, "id", idWithinLastYear));
        BasicMailTest.assertNull((String)"Wrong mail found", (Object)BasicMailTest.findByProperty(documents, "id", idBeforeLastYear));
        timeRange = "[" + calWithinLastYear.getTime().getTime() + " TO *]";
        facets = this.prepareFacets();
        facets.add(BasicMailTest.createActiveFacet((FacetType)CommonFacetType.DATE, timeRange, Filter.NO_FILTER));
        documents = this.query(facets);
        BasicMailTest.assertEquals((String)"Should only find 3 mails", (int)3, (int)documents.size());
        BasicMailTest.assertNotNull((String)"Mail not found", (Object)BasicMailTest.findByProperty(documents, "id", idWithinLastWeek));
        BasicMailTest.assertNotNull((String)"Mail not found", (Object)BasicMailTest.findByProperty(documents, "id", idWithinLastMonth));
        BasicMailTest.assertNotNull((String)"Mail not found", (Object)BasicMailTest.findByProperty(documents, "id", idWithinLastYear));
        BasicMailTest.assertNull((String)"Wrong mail found", (Object)BasicMailTest.findByProperty(documents, "id", idBeforeLastYear));
        timeRange = "{* TO *}";
        facets = this.prepareFacets();
        facets.add(BasicMailTest.createActiveFacet((FacetType)CommonFacetType.DATE, timeRange, Filter.NO_FILTER));
        documents = this.query(facets);
        BasicMailTest.assertEquals((String)"Should find 4 mails", (int)4, (int)documents.size());
        BasicMailTest.assertNotNull((String)"Mail not found", (Object)BasicMailTest.findByProperty(documents, "id", idWithinLastWeek));
        BasicMailTest.assertNotNull((String)"Mail not found", (Object)BasicMailTest.findByProperty(documents, "id", idWithinLastMonth));
        BasicMailTest.assertNotNull((String)"Mail not found", (Object)BasicMailTest.findByProperty(documents, "id", idWithinLastYear));
        BasicMailTest.assertNotNull((String)"Mail not found", (Object)BasicMailTest.findByProperty(documents, "id", idBeforeLastYear));
    }

    public void testFilterChaining() throws Exception {
        String A = "some.body@find.me";
        String B = BasicMailTest.randomUID();
        String C = BasicMailTest.randomUID();
        String D = BasicMailTest.randomUID();
        String E = BasicMailTest.randomUID();
        String F = BasicMailTest.randomUID();
        String G = "another.dude@example.org";
        String H = BasicMailTest.randomUID();
        String I = BasicMailTest.randomUID();
        this.importMail(this.testFolder.getFullName(), A, B, D);
        this.importMail(this.testFolder.getFullName(), A, B, E);
        this.importMail(this.testFolder.getFullName(), A, C, F);
        this.importMail(this.testFolder.getFullName(), G, H, I);
        List<ActiveFacet> facets = this.prepareFacets();
        List<PropDocument> documents = this.query(facets);
        BasicMailTest.assertEquals((String)"Wrong number of mails", (int)4, (int)documents.size());
        facets.add(BasicMailTest.createActiveFacet((FacetType)MailFacetType.CONTACTS, A, "from", A));
        documents = this.query(facets);
        BasicMailTest.assertEquals((String)"Wrong number of mails", (int)3, (int)documents.size());
        facets.add(BasicMailTest.createActiveFacet((FacetType)MailFacetType.SUBJECT, MailFacetType.SUBJECT.getId(), "subject", B));
        documents = this.query(facets);
        BasicMailTest.assertEquals((String)"Wrong number of mails", (int)2, (int)documents.size());
        facets.add(BasicMailTest.createActiveFacet((FacetType)MailFacetType.MAIL_TEXT, MailFacetType.MAIL_TEXT.getId(), "body", D));
        documents = this.query(facets);
        BasicMailTest.assertEquals((String)"Wrong number of mails", (int)1, (int)documents.size());
    }

    public void testPrefixItemIsLastInContactsFacet() throws Exception {
        FolderObject contactFolder = this.folderManager.generatePrivateFolder("findApiMailTestFolder_" + System.currentTimeMillis(), 3, this.client.getValues().getPrivateContactFolder(), this.client.getValues().getUserId());
        contactFolder = this.folderManager.insertFolderOnServer(contactFolder);
        LinkedList<Contact> contacts = new LinkedList<Contact>();
        contacts.add(this.contactManager.newAction(this.randomContact("Marc", contactFolder.getObjectID())));
        contacts.add(this.contactManager.newAction(this.randomContact("Marcus", contactFolder.getObjectID())));
        contacts.add(this.contactManager.newAction(this.randomContact("Martin", contactFolder.getObjectID())));
        contacts.add(this.contactManager.newAction(this.randomContact("Marek", contactFolder.getObjectID())));
        contacts.add(this.contactManager.newAction(this.randomContact("Marion", contactFolder.getObjectID())));
        String prefix = "Mar";
        List<Facet> facets = this.autocomplete(prefix);
        Facet facet = BasicMailTest.findByType((FacetType)MailFacetType.CONTACTS, facets);
        BasicMailTest.assertNotNull((String)"Contacts facet not found", (Object)facet);
        List values = ((DefaultFacet)facet).getValues();
        int nValues = values.size();
        BasicMailTest.assertTrue((String)"Missing contacts in facets", (values.size() > 5 ? 1 : 0) != 0);
        this.findContactsInValues(contacts, values);
        FacetValue last = (FacetValue)values.get(values.size() - 1);
        BasicMailTest.assertEquals((String)"Prefix item is at wrong position in result set", (String)prefix, (String)last.getId());
        List<ActiveFacet> activeFacets = this.prepareFacets();
        activeFacets.add(new ActiveFacet((FacetType)MailFacetType.CONTACTS, ((FacetValue)values.get(0)).getId(), ((Option)((FacetValue)values.get(0)).getOptions().get(0)).getFilter()));
        facets = this.autocomplete(prefix, activeFacets);
        facet = BasicMailTest.findByType((FacetType)MailFacetType.CONTACTS, facets);
        BasicMailTest.assertNotNull((String)"Contacts facet not found", (Object)facet);
        values = ((DefaultFacet)facet).getValues();
        BasicMailTest.assertTrue((String)"Wrong contacts in facets", (values.size() == nValues - 1 ? 1 : 0) != 0);
        last = (FacetValue)values.get(values.size() - 1);
        BasicMailTest.assertEquals((String)"Prefix item is at wrong position in result set", (String)prefix, (String)last.getId());
    }

    public void testQueryActionWithColumns() throws Exception {
        String[][] mailIds = this.importMail(this.testFolder.getFullName(), this.defaultAddress, "Find me", "");
        BasicMailTest.assertNotNull((String)"mail was not imported", (Object)mailIds);
        List<ActiveFacet> facets = this.prepareFacets();
        facets.add(BasicMailTest.createQuery("Find me"));
        int[] columns = new int[]{102, 600, 601, 602, 603, 604, 605, 607, 608, 610, 611, 614, 652, 653};
        MailListField[] fields = MailListField.getFields((int[])columns);
        List<PropDocument> documents = this.query(facets, columns);
        BasicMailTest.assertTrue((String)"Did not find mail", (documents.size() > 0 ? 1 : 0) != 0);
        PropDocument document = documents.get(0);
        LinkedList<String> jsonFields = new LinkedList<String>();
        for (MailListField field : fields) {
            jsonFields.add(field.getKey());
        }
        Map<String, Object> props = document.getProps();
        for (String jsonField : jsonFields) {
            Object value = props.remove(jsonField);
            BasicMailTest.assertNotNull((String)("Missing field " + jsonField), (Object)value);
        }
        BasicMailTest.assertTrue((String)("Document contained more fields than requested: " + props.keySet()), (props.size() == 0 ? 1 : 0) != 0);
    }

    public void testQueryActionWithoutColumns() throws Exception {
        String[][] mailIds = this.importMail(this.testFolder.getFullName(), this.defaultAddress, "Find me", "");
        BasicMailTest.assertNotNull((String)"mail was not imported", (Object)mailIds);
        List<ActiveFacet> facets = this.prepareFacets();
        facets.add(BasicMailTest.createQuery("Find me"));
        MailListField[] fields = MailField.toListFields((MailField[])MailField.FIELDS_LOW_COST);
        List<PropDocument> documents = this.query(facets);
        BasicMailTest.assertTrue((String)"Did not find mail", (documents.size() > 0 ? 1 : 0) != 0);
        PropDocument document = documents.get(0);
        LinkedList<String> jsonFields = new LinkedList<String>();
        for (MailListField field : fields) {
            jsonFields.add(field.getKey());
        }
        Map<String, Object> props = document.getProps();
        for (String jsonField : jsonFields) {
            Object value = props.remove(jsonField);
            BasicMailTest.assertNotNull((String)("Missing field " + jsonField), (Object)value);
        }
        BasicMailTest.assertTrue((String)("Document contained more fields than requested: " + props.keySet()), (props.size() == 0 ? 1 : 0) != 0);
    }

    public void testTokenizedQuery() throws Exception {
        String t1 = BasicMailTest.randomUID();
        String t2 = BasicMailTest.randomUID();
        String t3 = BasicMailTest.randomUID();
        String[][] mailIds = this.importMail(this.testFolder.getFullName(), this.defaultAddress, t1 + " " + t2 + " " + t3, "");
        List<ActiveFacet> facets = this.prepareFacets();
        SimpleFacet globalFacet = (SimpleFacet)BasicMailTest.findByType((FacetType)CommonFacetType.GLOBAL, this.autocomplete(t1 + " " + t3));
        facets.add(BasicMailTest.createActiveFacet(globalFacet));
        List<PropDocument> documents = this.query(Module.MAIL, facets);
        BasicMailTest.assertTrue((String)"no document found", (0 < documents.size() ? 1 : 0) != 0);
        BasicMailTest.assertNotNull((String)"document not found", (Object)BasicMailTest.findByProperty(documents, "id", mailIds[0][1]));
        this.prepareFacets();
        globalFacet = (SimpleFacet)BasicMailTest.findByType((FacetType)CommonFacetType.GLOBAL, this.autocomplete("\"" + t1 + " " + t2 + "\""));
        facets.add(BasicMailTest.createActiveFacet(globalFacet));
        documents = this.query(Module.MAIL, facets);
        BasicMailTest.assertTrue((String)"no document found", (0 < documents.size() ? 1 : 0) != 0);
        BasicMailTest.assertNotNull((String)"document not found", (Object)BasicMailTest.findByProperty(documents, "id", mailIds[0][1]));
        this.prepareFacets();
        globalFacet = (SimpleFacet)BasicMailTest.findByType((FacetType)CommonFacetType.GLOBAL, this.autocomplete("\"" + t1 + " " + t3 + "\""));
        facets.add(BasicMailTest.createActiveFacet(globalFacet));
        documents = this.query(Module.MAIL, facets);
        BasicMailTest.assertTrue((String)"document found", (0 == documents.size() ? 1 : 0) != 0);
    }

    public void testTimeConversion() throws Exception {
        TimeZone clientTimeZone;
        TimeZone userTimeZone = this.client.getValues().getTimeZone();
        if (userTimeZone.equals(clientTimeZone = TimeZones.UTC)) {
            clientTimeZone = TimeZones.PST;
        }
        String subject = BasicMailTest.randomUID();
        String[][] mailIDs = this.importMail(this.testFolder.getFullName(), this.defaultAddress, subject, subject);
        GetRequest getMailReq = new GetRequest(mailIDs[0][0], mailIDs[0][1]);
        getMailReq.setTimeZone(clientTimeZone);
        GetResponse getMailResp = this.client.execute(getMailReq);
        long origReceivedDate = getMailResp.getMail(clientTimeZone).getReceivedDate().getTime();
        List<Facet> possibleFacets = this.autocomplete(subject);
        Facet subjectFacet = BasicMailTest.findByType((FacetType)MailFacetType.SUBJECT, possibleFacets);
        List<ActiveFacet> facets = this.prepareFacets();
        facets.add(BasicMailTest.createActiveFacet((SimpleFacet)subjectFacet));
        List<PropDocument> searchResults = this.query(facets, Collections.singletonMap("timezone", clientTimeZone.getID()));
        long foundReceivedDate = (Long)searchResults.get(0).getProps().get(MailJSONField.RECEIVED_DATE.getKey());
        BasicMailTest.assertEquals((String)"Wrong date conversion", (long)origReceivedDate, (long)foundReceivedDate);
    }

    @Override
    protected List<ActiveFacet> prepareFacets() throws OXException, IOException, JSONException {
        return this.prepareFacets(this.testFolder.getFullName());
    }
}

