/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.conversion;

import com.openexchange.ajax.conversion.AbstractConversionTest;
import com.openexchange.ajax.conversion.actions.ConvertRequest;
import com.openexchange.ajax.conversion.actions.ConvertResponse;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.mail.FolderAndID;
import com.openexchange.ajax.mail.contenttypes.MailContentType;
import com.openexchange.ajax.mail.netsol.actions.NetsolDeleteRequest;
import com.openexchange.ajax.mail.netsol.actions.NetsolGetRequest;
import com.openexchange.ajax.mail.netsol.actions.NetsolGetResponse;
import com.openexchange.ajax.mail.netsol.actions.NetsolSendRequest;
import com.openexchange.ajax.mail.netsol.actions.NetsolSendResponse;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailListField;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import java.io.InputStream;
import org.json.JSONArray;
import org.json.JSONObject;

public final class VCardMailPartImportTest
extends AbstractConversionTest {
    private static final byte[] VCARD_BYTES = String.valueOf("BEGIN:VCARD\nVERSION:2.1\nFN:Mustermann, Thomas\nN:Mustermann;Thomas;;Dipl.,Informatiker;\nBDAY:19851213\nADR;TYPE=work:;;Martinstr. 41;Olpe;NRW;57462;DE\nADR;TYPE=home:;;Musterstr. 10;Olpe;NRW;57666;Deutschland\nTEL;TYPE=work;TYPE=voice:+49 (2761) 8385-16\nTEL;TYPE=work;TYPE=fax:+49 (2761) 8385-30\nTEL;TYPE=home;TYPE=voice:+49 2761 / 843 157\nTEL;TYPE=cell;TYPE=voice:0171 / 835 72 89\nEMAIL:thomas.mustermann@open-xchange.com\nORG:OX Software GmbH;Development\nREV:20080818T064153.771Z\nUID:5@ox6-unstable.netline.de\nEND:VCARD").getBytes();

    public VCardMailPartImportTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVCardImport() throws Throwable {
        block16: {
            try {
                FolderAndID mailPath;
                String[] mailFolderAndMailID;
                JSONObject mailObject_25kb = new JSONObject();
                mailObject_25kb.put(MailJSONField.FROM.getKey(), (Object)this.getClient().getValues().getSendAddress());
                mailObject_25kb.put(MailJSONField.RECIPIENT_TO.getKey(), (Object)this.getClient().getValues().getSendAddress());
                mailObject_25kb.put(MailJSONField.RECIPIENT_CC.getKey(), (Object)"");
                mailObject_25kb.put(MailJSONField.RECIPIENT_BCC.getKey(), (Object)"");
                mailObject_25kb.put(MailJSONField.SUBJECT.getKey(), (Object)"The mail subject");
                mailObject_25kb.put(MailJSONField.PRIORITY.getKey(), (Object)"3");
                JSONObject bodyObject = new JSONObject();
                bodyObject.put(MailJSONField.CONTENT_TYPE.getKey(), (Object)MailContentType.ALTERNATIVE.toString());
                bodyObject.put(MailJSONField.CONTENT.getKey(), (Object)"Mail text.<br /><br />People have been asking for support for the IMAP IDLE command for quite<br />a few years and I think I've finally figured out how to provide such<br />support safely.  The difficulty isn't in executing the command, which<br />is quite straightforward, the difficulty is in deciding how to expose<br />it to applications, and inhandling the multithreading issues that<br />arise.<br /><br />After three attempts, I've got a version that seems to work.  It passes<br />all my tests, including a multithreading test I wrote just for this<br />purpose.  So now it's time for others to try it out as well.  Below is<br />my writeup on how to use the IDLE command.  You can find the test<br />version of JavaMail (essentially an early version of JavaMail 1.4.1)<br />in the java.net Maven repository (you want the 1.4.1ea version):<br /><br />https://maven-repository.dev.java.net/nonav/repository/javax.mail/<br /><br />Note that this version is built with JDK 1.5 and thus requires JDK 1.5.<br /><br />Oh,and here's the entire list of what's fixed in this version so far:<br /><br />4107594 IMAP implementation should use the IDLE extension if available<br />6423701 Problem with using OrTerm when the protocol is IMAP<br />6431207 SMTP is adding extra CRLF to message content<br />6447295 IMAPMessage fails to return Content-Language from bodystructure<br />6447799 encoded text not decoded even when mail.mime.decodetext.strict is false<br />6447801 MimeBodyPart.writeTo reencodes data unnecessarily<br />6456422 NullPointerException in smtptransport when sending MimeMessages<br />        with no encoding<br />6456444 MimeMessages created from stream are not correctly handled<br />        with allow8bitmime<br />&lt;no id&gt; fix performance bug in base64 encoder; now even faster!");
                JSONArray attachments = new JSONArray();
                attachments.put((Object)bodyObject);
                mailObject_25kb.put(MailJSONField.ATTACHMENTS.getKey(), (Object)attachments);
                UnsynchronizedByteArrayInputStream in = null;
                try {
                    in = new UnsynchronizedByteArrayInputStream(VCARD_BYTES);
                    NetsolSendResponse response = Executor.execute(this.getSession(), new NetsolSendRequest(mailObject_25kb.toString(), (InputStream)in, "text/x-vcard; charset=US-ASCII", "vcard.vcf"));
                    VCardMailPartImportTest.assertTrue((String)"Send failed", (response.getFolderAndID() != null ? 1 : 0) != 0);
                    VCardMailPartImportTest.assertTrue((String)"Duration corrupt", (response.getRequestDuration() > 0L ? 1 : 0) != 0);
                    mailFolderAndMailID = response.getFolderAndID();
                }
                finally {
                    if (null != in) {
                        in.close();
                    }
                }
                try {
                    Long.parseLong(mailFolderAndMailID[1]);
                }
                catch (NumberFormatException e) {
                    int pos = mailFolderAndMailID[1].lastIndexOf(47);
                    if (pos == -1 && (pos = mailFolderAndMailID[1].lastIndexOf(46)) == -1) {
                        VCardMailPartImportTest.fail((String)("UNKNOWN FORMAT FOR MAIL ID: " + mailFolderAndMailID[1]));
                    }
                    String substr = mailFolderAndMailID[1].substring(pos + 1);
                    try {
                        Long.parseLong(substr);
                    }
                    catch (NumberFormatException e1) {
                        VCardMailPartImportTest.fail((String)("UNKNOWN FORMAT FOR MAIL ID: " + mailFolderAndMailID[1]));
                    }
                    mailFolderAndMailID[1] = substr;
                }
                try {
                    mailPath = new FolderAndID(mailFolderAndMailID[0], mailFolderAndMailID[1]);
                    NetsolGetResponse resp = Executor.execute(this.getSession(), new NetsolGetRequest(mailPath, true));
                    JSONObject mailObject = (JSONObject)resp.getData();
                    JSONArray attachments2 = mailObject.getJSONArray(MailJSONField.ATTACHMENTS.getKey());
                    int len = attachments2.length();
                    String sequenceId = null;
                    for (int i = 0; i < len && sequenceId == null; ++i) {
                        JSONObject attachObj = attachments2.getJSONObject(i);
                        if (!attachObj.getString(MailJSONField.CONTENT_TYPE.getKey()).startsWith("text/x-vcard")) continue;
                        sequenceId = attachObj.getString(MailListField.ID.getKey());
                    }
                    JSONObject jsonBody = new JSONObject();
                    JSONObject jsonSource = new JSONObject().put("identifier", (Object)"com.openexchange.mail.vcard");
                    jsonSource.put("args", (Object)new JSONArray().put((Object)new JSONObject().put("com.openexchange.mail.conversion.fullname", (Object)mailFolderAndMailID[0])).put((Object)new JSONObject().put("com.openexchange.mail.conversion.mailid", (Object)mailFolderAndMailID[1])).put((Object)new JSONObject().put("com.openexchange.mail.conversion.sequenceid", (Object)sequenceId)));
                    jsonBody.put("datasource", (Object)jsonSource);
                    JSONObject jsonHandler = new JSONObject().put("identifier", (Object)"com.openexchange.contact");
                    jsonHandler.put("args", (Object)new JSONArray().put((Object)new JSONObject().put("com.openexchange.groupware.contact.folder", this.getPrivateContactFolder())));
                    jsonBody.put("datahandler", (Object)jsonHandler);
                    ConvertResponse convertResponse = (ConvertResponse)((Object)Executor.execute(this.getSession(), new ConvertRequest(jsonBody, true)));
                    String[][] sa = convertResponse.getFoldersAndIDs();
                    VCardMailPartImportTest.assertFalse((String)"Missing response on action=convert", (sa == null ? 1 : 0) != 0);
                    VCardMailPartImportTest.assertTrue((String)"Unexpected response length", (sa.length == 1 ? 1 : 0) != 0);
                    if (mailFolderAndMailID == null) break block16;
                    mailPath = new FolderAndID(mailFolderAndMailID[0], mailFolderAndMailID[1]);
                }
                catch (Throwable throwable) {
                    if (mailFolderAndMailID != null) {
                        FolderAndID mailPath2 = new FolderAndID(mailFolderAndMailID[0], mailFolderAndMailID[1]);
                        Executor.execute(this.getSession(), new NetsolDeleteRequest(new FolderAndID[]{mailPath2}, true));
                    }
                    throw throwable;
                }
                Executor.execute(this.getSession(), new NetsolDeleteRequest(new FolderAndID[]{mailPath}, true));
            }
            catch (Exception e) {
                e.printStackTrace();
                VCardMailPartImportTest.fail((String)e.getMessage());
            }
        }
    }
}

