/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.test.CalendarTestManager;
import java.util.TimeZone;
import org.junit.Test;

public class Bug32465Test
extends AbstractAJAXSession {
    private CalendarTestManager ctm;
    private Appointment appointment;

    public Bug32465Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.ctm = new CalendarTestManager(this.getClient());
        this.appointment = new Appointment();
        this.appointment.setTitle("Bug 32465 Test");
        this.appointment.setStartDate(TimeTools.D("01.06.2014 00:00", TimeZone.getTimeZone("UTC")));
        this.appointment.setEndDate(TimeTools.D("02.06.2014 00:00", TimeZone.getTimeZone("UTC")));
        this.appointment.setFullTime(true);
        this.appointment.setRecurrenceType(1);
        this.appointment.setInterval(1);
        this.appointment.setOccurrence(12);
        this.appointment.setParentFolderID(this.getClient().getValues().getPrivateAppointmentFolder());
        this.appointment.setIgnoreConflicts(true);
        this.ctm.insert(this.appointment);
    }

    @Test
    public void testBug32465() throws Exception {
        this.appointment.setOccurrence(13);
        this.ctm.update(this.appointment);
        Appointment loadedAppointment = this.ctm.get(this.appointment);
        System.out.println(loadedAppointment.getStartDate());
        System.out.println(loadedAppointment.getEndDate());
    }

    @Override
    public void tearDown() throws Exception {
        this.ctm.cleanUp();
        super.tearDown();
    }
}

