/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.test.CalendarTestManager;

public class Bug30118Test
extends AbstractAJAXSession {
    private CalendarTestManager ctm;
    private Appointment appointment;

    public Bug30118Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.ctm = new CalendarTestManager(this.client);
        this.appointment = new Appointment();
        this.appointment.setTitle("Bug 30118 Test");
        this.appointment.setStartDate(TimeTools.D("17.12.2013 08:00"));
        this.appointment.setEndDate(TimeTools.D("18.12.2013 09:00"));
        this.appointment.setRecurrenceType(1);
        this.appointment.setInterval(1);
        this.appointment.setOccurrence(5);
        this.appointment.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.appointment.setIgnoreConflicts(true);
    }

    public void testBug30118() throws Exception {
        this.ctm.insert(this.appointment);
        this.ctm.createDeleteException(this.appointment.getParentFolderID(), this.appointment.getObjectID(), 3);
        Appointment loaded = this.ctm.get(this.appointment);
        Bug30118Test.assertTrue((String)"Expected one delete Exception.", (loaded.getDeleteException() != null && loaded.getDeleteException().length == 1 ? 1 : 0) != 0);
    }

    public void testBug30118Fulltime() throws Exception {
        this.appointment.setStartDate(TimeTools.D("17.12.2013 00:00"));
        this.appointment.setEndDate(TimeTools.D("18.12.2013 00:00"));
        this.appointment.setFullTime(true);
        this.ctm.insert(this.appointment);
        this.ctm.createDeleteException(this.appointment.getParentFolderID(), this.appointment.getObjectID(), 3);
        Appointment loaded = this.ctm.get(this.appointment);
        Bug30118Test.assertTrue((String)"Expected one delete Exception.", (loaded.getDeleteException() != null && loaded.getDeleteException().length == 1 ? 1 : 0) != 0);
    }

    public void testBug30118Fulltime2days() throws Exception {
        this.appointment.setStartDate(TimeTools.D("17.12.2013 00:00"));
        this.appointment.setEndDate(TimeTools.D("19.12.2013 00:00"));
        this.appointment.setFullTime(true);
        this.ctm.insert(this.appointment);
        this.ctm.createDeleteException(this.appointment.getParentFolderID(), this.appointment.getObjectID(), 3);
        Appointment loaded = this.ctm.get(this.appointment);
        Bug30118Test.assertTrue((String)"Expected one delete Exception.", (loaded.getDeleteException() != null && loaded.getDeleteException().length == 1 ? 1 : 0) != 0);
    }

    @Override
    public void tearDown() throws Exception {
        this.ctm.cleanUp();
        super.tearDown();
    }
}

