/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.ConflictObject;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.container.participants.ConfirmableParticipant;
import com.openexchange.test.CalendarTestManager;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class ConfirmOccurrencesTest
extends AbstractAJAXSession {
    private AJAXClient client1;
    private AJAXClient client2;
    private CalendarTestManager ctm;
    private Appointment appointment;
    private int nextYear;
    private int occurrence = 5;
    private static int NOT_EXISTENT = -9999;
    private static final int[] COLS = new int[]{1, 20, 206, 207, 200, 226, 221, 220, 207};

    public ConfirmOccurrencesTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client1 = this.client;
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.ctm = new CalendarTestManager(this.client1);
        this.nextYear = Calendar.getInstance().get(1) + 1;
        this.appointment = new Appointment();
        this.appointment.setTitle("Test for occurrence based confirmations.");
        this.appointment.setStartDate(TimeTools.D("01.02." + this.nextYear + " 08:00"));
        this.appointment.setEndDate(TimeTools.D("01.02." + this.nextYear + " 09:00"));
        this.appointment.setRecurrenceType(1);
        this.appointment.setInterval(1);
        this.appointment.setOccurrence(10);
        this.appointment.setParentFolderID(this.client1.getValues().getPrivateAppointmentFolder());
        this.appointment.setIgnoreConflicts(true);
        UserParticipant user1 = new UserParticipant(this.client1.getValues().getUserId());
        UserParticipant user2 = new UserParticipant(this.client2.getValues().getUserId());
        ExternalUserParticipant external1 = new ExternalUserParticipant("external1@example.com");
        ExternalUserParticipant external2 = new ExternalUserParticipant("external2@example.com");
        this.appointment.setParticipants(new Participant[]{user1, user2, external1, external2});
        this.ctm.insert(this.appointment);
    }

    public void testConfirmationSetCorrectlyForOccurrence() throws Exception {
    }

    public void testConfirmSeries() throws Exception {
        Appointment[] apps;
        this.ctm.setClient(this.client1);
        this.ctm.confirm(this.appointment, 3, "tentative");
        this.ctm.confirmExternal(this.appointment, "external1@example.com", 3, "tentative");
        this.ctm.confirmExternal(this.appointment, "external2@example.com", 3, "tentative");
        this.ctm.setClient(this.client2);
        this.ctm.confirm(this.appointment, 3, "tentative");
        this.ctm.setClient(this.client1);
        Appointment loadedAppointment = this.ctm.get(this.appointment);
        this.checkConfirmations(loadedAppointment, 3, "tentative", 2, 0);
        for (Appointment app : apps = this.ctm.all(this.client1.getValues().getPrivateAppointmentFolder(), TimeTools.D("01.02." + this.nextYear + " 08:00"), TimeTools.D("11.02." + this.nextYear + " 09:00"), COLS, false)) {
            if (app.getObjectID() != this.appointment.getObjectID()) continue;
            this.checkConfirmations(app, 3, "tentative", 2);
        }
    }

    public void testException() throws Exception {
        Appointment[] apps;
        this.ctm.setClient(this.client1);
        this.ctm.confirm(this.appointment, 3, "tentative");
        this.ctm.confirmExternal(this.appointment, "external1@example.com", 3, "tentative");
        this.ctm.confirmExternal(this.appointment, "external2@example.com", 3, "tentative");
        this.ctm.setClient(this.client2);
        this.ctm.confirm(this.appointment, 3, "tentative");
        this.ctm.setClient(this.client1);
        Appointment exception = this.ctm.createIdentifyingCopy(this.appointment);
        exception.setStartDate(TimeTools.D("05.02." + this.nextYear + " 10:00"));
        exception.setEndDate(TimeTools.D("05.02." + this.nextYear + " 12:00"));
        exception.setRecurrencePosition(this.occurrence);
        exception.setTitle(this.appointment.getTitle() + " - Exception");
        exception.setLastModified(new Date(Long.MAX_VALUE));
        this.ctm.update(exception);
        this.appointment.setLastModified(exception.getLastModified());
        this.ctm.confirm(exception, 2, "decline");
        this.ctm.confirmExternal(exception, "external1@example.com", 2, "decline");
        this.ctm.confirmExternal(exception, "external2@example.com", 2, "decline");
        this.ctm.setClient(this.client2);
        this.ctm.confirm(exception, 2, "decline");
        this.ctm.setClient(this.client1);
        Appointment loadedAppointment = this.ctm.get(this.appointment);
        this.checkConfirmations(loadedAppointment, 3, "tentative", 2, 0);
        for (Appointment app : apps = this.ctm.all(this.client1.getValues().getPrivateAppointmentFolder(), TimeTools.D("01.02." + this.nextYear + " 08:00"), TimeTools.D("11.02." + this.nextYear + " 09:00"), COLS, false)) {
            if (app.getObjectID() != this.appointment.getObjectID()) continue;
            this.checkConfirmations(app, 3, "tentative", 2);
        }
        loadedAppointment = this.ctm.get(exception);
        this.checkConfirmations(loadedAppointment, 2, "decline", 2);
    }

    public void testOccurrence() throws Exception {
        Appointment[] apps;
        this.ctm.setClient(this.client1);
        this.ctm.confirm(this.appointment, 3, "tentative");
        this.ctm.confirmExternal(this.appointment, "external1@example.com", 3, "tentative");
        this.ctm.confirmExternal(this.appointment, "external2@example.com", 3, "tentative");
        this.ctm.setClient(this.client2);
        this.ctm.confirm(this.appointment, 3, "tentative");
        this.ctm.setClient(this.client1);
        this.ctm.confirm(this.appointment, 2, "decline", this.occurrence);
        this.ctm.confirmExternal(this.appointment, "external1@example.com", 2, "decline", this.occurrence);
        this.ctm.confirmExternal(this.appointment, "external2@example.com", 2, "decline", this.occurrence);
        this.ctm.setClient(this.client2);
        this.ctm.confirm(this.appointment, 2, "decline", this.occurrence);
        this.ctm.setClient(this.client1);
        Appointment loadedAppointment = this.ctm.get(this.appointment);
        this.checkConfirmations(loadedAppointment, 3, "tentative", 2, 0);
        for (Appointment app : apps = this.ctm.all(this.client1.getValues().getPrivateAppointmentFolder(), TimeTools.D("01.02." + this.nextYear + " 08:00"), TimeTools.D("11.02." + this.nextYear + " 09:00"), COLS, false)) {
            if (app.getObjectID() != this.appointment.getObjectID()) continue;
            if (app.getRecurrencePosition() == this.occurrence) {
                this.checkConfirmations(app, 2, "decline", 2);
                continue;
            }
            this.checkConfirmations(app, 3, "tentative", 2);
        }
    }

    public void testOccurrenceOnExistingException() throws Exception {
        Appointment[] apps;
        this.ctm.setClient(this.client1);
        this.ctm.confirm(this.appointment, 3, "tentative");
        this.ctm.confirmExternal(this.appointment, "external1@example.com", 3, "tentative");
        this.ctm.confirmExternal(this.appointment, "external2@example.com", 3, "tentative");
        this.ctm.setClient(this.client2);
        this.ctm.confirm(this.appointment, 3, "tentative");
        this.ctm.setClient(this.client1);
        Appointment exception = this.ctm.createIdentifyingCopy(this.appointment);
        exception.setStartDate(TimeTools.D("05.02." + this.nextYear + " 10:00"));
        exception.setEndDate(TimeTools.D("05.02." + this.nextYear + " 12:00"));
        exception.setRecurrencePosition(this.occurrence);
        exception.setTitle(this.appointment.getTitle() + " - Exception");
        exception.setLastModified(new Date(Long.MAX_VALUE));
        this.ctm.update(exception);
        this.appointment.setLastModified(exception.getLastModified());
        this.ctm.confirm(exception, 2, "decline");
        this.ctm.confirmExternal(exception, "external1@example.com", 2, "decline");
        this.ctm.confirmExternal(exception, "external2@example.com", 2, "decline");
        this.ctm.setClient(this.client2);
        this.ctm.confirm(exception, 2, "decline");
        this.ctm.setClient(this.client1);
        Appointment loadedAppointment = this.ctm.get(this.appointment);
        this.checkConfirmations(loadedAppointment, 3, "tentative", 2);
        for (Appointment app : apps = this.ctm.all(this.client1.getValues().getPrivateAppointmentFolder(), TimeTools.D("01.02." + this.nextYear + " 08:00"), TimeTools.D("11.02." + this.nextYear + " 09:00"), COLS, false)) {
            if (app.getObjectID() != this.appointment.getObjectID()) continue;
            this.checkConfirmations(app, 3, "tentative", 2);
        }
        loadedAppointment = this.ctm.get(exception);
        this.checkConfirmations(loadedAppointment, 2, "decline", 2, 0);
        this.ctm.confirm(this.appointment, 1, "accept", this.occurrence);
        this.ctm.confirmExternal(this.appointment, "external1@example.com", 1, "accept", this.occurrence);
        this.ctm.confirmExternal(this.appointment, "external2@example.com", 1, "accept", this.occurrence);
        this.ctm.setClient(this.client2);
        this.ctm.confirm(this.appointment, 1, "accept", this.occurrence);
        this.ctm.setClient(this.client1);
        loadedAppointment = this.ctm.get(this.appointment);
        this.checkConfirmations(loadedAppointment, 3, "tentative", 2);
        for (Appointment app : apps = this.ctm.all(this.client1.getValues().getPrivateAppointmentFolder(), TimeTools.D("01.02." + this.nextYear + " 08:00"), TimeTools.D("11.02." + this.nextYear + " 09:00"), COLS, false)) {
            if (app.getObjectID() != this.appointment.getObjectID()) continue;
            this.checkConfirmations(app, 3, "tentative", 2);
        }
        loadedAppointment = this.ctm.get(exception);
        this.checkConfirmations(loadedAppointment, 1, "accept", 2, 0);
    }

    public void testConflicts() throws Exception {
        this.ctm.setClient(this.client1);
        this.ctm.confirm(this.appointment, 1, "accept");
        this.ctm.confirmExternal(this.appointment, "external1@example.com", 1, "accept");
        this.ctm.confirmExternal(this.appointment, "external2@example.com", 1, "accept");
        this.ctm.setClient(this.client2);
        this.ctm.confirm(this.appointment, 1, "accept");
        this.ctm.setClient(this.client1);
        this.ctm.confirm(this.appointment, 2, "decline", this.occurrence);
        this.ctm.confirmExternal(this.appointment, "external1@example.com", 2, "decline", this.occurrence);
        this.ctm.confirmExternal(this.appointment, "external2@example.com", 2, "decline", this.occurrence);
        this.ctm.setClient(this.client2);
        this.ctm.confirm(this.appointment, 2, "decline", this.occurrence);
        this.ctm.setClient(this.client1);
        Appointment loadedAppointment = this.ctm.get(this.appointment);
        this.checkConfirmations(loadedAppointment, 1, "accept", 2, 0);
        Appointment conflict = new Appointment();
        conflict.setTitle("Test for occurrence based confirmations. - CONFLICT");
        conflict.setStartDate(TimeTools.D("05.02." + this.nextYear + " 08:00"));
        conflict.setEndDate(TimeTools.D("05.02." + this.nextYear + " 09:00"));
        conflict.setParentFolderID(this.client1.getValues().getPrivateAppointmentFolder());
        conflict.setIgnoreConflicts(false);
        this.ctm.insert(conflict);
        List<ConflictObject> conflicts = ((AppointmentInsertResponse)this.ctm.getLastResponse()).getConflicts();
        boolean foundBadConflict = false;
        if (conflicts != null) {
            for (ConflictObject co : conflicts) {
                if (co.getId() != this.appointment.getObjectID()) continue;
                foundBadConflict = true;
                break;
            }
        }
        ConfirmOccurrencesTest.assertFalse((String)"Found conflict", (boolean)foundBadConflict);
    }

    private void checkConfirmations(Appointment appointment, int status, String message, int participantAmount) {
        this.checkConfirmations(appointment, status, message, participantAmount, NOT_EXISTENT);
    }

    private void checkConfirmations(Appointment appointment, int status, String message, int participantAmount, int expectedOccurrence) {
        ConfirmOccurrencesTest.assertEquals((String)"Wrong amount of participants.", (int)participantAmount, (int)appointment.getConfirmations().length);
        ConfirmOccurrencesTest.assertEquals((String)"Wrong amount of participants.", (int)participantAmount, (int)appointment.getUsers().length);
        for (ConfirmableParticipant confirmableParticipant : appointment.getConfirmations()) {
            ConfirmOccurrencesTest.assertEquals((String)"Wrong confirmation status.", (int)status, (int)confirmableParticipant.getConfirm());
            ConfirmOccurrencesTest.assertEquals((String)"Wrong confirmation message.", (String)message, (String)confirmableParticipant.getMessage());
        }
        for (ConfirmableParticipant confirmableParticipant : appointment.getUsers()) {
            ConfirmOccurrencesTest.assertEquals((String)"Wrong confirmation status.", (int)status, (int)confirmableParticipant.getConfirm());
            ConfirmOccurrencesTest.assertEquals((String)"Wrong confirmation message.", (String)message, (String)confirmableParticipant.getConfirmMessage());
        }
    }

    @Override
    public void tearDown() throws Exception {
        this.ctm.cleanUp();
        super.tearDown();
    }
}

