/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.mbox;

import com.sun.mail.mbox.ContentLengthCounter;
import com.sun.mail.mbox.ContentLengthUpdater;
import com.sun.mail.mbox.InboxFile;
import com.sun.mail.mbox.MailFile;
import com.sun.mail.mbox.Match;
import com.sun.mail.mbox.MboxMessage;
import com.sun.mail.mbox.MboxStore;
import com.sun.mail.mbox.MessageLoader;
import com.sun.mail.mbox.NewlineOutputStream;
import com.sun.mail.mbox.TempFile;
import com.sun.mail.mbox.UNIXFile;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.SharedInputStream;

public class MboxFolder
extends Folder {
    private String name;
    private boolean is_inbox = false;
    private int total;
    private volatile boolean opened = false;
    private List messages;
    private TempFile temp;
    private MboxStore mstore;
    private MailFile folder;
    private long file_size;
    private long saved_file_size;
    private boolean special_imap_message;
    private static final boolean homeRelative = Boolean.getBoolean("mail.mbox.homerelative");

    public MboxFolder(MboxStore store, String name) {
        super(store);
        this.mstore = store;
        this.name = name;
        if (name != null && name.equalsIgnoreCase("INBOX")) {
            this.is_inbox = true;
        }
        this.folder = this.mstore.getMailFile(name == null ? "~" : name);
        this.saved_file_size = this.folder.exists() ? this.folder.length() : -1L;
    }

    @Override
    public char getSeparator() {
        return File.separatorChar;
    }

    @Override
    public Folder[] list(String pattern) throws MessagingException {
        if (!this.folder.isDirectory()) {
            throw new MessagingException("not a directory");
        }
        if (this.name == null) {
            return this.list(null, pattern, true);
        }
        return this.list(this.name + File.separator, pattern, false);
    }

    protected Folder[] list(String ref, String pattern, boolean fromStore) throws MessagingException {
        if (ref != null && ref.length() == 0) {
            ref = null;
        }
        String refdir = null;
        String realdir = null;
        int i = MboxFolder.indexOfAny(pattern = MboxFolder.canonicalize(ref, pattern), "%*");
        refdir = i >= 0 ? pattern.substring(0, i) : pattern;
        i = refdir.lastIndexOf(File.separatorChar);
        if (i >= 0) {
            refdir = refdir.substring(0, i + 1);
            realdir = this.mstore.mb.filename(this.mstore.user, refdir);
        } else if (refdir.length() == 0 || refdir.charAt(0) != '~') {
            refdir = null;
            realdir = homeRelative ? this.mstore.home : ".";
        } else {
            realdir = this.mstore.mb.filename(this.mstore.user, refdir);
        }
        Vector<String> flist = new Vector<String>();
        this.listWork(realdir, refdir, pattern, fromStore ? 0 : 1, flist);
        if (Match.path("INBOX", pattern, '\u0000')) {
            flist.addElement("INBOX");
        }
        Folder[] fl = new Folder[flist.size()];
        for (i = 0; i < fl.length; ++i) {
            fl[i] = this.createFolder(this.mstore, (String)flist.elementAt(i));
        }
        return fl;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return "";
        }
        if (this.is_inbox) {
            return "INBOX";
        }
        return this.folder.getName();
    }

    @Override
    public String getFullName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    @Override
    public Folder getParent() {
        if (this.name == null) {
            return null;
        }
        if (this.is_inbox) {
            return this.createFolder(this.mstore, null);
        }
        return this.createFolder(this.mstore, this.folder.getParent());
    }

    @Override
    public boolean exists() {
        return this.folder.exists();
    }

    @Override
    public int getType() {
        if (this.folder.isDirectory()) {
            return 2;
        }
        return 1;
    }

    @Override
    public Flags getPermanentFlags() {
        return MboxStore.permFlags;
    }

    @Override
    public synchronized boolean hasNewMessages() {
        if (this.folder instanceof UNIXFile) {
            UNIXFile f = (UNIXFile)((Object)this.folder);
            if (f.length() > 0L) {
                long mtime;
                long atime = f.lastAccessed();
                return atime < (mtime = f.lastModified());
            }
            return false;
        }
        long current_size = this.folder.exists() ? this.folder.length() : -1L;
        if (this.saved_file_size < 0L) {
            this.saved_file_size = current_size;
        }
        return current_size > this.saved_file_size;
    }

    @Override
    public synchronized Folder getFolder(String name) throws MessagingException {
        if (this.folder.exists() && !this.folder.isDirectory()) {
            throw new MessagingException("not a directory");
        }
        return this.createFolder(this.mstore, (this.name == null ? "~" : this.name) + File.separator + name);
    }

    @Override
    public synchronized boolean create(int type) throws MessagingException {
        switch (type) {
            case 2: {
                if (this.folder.mkdirs()) break;
                return false;
            }
            case 1: {
                if (this.folder.exists()) {
                    return false;
                }
                try {
                    new FileOutputStream((File)((Object)this.folder)).close();
                    break;
                }
                catch (FileNotFoundException fe) {
                    File parent = new File(this.folder.getParent());
                    if (!parent.mkdirs()) {
                        throw new MessagingException("can't create folder: " + this.name);
                    }
                    try {
                        new FileOutputStream((File)((Object)this.folder)).close();
                        break;
                    }
                    catch (IOException ex3) {
                        throw new MessagingException("can't create folder: " + this.name, ex3);
                    }
                }
                catch (IOException e) {
                    throw new MessagingException("can't create folder: " + this.name, e);
                }
            }
            default: {
                throw new MessagingException("type not supported");
            }
        }
        this.notifyFolderListeners(1);
        return true;
    }

    @Override
    public synchronized boolean delete(boolean recurse) throws MessagingException {
        this.checkClosed();
        if (this.name == null) {
            throw new MessagingException("can't delete default folder");
        }
        boolean ret = true;
        if (recurse && this.folder.isDirectory()) {
            ret = this.delete(new File(this.folder.getPath()));
        }
        if (ret && this.folder.delete()) {
            this.notifyFolderListeners(2);
            return true;
        }
        return false;
    }

    private boolean delete(File f) {
        File[] files = f.listFiles();
        boolean ret = true;
        for (int i = 0; ret && i < files.length; ++i) {
            ret = files[i].isDirectory() ? this.delete(files[i]) : files[i].delete();
        }
        return ret;
    }

    @Override
    public synchronized boolean renameTo(Folder f) throws MessagingException {
        this.checkClosed();
        if (this.name == null) {
            throw new MessagingException("can't rename default folder");
        }
        if (!(f instanceof MboxFolder)) {
            throw new MessagingException("can't rename to: " + f.getName());
        }
        String newname = ((MboxFolder)f).folder.getPath();
        if (this.folder.renameTo(new File(newname))) {
            this.notifyFolderRenamedListeners(f);
            return true;
        }
        return false;
    }

    void checkOpen() throws IllegalStateException {
        if (!this.opened) {
            throw new IllegalStateException("Folder is not Open");
        }
    }

    private void checkClosed() throws IllegalStateException {
        if (this.opened) {
            throw new IllegalStateException("Folder is Open");
        }
    }

    private void checkRange(int msgno) throws MessagingException {
        if (msgno < 1) {
            throw new IndexOutOfBoundsException("message number < 1");
        }
        if (msgno <= this.total) {
            return;
        }
        this.getMessageCount();
        if (msgno > this.total) {
            throw new IndexOutOfBoundsException(msgno + " > " + this.total);
        }
    }

    private void checkReadable() throws IllegalStateException {
        if (!this.opened || this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException("Folder is not Readable");
        }
    }

    private void checkWritable() throws IllegalStateException {
        if (!this.opened || this.mode != 2) {
            throw new IllegalStateException("Folder is not Writable");
        }
    }

    @Override
    public boolean isOpen() {
        return this.opened;
    }

    @Override
    public synchronized void open(int mode) throws MessagingException {
        InboxFile inf;
        if (this.opened) {
            throw new IllegalStateException("Folder is already Open");
        }
        if (!this.folder.exists()) {
            throw new FolderNotFoundException(this, "Folder doesn't exist: " + this.folder.getPath());
        }
        this.mode = mode;
        switch (mode) {
            default: {
                if (this.folder.canWrite()) break;
                throw new MessagingException("Open Failure, can't write: " + this.folder.getPath());
            }
            case 1: 
        }
        if (!this.folder.canRead()) {
            throw new MessagingException("Open Failure, can't read: " + this.folder.getPath());
        }
        if (this.is_inbox && this.folder instanceof InboxFile && !(inf = (InboxFile)this.folder).openLock(mode == 2 ? "rw" : "r")) {
            throw new MessagingException("Failed to lock INBOX");
        }
        if (!this.folder.lock("r")) {
            throw new MessagingException("Failed to lock folder: " + this.name);
        }
        this.messages = new ArrayList();
        this.total = 0;
        Message[] msglist = null;
        try {
            this.temp = new TempFile(null);
            this.saved_file_size = this.folder.length();
            msglist = this.load(0L, false);
        }
        catch (IOException e) {
            throw new MessagingException("IOException", e);
        }
        finally {
            this.folder.unlock();
        }
        this.notifyConnectionListeners(1);
        if (msglist != null) {
            this.notifyMessageAddedListeners(msglist);
        }
        this.opened = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(boolean expunge) throws MessagingException {
        this.checkOpen();
        try {
            if (this.mode == 2) {
                try {
                    this.writeFolder(true, expunge);
                }
                catch (IOException e) {
                    throw new MessagingException("I/O Exception", e);
                }
            }
            this.messages = null;
        }
        finally {
            this.opened = false;
            if (this.is_inbox && this.folder instanceof InboxFile) {
                InboxFile inf = (InboxFile)this.folder;
                inf.closeLock();
            }
            this.temp.close();
            this.temp = null;
            this.notifyConnectionListeners(3);
        }
    }

    protected int writeFolder(boolean closing, boolean expunge) throws IOException, MessagingException {
        int modified = 0;
        int deleted = 0;
        int recent = 0;
        for (int msgno = 1; msgno <= this.total; ++msgno) {
            MessageMetadata md = (MessageMetadata)this.messages.get(this.messageIndexOf(msgno));
            MboxMessage msg = md.message;
            if (msg != null) {
                Flags flags = msg.getFlags();
                if (msg.isModified() || !msg.origFlags.equals(flags)) {
                    ++modified;
                }
                if (flags.contains(Flags.Flag.DELETED)) {
                    ++deleted;
                }
                if (!flags.contains(Flags.Flag.RECENT)) continue;
                ++recent;
                continue;
            }
            if (md.deleted) {
                ++deleted;
            }
            if (!md.recent) continue;
            ++recent;
        }
        if (!(closing && recent != 0 || expunge && deleted != 0 || modified != 0)) {
            return 0;
        }
        if (!this.folder.lock("rw")) {
            throw new MessagingException("Failed to lock folder: " + this.name);
        }
        int oldtotal = this.total;
        Message[] msglist = null;
        if (this.folder.length() != this.file_size) {
            msglist = this.load(this.file_size, !closing);
        }
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream((File)((Object)this.folder)));
        int wr = 0;
        boolean keep = true;
        try {
            String skeep;
            if (this.special_imap_message) {
                MboxFolder.appendStream(this.getMessageStream(0), os);
            }
            for (int msgno = 1; msgno <= this.total; ++msgno) {
                MessageMetadata md = (MessageMetadata)this.messages.get(this.messageIndexOf(msgno));
                MboxMessage msg = md.message;
                if (msg != null) {
                    if (expunge && msg.isSet(Flags.Flag.DELETED)) continue;
                    if (closing && msgno <= oldtotal && msg.isSet(Flags.Flag.RECENT)) {
                        msg.setFlag(Flags.Flag.RECENT, false);
                    }
                    MboxFolder.writeMboxMessage(msg, os);
                } else {
                    if (expunge && md.deleted) continue;
                    if (closing && msgno <= oldtotal && md.recent) {
                        msg = (MboxMessage)this.getMessage(msgno);
                        msg.setFlag(Flags.Flag.RECENT, false);
                        MboxFolder.writeMboxMessage(msg, os);
                    } else {
                        MboxFolder.appendStream(this.getMessageStream(msgno), os);
                    }
                }
                this.folder.touchlock();
                ++wr;
            }
            this.file_size = this.saved_file_size = this.folder.length();
            if (wr == 0 && closing && (skeep = ((MboxStore)this.store).getSession().getProperty("mail.mbox.deleteEmpty")) != null && skeep.equalsIgnoreCase("true")) {
                keep = false;
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (MessagingException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MessagingException("unexpected exception " + e);
        }
        finally {
            try {
                ((OutputStream)os).close();
                if (!keep) {
                    this.folder.delete();
                    this.file_size = 0L;
                }
            }
            catch (IOException ex) {}
            if (keep) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {}
                FileInputStream is = null;
                try {
                    is = new FileInputStream((File)((Object)this.folder));
                    ((InputStream)is).read();
                }
                catch (IOException ex) {}
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                    is = null;
                }
                catch (IOException ex) {}
            }
            this.folder.unlock();
            if (msglist != null) {
                this.notifyMessageAddedListeners(msglist);
            }
        }
        return wr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void appendStream(InputStream is, OutputStream os) throws IOException {
        try {
            int len;
            byte[] buf = new byte[65536];
            while ((len = is.read(buf)) > 0) {
                os.write(buf, 0, len);
            }
        }
        finally {
            is.close();
        }
    }

    public static void writeMboxMessage(MimeMessage msg, OutputStream os) throws IOException, MessagingException {
        try {
            if (msg instanceof MboxMessage) {
                ((MboxMessage)msg).writeToFile(os);
            } else {
                MboxMessage.setHeadersFromFlags(msg);
                ContentLengthCounter cos = new ContentLengthCounter();
                NewlineOutputStream nos = new NewlineOutputStream(cos);
                msg.writeTo(nos);
                nos.flush();
                os = new NewlineOutputStream(os);
                os = new ContentLengthUpdater(os, cos.getSize());
                PrintStream pos = new PrintStream(os, false, "iso-8859-1");
                pos.println(MboxFolder.getUnixFrom(msg));
                msg.writeTo(pos);
                pos.println();
                pos.flush();
            }
        }
        catch (MessagingException me) {
            throw me;
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    protected static String getUnixFrom(MimeMessage msg) {
        Date ddate;
        String from;
        try {
            Address[] afrom = msg.getFrom();
            if (afrom == null || !(afrom[0] instanceof InternetAddress) || (from = ((InternetAddress)afrom[0]).getAddress()) == null) {
                from = "UNKNOWN";
            }
            if ((ddate = msg.getReceivedDate()) == null || (ddate = msg.getSentDate()) == null) {
                ddate = new Date();
            }
        }
        catch (MessagingException e) {
            from = "UNKNOWN";
            ddate = new Date();
        }
        String date = ddate.toString();
        return "From " + from + " " + date.substring(0, 20) + date.substring(24);
    }

    @Override
    public synchronized int getMessageCount() throws MessagingException {
        if (!this.opened) {
            return -1;
        }
        boolean locked = false;
        Message[] msglist = null;
        try {
            if (this.folder.length() != this.file_size) {
                if (!this.folder.lock("r")) {
                    throw new MessagingException("Failed to lock folder: " + this.name);
                }
                locked = true;
                msglist = this.load(this.file_size, true);
            }
        }
        catch (IOException e) {
            throw new MessagingException("I/O Exception", e);
        }
        finally {
            if (locked) {
                this.folder.unlock();
                if (msglist != null) {
                    this.notifyMessageAddedListeners(msglist);
                }
            }
        }
        return this.total;
    }

    @Override
    public synchronized Message getMessage(int msgno) throws MessagingException {
        this.checkReadable();
        this.checkRange(msgno);
        MessageMetadata md = (MessageMetadata)this.messages.get(this.messageIndexOf(msgno));
        MboxMessage m = md.message;
        if (m == null) {
            InputStream is = this.getMessageStream(msgno);
            try {
                m = this.loadMessage(is, msgno, this.mode == 2);
            }
            catch (IOException ex) {
                MessageRemovedException mex = new MessageRemovedException("mbox message gone", ex);
                throw mex;
            }
            md.message = m;
        }
        return m;
    }

    private final int messageIndexOf(int msgno) {
        return this.special_imap_message ? msgno : msgno - 1;
    }

    private InputStream getMessageStream(int msgno) {
        int index = this.messageIndexOf(msgno);
        long start = index == 0 ? 0L : ((MessageMetadata)this.messages.get((int)(index - 1))).end;
        long end = ((MessageMetadata)this.messages.get((int)index)).end;
        return this.temp.newStream(start, end);
    }

    @Override
    public synchronized void appendMessages(Message[] msgs) throws MessagingException {
        if (!this.folder.lock("rw")) {
            throw new MessagingException("Failed to lock folder: " + this.name);
        }
        OutputStream os = null;
        boolean err = false;
        try {
            os = new BufferedOutputStream(new FileOutputStream(((File)((Object)this.folder)).getPath(), true));
            for (int i = 0; i < msgs.length; ++i) {
                if (!(msgs[i] instanceof MimeMessage)) {
                    err = true;
                    continue;
                }
                MboxFolder.writeMboxMessage((MimeMessage)msgs[i], os);
                this.folder.touchlock();
            }
        }
        catch (IOException e) {
            throw new MessagingException("I/O Exception", e);
        }
        catch (MessagingException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MessagingException("unexpected exception " + e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
            this.folder.unlock();
        }
        if (this.opened) {
            this.getMessageCount();
        }
        if (err) {
            throw new MessagingException("Can't append non-Mime message");
        }
    }

    @Override
    public synchronized Message[] expunge() throws MessagingException {
        this.checkWritable();
        int wr = this.total;
        try {
            wr = this.writeFolder(false, true);
        }
        catch (IOException e) {
            throw new MessagingException("expunge failed", e);
        }
        if (wr == this.total) {
            return new Message[0];
        }
        int del = 0;
        Message[] msglist = new Message[this.total - wr];
        int msgno = 1;
        while (msgno <= this.total) {
            MessageMetadata md = (MessageMetadata)this.messages.get(this.messageIndexOf(msgno));
            MboxMessage msg = md.message;
            if (msg != null) {
                if (msg.isSet(Flags.Flag.DELETED)) {
                    msg.setExpunged(true);
                    msglist[del] = msg;
                    ++del;
                    this.messages.remove(this.messageIndexOf(msgno));
                    --this.total;
                    continue;
                }
                msg.setMessageNumber(msgno);
                ++msgno;
                continue;
            }
            if (md.deleted) {
                msg = (MboxMessage)this.getMessage(msgno);
                msg.setExpunged(true);
                msglist[del] = msg;
                ++del;
                this.messages.remove(this.messageIndexOf(msgno));
                --this.total;
                continue;
            }
            ++msgno;
        }
        if (del != msglist.length) {
            throw new MessagingException("expunge delete count wrong");
        }
        this.notifyMessageRemovedListeners(true, msglist);
        return msglist;
    }

    private Message[] load(long offset, boolean notify) throws MessagingException, IOException {
        int oldtotal = this.total;
        MessageLoader loader = new MessageLoader(this.temp);
        int loaded = loader.load(this.folder.getFD(), offset, this.messages);
        this.total += loaded;
        this.file_size = this.folder.length();
        if (offset == 0L && loaded > 0) {
            MessageMetadata md = (MessageMetadata)this.messages.get(0);
            if (md.imap) {
                this.special_imap_message = true;
                --this.total;
            }
        }
        if (notify) {
            Message[] msglist = new Message[this.total - oldtotal];
            int i = oldtotal;
            int j = 0;
            while (i < this.total) {
                msglist[j] = this.getMessage(i + 1);
                ++i;
                ++j;
            }
            return msglist;
        }
        return null;
    }

    private MboxMessage loadMessage(InputStream is, int msgno, boolean writable) throws MessagingException, IOException {
        String line;
        DataInputStream in = new DataInputStream(is);
        String unix_from = null;
        while ((line = in.readLine()) != null) {
            if (line.trim().length() == 0) continue;
            if (line.startsWith("From ")) {
                unix_from = line;
                int i = unix_from.indexOf(32, 5);
                if (i >= 0) break;
                continue;
            }
            throw new MessagingException("Garbage in mailbox: " + line);
        }
        if (unix_from == null) {
            throw new EOFException("end of mailbox");
        }
        InternetHeaders hdrs = new InternetHeaders(is);
        SharedInputStream sis = (SharedInputStream)((Object)is);
        InputStream stream = sis.newStream(sis.getPosition(), -1L);
        return new MboxMessage(this, hdrs, stream, msgno, unix_from, writable);
    }

    @Override
    protected void notifyMessageChangedListeners(int type, Message m) {
        super.notifyMessageChangedListeners(type, m);
    }

    @Override
    public URLName getURLName() {
        URLName storeURL = this.getStore().getURLName();
        if (this.name == null) {
            return storeURL;
        }
        char separator = this.getSeparator();
        String fullname = this.getFullName();
        StringBuffer encodedName = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(fullname, Character.toString(separator), true);
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if (s.charAt(0) == separator) {
                encodedName.append("/");
                continue;
            }
            encodedName.append(s);
        }
        return new URLName(storeURL.getProtocol(), storeURL.getHost(), storeURL.getPort(), encodedName.toString(), storeURL.getUsername(), null);
    }

    protected Folder createFolder(MboxStore store, String name) {
        return new MboxFolder(store, name);
    }

    private static String canonicalize(String ref, String pat) {
        if (ref == null) {
            return pat;
        }
        try {
            if (pat.length() == 0) {
                return ref;
            }
            if (pat.charAt(0) == File.separatorChar) {
                return ref.substring(0, ref.indexOf(File.separatorChar)) + pat;
            }
            return ref + pat;
        }
        catch (StringIndexOutOfBoundsException e) {
            return pat;
        }
    }

    private static int indexOfAny(String s, String any) {
        try {
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                if (any.indexOf(s.charAt(i)) < 0) continue;
                return i;
            }
            return -1;
        }
        catch (StringIndexOutOfBoundsException e) {
            return -1;
        }
    }

    private void listWork(String realdir, String dir, String pat, int level, Vector flist) {
        String[] sl;
        File fdir = new File(realdir);
        try {
            sl = fdir.list();
        }
        catch (SecurityException e) {
            return;
        }
        if (level == 0 && dir != null && Match.path(dir, pat, File.separatorChar)) {
            flist.addElement(dir);
        }
        if (sl == null) {
            return;
        }
        if (realdir.charAt(realdir.length() - 1) != File.separatorChar) {
            realdir = realdir + File.separator;
        }
        for (int i = 0; i < sl.length; ++i) {
            String md;
            File mf;
            if (sl[i].charAt(0) == '.' || !(mf = new File(md = realdir + sl[i])).exists()) continue;
            String name = dir != null ? dir + sl[i] : sl[i];
            if (mf.isDirectory()) {
                if (Match.path(name, pat, File.separatorChar)) {
                    flist.addElement(name);
                    name = name + File.separator;
                } else if (Match.path(name = name + File.separator, pat, File.separatorChar)) {
                    flist.addElement(name);
                }
                if (!Match.dir(name, pat, File.separatorChar)) continue;
                this.listWork(md, name, pat, level + 1, flist);
                continue;
            }
            if (!Match.path(name, pat, File.separatorChar)) continue;
            flist.addElement(name);
        }
    }

    static final class MessageMetadata {
        public long end;
        public MboxMessage message;
        public boolean recent;
        public boolean deleted;
        public boolean imap;

        MessageMetadata() {
        }
    }
}

