/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.threadpool.internal;

import com.openexchange.marker.OXThreadMarker;
import com.openexchange.threadpool.ThreadRenamer;

public final class CustomThread
extends Thread
implements ThreadRenamer,
OXThreadMarker {
    private volatile String originalName;
    private volatile String appendix;
    private volatile boolean changed;
    private volatile boolean httpProcessing;

    public CustomThread(Runnable target, String name) {
        super(target, name);
        this.applyName(name);
    }

    private void applyName(String name) {
        this.originalName = name;
        int pos = this.originalName.indexOf(45);
        this.appendix = pos > 0 ? name.substring(pos) : null;
    }

    public boolean isHttpRequestProcessing() {
        return this.httpProcessing;
    }

    public void setHttpRequestProcessing(boolean httpProcessing) {
        this.httpProcessing = httpProcessing;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    @Override
    public void restoreName() {
        if (!this.changed) {
            return;
        }
        this.setName(this.originalName);
        this.changed = false;
    }

    @Override
    public void rename(String newName) {
        this.setName(newName);
        this.changed = true;
    }

    @Override
    public void renamePrefix(String newPrefix) {
        if (null == this.appendix) {
            this.setName(newPrefix);
        } else {
            this.setName(new StringBuilder(16).append(newPrefix).append(this.appendix).toString());
        }
        this.changed = true;
    }
}

