/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.threadpool;

import com.openexchange.osgi.ExceptionUtils;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RunLoop<E>
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(RunLoop.class);
    protected final BlockingQueue<E> queue = new LinkedBlockingDeque();
    private final String name;
    private final AtomicBoolean isPaused = new AtomicBoolean();
    private final Lock handleLock = new ReentrantLock();
    private final Condition proceedCondition = this.handleLock.newCondition();
    protected final AtomicReference<E> currentElementReference = new AtomicReference();
    private volatile boolean isRunning = false;

    protected RunLoop(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName(this.name);
        this.isRunning = true;
        while (this.isRunning) {
            try {
                this.currentElementReference.set(this.queue.take());
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                LOG.info("Returning from RunLoop due to interruption");
                return;
            }
            try {
                this.handleLock.lock();
                while (this.isPaused.get()) {
                    this.proceedCondition.await();
                }
                E currentElement = this.currentElementReference.get();
                if (null == currentElement) continue;
                this.handle(currentElement);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.info("Returning from RunLoop due to interruption");
                this.isRunning = false;
                return;
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable((Throwable)t);
                LOG.error("", t);
            }
            finally {
                this.currentElementReference.set(null);
                this.handleLock.unlock();
            }
        }
        LOG.info("Leaving run loop");
        Thread.currentThread().setName(this.name + "-stopped");
    }

    public boolean offer(E element) {
        return this.queue.offer(element);
    }

    protected void pauseHandling() {
        this.isPaused.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void continueHandling() {
        try {
            this.handleLock.lock();
            this.isPaused.set(false);
            this.proceedCondition.signalAll();
        }
        finally {
            this.handleLock.unlock();
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void stop() {
        this.isRunning = false;
        this.unblock();
    }

    public String getName() {
        return this.name;
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    protected abstract void handle(E var1);

    protected abstract void unblock();
}

