/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.protocol.impl;

import com.openexchange.exception.OXException;
import com.openexchange.tools.collections.Injector;
import com.openexchange.tools.collections.OXCollections;
import com.openexchange.webdav.protocol.Protocol;
import com.openexchange.webdav.protocol.WebdavFactory;
import com.openexchange.webdav.protocol.WebdavLock;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProperty;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import com.openexchange.webdav.protocol.helpers.AbstractResource;
import com.openexchange.webdav.protocol.impl.DummyResourceManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class DummyResource
extends AbstractResource
implements WebdavResource {
    private static final AtomicInteger lockIds = new AtomicInteger();
    private boolean exists;
    protected DummyResourceManager mgr;
    protected WebdavPath url;
    private String displayName;
    private long length;
    private String eTag;
    private final Map<WebdavProperty, WebdavProperty> properties = new HashMap<WebdavProperty, WebdavProperty>();
    protected Map<String, WebdavLock> locks = new HashMap<String, WebdavLock>();
    private Date creationDate;
    private Date lastModified;
    private String lang;
    private String contentType;
    private String source;
    private byte[] body;

    public DummyResource(DummyResourceManager manager, WebdavPath url) {
        this.mgr = manager;
        this.url = url;
        this.displayName = url.size() != 0 ? url.name() : "";
        this.lang = "en";
        this.eTag = "1";
    }

    @Override
    protected WebdavFactory getFactory() {
        return this.mgr;
    }

    @Override
    public void create() throws WebdavProtocolException {
        if (this.exists) {
            throw WebdavProtocolException.Code.DIRECTORY_ALREADY_EXISTS.create(this.getUrl(), 405);
        }
        try {
            this.checkPath();
        }
        catch (OXException e) {
            throw new WebdavProtocolException(this.getUrl(), 500, e);
        }
        this.exists = true;
        this.creationDate = new Date();
        this.lastModified = new Date();
        this.mgr.save(this.url, this);
    }

    @Override
    public boolean exists() throws WebdavProtocolException {
        return this.exists;
    }

    @Override
    public void delete() throws WebdavProtocolException {
        if (!this.exists) {
            throw WebdavProtocolException.Code.FILE_NOT_FOUND.create(this.getUrl(), 404, this.getUrl());
        }
        this.exists = false;
        this.mgr.remove(this.url, this);
    }

    @Override
    protected boolean isset(Protocol.Property p) {
        return true;
    }

    @Override
    public List<WebdavProperty> internalGetAllProps() throws WebdavProtocolException {
        ArrayList<WebdavProperty> props = new ArrayList<WebdavProperty>();
        for (WebdavProperty prop : this.properties.values()) {
            props.add(prop);
        }
        return props;
    }

    @Override
    protected void internalRemoveProperty(String namespace, String name) throws WebdavProtocolException {
        WebdavProperty key = new WebdavProperty();
        key.setName(name);
        key.setNamespace(namespace);
        this.properties.remove(key);
    }

    @Override
    protected void internalPutProperty(WebdavProperty prop) throws WebdavProtocolException {
        WebdavProperty key = new WebdavProperty();
        key.setName(prop.getName());
        key.setNamespace(prop.getNamespace());
        this.properties.put(key, prop);
    }

    @Override
    public void save() throws WebdavProtocolException {
        this.lastModified = new Date();
    }

    @Override
    public WebdavPath getUrl() {
        return this.url;
    }

    @Override
    protected WebdavProperty internalGetProperty(String namespace, String name) throws WebdavProtocolException {
        WebdavProperty key = new WebdavProperty();
        key.setName(name);
        key.setNamespace(namespace);
        return this.properties.get(key);
    }

    @Override
    public Date getCreationDate() throws WebdavProtocolException {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Date date) throws WebdavProtocolException {
        this.creationDate = date;
    }

    @Override
    public Date getLastModified() throws WebdavProtocolException {
        return this.lastModified;
    }

    @Override
    public String getDisplayName() throws WebdavProtocolException {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String dispName) throws WebdavProtocolException {
        this.displayName = dispName;
    }

    @Override
    public String getLanguage() throws WebdavProtocolException {
        return this.lang;
    }

    @Override
    public void setLanguage(String lang) throws WebdavProtocolException {
        this.lang = lang;
    }

    @Override
    public Long getLength() throws WebdavProtocolException {
        return this.length;
    }

    @Override
    public void setLength(Long length) throws WebdavProtocolException {
        this.length = length;
    }

    @Override
    public String getContentType() throws WebdavProtocolException {
        return this.contentType;
    }

    @Override
    public void setContentType(String contentType) throws WebdavProtocolException {
        this.contentType = contentType;
    }

    @Override
    public String getETag() throws WebdavProtocolException {
        return this.eTag;
    }

    @Override
    public void setSource(String source) throws WebdavProtocolException {
        this.source = source;
    }

    @Override
    public String getSource() throws WebdavProtocolException {
        return this.source;
    }

    public boolean isLocked() throws WebdavProtocolException {
        return this.getLocks().size() > 0;
    }

    @Override
    public void unlock(String token) throws WebdavProtocolException {
        this.locks.remove(token);
    }

    @Override
    public void lock(WebdavLock lock) throws WebdavProtocolException {
        if (!this.exists()) {
            WebdavResource res = this.mgr.addLockNullResource(this);
            try {
                res.lock(lock);
            }
            catch (OXException e) {
                throw new WebdavProtocolException(this.getUrl(), 500, e);
            }
            return;
        }
        if (null != lock.getToken() && null != this.locks.get(lock.getToken())) {
            this.locks.put(lock.getToken(), lock);
            return;
        }
        lock.setToken("opaquelocktoken:" + lockIds.incrementAndGet());
        this.locks.put(lock.getToken(), lock);
    }

    public void setExists(boolean exists) {
        this.exists = exists;
    }

    @Override
    public List<WebdavLock> getLocks() throws WebdavProtocolException {
        List<WebdavLock> lockList = this.getOwnLocks();
        try {
            this.addParentLocks(lockList);
        }
        catch (OXException e) {
            throw new WebdavProtocolException(this.getUrl(), 500, e);
        }
        return lockList;
    }

    @Override
    public List<WebdavLock> getOwnLocks() throws WebdavProtocolException {
        this.clearTimeoutLocks(this.locks, System.currentTimeMillis());
        return new ArrayList<WebdavLock>(this.locks.values());
    }

    @Override
    public WebdavLock getOwnLock(String token) throws WebdavProtocolException {
        this.clearTimeoutLocks(this.locks, System.currentTimeMillis());
        return this.locks.get(token);
    }

    protected synchronized void clearTimeoutLocks(Map<String, WebdavLock> locks, final long timeout) {
        OXCollections.inject(locks, locks.values(), new Injector<Map<String, WebdavLock>, WebdavLock>(){

            @Override
            public Map<String, WebdavLock> inject(Map<String, WebdavLock> list, WebdavLock element) {
                if (!element.isActive(timeout)) {
                    list.remove(element.getToken());
                }
                return list;
            }
        });
    }

    @Override
    public WebdavLock getLock(String token) throws WebdavProtocolException {
        WebdavLock lock = this.locks.get(token);
        if (lock != null) {
            return lock;
        }
        try {
            return this.findParentLock(token);
        }
        catch (OXException e) {
            throw new WebdavProtocolException(this.getUrl(), 500, e);
        }
    }

    @Override
    public void putBody(InputStream data, boolean guessLength) throws WebdavProtocolException {
        this.eTag = String.valueOf(Integer.valueOf(this.eTag) + 1);
        ArrayList<Integer> bytes = new ArrayList<Integer>();
        int b = 0;
        try {
            while ((b = data.read()) != -1) {
                bytes.add(b);
            }
        }
        catch (IOException e) {
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 500);
        }
        int i = 0;
        byte[] body = new byte[bytes.size()];
        Iterator i$ = bytes.iterator();
        while (i$.hasNext()) {
            int by = (Integer)i$.next();
            body[i++] = (byte)by;
        }
        this.body = body;
        if (guessLength) {
            this.length = body.length;
        }
    }

    @Override
    public InputStream getBody() throws WebdavProtocolException {
        if (null == this.body) {
            return null;
        }
        return new ByteArrayInputStream(this.body);
    }

    @Override
    public boolean hasBody() throws WebdavProtocolException {
        return this.body != null;
    }

    @Override
    public boolean isLockNull() {
        return false;
    }
}

