/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.protocol.helpers;

import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.SessionHolder;
import com.openexchange.webdav.action.AbstractAction;
import com.openexchange.webdav.action.ServletWebdavRequest;
import com.openexchange.webdav.action.ServletWebdavResponse;
import com.openexchange.webdav.action.WebdavAction;
import com.openexchange.webdav.action.WebdavDefaultHeaderAction;
import com.openexchange.webdav.action.WebdavExistsAction;
import com.openexchange.webdav.action.WebdavIfMatchAction;
import com.openexchange.webdav.action.WebdavLogAction;
import com.openexchange.webdav.action.WebdavRequestCycleAction;
import com.openexchange.webdav.loader.BulkLoader;
import com.openexchange.webdav.protocol.WebdavMethod;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.helpers.AbstractWebdavFactory;
import com.openexchange.webdav.protocol.helpers.PropertyMixin;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractPerformer
implements SessionHolder {
    private final ThreadLocal<ServerSession> sessionHolder = new ThreadLocal();

    protected AbstractPerformer() {
    }

    protected abstract String getURLPrefix();

    protected abstract AbstractWebdavFactory getFactory();

    protected abstract WebdavAction getAction(WebdavMethod var1);

    protected WebdavAction prepare(AbstractAction action, boolean logBody, boolean logResponse, AbstractAction ... additionals) {
        return this.prepare(action, logBody, logResponse, (BulkLoader)null, additionals);
    }

    protected WebdavAction prepare(AbstractAction action, boolean logBody, boolean logResponse, BulkLoader bulkLoader, AbstractAction ... additionals) {
        return this.prepare(action, logBody, logResponse, true, bulkLoader, additionals);
    }

    protected WebdavAction prepare(AbstractAction action, boolean logBody, boolean logResponse, boolean ifMatch, BulkLoader bulkLoader, AbstractAction ... additionals) {
        WebdavRequestCycleAction lifeCycle = new WebdavRequestCycleAction();
        lifeCycle.setBulkLoader(bulkLoader);
        WebdavLogAction logAction = new WebdavLogAction(logBody, logResponse);
        lifeCycle.setNext(logAction);
        WebdavDefaultHeaderAction defaultHeader = new WebdavDefaultHeaderAction();
        defaultHeader.setBulkLoader(bulkLoader);
        logAction.setNext(defaultHeader);
        AbstractAction previousAction = defaultHeader;
        if (ifMatch) {
            WebdavIfMatchAction ifMatchAction = new WebdavIfMatchAction();
            ifMatchAction.setBulkLoader(bulkLoader);
            previousAction.setNext(ifMatchAction);
            previousAction = ifMatchAction;
        }
        for (AbstractAction nextAction : additionals) {
            nextAction.setBulkLoader(bulkLoader);
            previousAction.setNext(nextAction);
            previousAction = nextAction;
        }
        action.setBulkLoader(bulkLoader);
        previousAction.setNext(action);
        return lifeCycle;
    }

    public void setGlobalMixins(PropertyMixin ... mixins) {
        this.getFactory().setGlobalMixins(mixins);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt(HttpServletRequest request, HttpServletResponse response, WebdavMethod method, ServerSession session) {
        ServletWebdavRequest webdavRequest = new ServletWebdavRequest(this.getFactory(), request);
        webdavRequest.setUrlPrefix(this.getURLPrefix());
        session.setParameter("user-agent", request.getHeader("user-agent"));
        this.sessionHolder.set(session);
        try {
            ServletWebdavResponse webdavResponse = new ServletWebdavResponse(response);
            this.getAction(method).perform(webdavRequest, webdavResponse);
        }
        catch (WebdavProtocolException e) {
            if (null != response && !response.isCommitted()) {
                response.setStatus(e.getStatus());
            }
        }
        finally {
            this.sessionHolder.set(null);
        }
    }

    @Override
    public Session getSessionObject() {
        return this.sessionHolder.get();
    }

    @Override
    public Context getContext() {
        return this.sessionHolder.get().getContext();
    }

    @Override
    public User getUser() {
        return this.sessionHolder.get().getUser();
    }

    protected static void makeLockNullTolerant(Map<WebdavMethod, WebdavAction> actions) {
        WebdavMethod[] nullTolerantActions;
        for (WebdavMethod action : nullTolerantActions = new WebdavMethod[]{WebdavMethod.OPTIONS, WebdavMethod.LOCK, WebdavMethod.MKCOL, WebdavMethod.PUT}) {
            WebdavAction webdavAction = actions.get((Object)action);
            while (null != webdavAction) {
                if (webdavAction instanceof WebdavExistsAction) {
                    ((WebdavExistsAction)webdavAction).setTolerateLockNull(true);
                    webdavAction = null;
                    continue;
                }
                if (webdavAction instanceof AbstractAction) {
                    webdavAction = ((AbstractAction)webdavAction).getNext();
                    continue;
                }
                webdavAction = null;
            }
        }
    }
}

