/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.servlet.ratelimit.monitoring;

import com.openexchange.tools.servlet.ratelimit.RateLimiter;
import com.openexchange.tools.servlet.ratelimit.monitoring.RateLimiterMBean;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingDeque;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;

public class RateLimiterMBeanImpl
extends StandardMBean
implements RateLimiterMBean {
    private static final long WINDOW_SIZE = 3600000L;
    private final LinkedBlockingDeque<Measurement> measurements = new LinkedBlockingDeque();
    private final Timer timer = new Timer(true);

    public RateLimiterMBeanImpl() throws NotCompliantMBeanException {
        super(RateLimiterMBean.class);
        this.timer.schedule((TimerTask)new MeasureTask(), 0L, 60000L);
    }

    @Override
    public long getProcessedRequestsPerMinute() {
        Iterator<Measurement> it = this.measurements.iterator();
        Measurement last = null;
        long meantimes = 0L;
        long processedRequests = 0L;
        while (it.hasNext()) {
            Measurement current = it.next();
            if (last != null) {
                meantimes += current.getTimestamp() - last.getTimestamp();
                processedRequests += current.getProcessedRequests() - last.getProcessedRequests();
            }
            last = current;
        }
        double eventsPerMillis = 0.0;
        if (processedRequests > 0L && meantimes > 0L) {
            eventsPerMillis = (double)processedRequests / (double)meantimes;
        }
        return Math.round(eventsPerMillis * 60000.0);
    }

    @Override
    public long getSlotCount() {
        return RateLimiter.getSlotCount();
    }

    @Override
    public long getTotalProcessedRequests() {
        Measurement current = this.measurements.peekLast();
        return null != current ? current.getProcessedRequests() : 0L;
    }

    @Override
    public void clear() {
        RateLimiter.clear();
    }

    public void close() {
        this.timer.cancel();
        this.timer.purge();
    }

    private final class Measurement {
        private final long timestamp;
        private final long measuredProcessedRequest;

        public Measurement(long processedRequests) {
            this.measuredProcessedRequest = processedRequests;
            this.timestamp = System.currentTimeMillis();
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public long getProcessedRequests() {
            return this.measuredProcessedRequest;
        }
    }

    private final class MeasureTask
    extends TimerTask {
        private MeasureTask() {
        }

        @Override
        public void run() {
            RateLimiterMBeanImpl.this.measurements.add(new Measurement(RateLimiter.getProcessedRequests()));
            this.cleanUp();
        }

        private void cleanUp() {
            long minTime = System.currentTimeMillis() - 3600000L;
            Measurement measurement = null;
            while ((measurement = (Measurement)RateLimiterMBeanImpl.this.measurements.peek()) != null && measurement.getTimestamp() < minTime) {
                RateLimiterMBeanImpl.this.measurements.poll();
            }
        }
    }
}

