/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.servlet.ratelimit.impl;

import com.openexchange.tools.servlet.ratelimit.Rate;
import gnu.trove.list.TLongList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.procedure.TLongProcedure;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class RateImpl
implements Rate {
    private final AtomicLong lastLogStamp = new AtomicLong(0L);
    private final int permits;
    private long timeInMillis;
    private final TLongList callHistory = new TLongArrayList();
    private boolean deprecated = false;

    public RateImpl(int permits, int timeLength, TimeUnit timeUnit) {
        this.permits = permits;
        this.timeInMillis = timeUnit.toMillis(timeLength);
    }

    private void cleanOld(long now) {
        long threshold = now - this.timeInMillis;
        while (!this.callHistory.isEmpty() && this.callHistory.get(0) <= threshold) {
            this.callHistory.removeAt(0);
        }
    }

    private long callTime(long now) {
        this.cleanOld(now);
        int size = this.callHistory.size();
        if (size < this.permits) {
            return now;
        }
        long lastStart = this.callHistory.get(size - 1) - this.timeInMillis;
        MyProc procedure = new MyProc(lastStart);
        this.callHistory.forEachDescending((TLongProcedure)procedure);
        return procedure.count < this.permits ? procedure.firstPeriodCall + 1L : procedure.firstPeriodCall + this.timeInMillis + 1L;
    }

    @Override
    public AtomicLong getLastLogStamp() {
        return this.lastLogStamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long lastAccessTime() {
        TLongList tLongList = this.callHistory;
        synchronized (tLongList) {
            return this.callHistory.isEmpty() ? Long.MIN_VALUE : this.callHistory.get(this.callHistory.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDeprecated() {
        TLongList tLongList = this.callHistory;
        synchronized (tLongList) {
            return this.deprecated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean markDeprecatedIfElapsed(long threshold) {
        TLongList tLongList = this.callHistory;
        synchronized (tLongList) {
            if (!this.callHistory.isEmpty() && this.callHistory.get(this.callHistory.size() - 1) > threshold) {
                return false;
            }
            this.deprecated = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rate.Result consume(long now) {
        TLongList tLongList = this.callHistory;
        synchronized (tLongList) {
            if (this.deprecated) {
                return Rate.Result.DEPRECATED;
            }
            long callTime = this.callTime(now);
            this.callHistory.add(callTime);
            return callTime - now <= 0L ? Rate.Result.SUCCESS : Rate.Result.FAILED;
        }
    }

    @Override
    public int getPermits() {
        return this.permits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimeInMillis() {
        TLongList tLongList = this.callHistory;
        synchronized (tLongList) {
            return this.timeInMillis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimeInMillis(long timeInMillis) {
        TLongList tLongList = this.callHistory;
        synchronized (tLongList) {
            this.timeInMillis = timeInMillis;
        }
    }

    public static void main(String[] args) {
        int i;
        RateImpl rate = new RateImpl(5, 5, TimeUnit.SECONDS);
        long callTime = System.currentTimeMillis();
        for (i = 0; i < 6; ++i) {
            System.out.println((Object)rate.consume(callTime));
            callTime += 100L;
        }
        System.out.println("-------------------------");
        callTime += 6000L;
        for (i = 0; i < 6; ++i) {
            System.out.println((Object)rate.consume(callTime));
            callTime += 100L;
        }
        System.out.println("-------------------------");
    }

    private static class MyProc
    implements TLongProcedure {
        final long lastStart;
        long firstPeriodCall;
        int count;

        MyProc(long lastStart) {
            this.lastStart = lastStart;
            this.firstPeriodCall = lastStart;
            this.count = 0;
        }

        public boolean execute(long call) {
            if (call < this.lastStart) {
                return false;
            }
            ++this.count;
            this.firstPeriodCall = call;
            return true;
        }
    }
}

