/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.servlet.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public final class MIMEParse {
    private MIMEParse() {
    }

    protected static ParseResults parseMimeType(String mimeType) {
        String[] parts = StringUtils.split((String)mimeType, (String)";");
        ParseResults results = new ParseResults();
        results.params = new HashMap<String, String>(parts.length);
        for (int i = 1; i < parts.length; ++i) {
            String p = parts[i];
            String[] subParts = StringUtils.split((String)p, (char)'=');
            if (subParts.length != 2) continue;
            results.params.put(subParts[0].trim(), subParts[1].trim());
        }
        String fullType = parts[0].trim();
        if (fullType.equals("*")) {
            fullType = "*/*";
        }
        String[] types = StringUtils.split((String)fullType, (String)"/");
        results.type = types[0].trim();
        results.subType = types[1].trim();
        return results;
    }

    protected static ParseResults parseMediaRange(String range) {
        ParseResults results = MIMEParse.parseMimeType(range);
        String q = results.params.get("q");
        float f = NumberUtils.toFloat((String)q, (float)1.0f);
        if (StringUtils.isBlank((String)q) || f < 0.0f || f > 1.0f) {
            results.params.put("q", "1");
        }
        return results;
    }

    protected static List<ParseResults> parseRanges(String ranges) {
        String[] arrRanges = StringUtils.split((String)ranges, (char)',');
        ArrayList<ParseResults> results = new ArrayList<ParseResults>(arrRanges.length);
        for (String r : arrRanges) {
            results.add(MIMEParse.parseMediaRange(r));
        }
        return results;
    }

    protected static FitnessAndQuality fitnessAndQualityParsed(String mimeType, Collection<ParseResults> parsedRanges) {
        int bestFitness = -1;
        float bestFitQ = 0.0f;
        ParseResults target = MIMEParse.parseMediaRange(mimeType);
        for (ParseResults range : parsedRanges) {
            if (!target.type.equals(range.type) && !range.type.equals("*") && !target.type.equals("*") || !target.subType.equals(range.subType) && !range.subType.equals("*") && !target.subType.equals("*")) continue;
            for (String k : target.params.keySet()) {
                int paramMatches = 0;
                if (!k.equals("q") && range.params.containsKey(k) && target.params.get(k).equals(range.params.get(k))) {
                    ++paramMatches;
                }
                int fitness = range.type.equals(target.type) ? 100 : 0;
                fitness += range.subType.equals(target.subType) ? 10 : 0;
                if ((fitness += paramMatches) <= bestFitness) continue;
                bestFitness = fitness;
                bestFitQ = NumberUtils.toFloat((String)range.params.get("q"), (float)0.0f);
            }
        }
        return new FitnessAndQuality(bestFitness, bestFitQ);
    }

    protected static float qualityParsed(String mimeType, Collection<ParseResults> parsedRanges) {
        return MIMEParse.fitnessAndQualityParsed((String)mimeType, parsedRanges).quality;
    }

    public static float quality(String mimeType, String ranges) {
        List<ParseResults> results = MIMEParse.parseRanges(ranges);
        return MIMEParse.qualityParsed(mimeType, results);
    }

    public static float[] qualities(List<String> mimeTypes, String ranges) {
        if (null == mimeTypes) {
            return new float[0];
        }
        int size = mimeTypes.size();
        if (size <= 0) {
            return new float[0];
        }
        List<ParseResults> results = MIMEParse.parseRanges(ranges);
        float[] qualities = new float[size];
        int i = size;
        while (i-- > 0) {
            String mimeType = mimeTypes.get(i);
            qualities[i] = MIMEParse.qualityParsed(mimeType, results);
        }
        return qualities;
    }

    public static String bestMatch(Collection<String> supported, String header) {
        List<ParseResults> parseResults = MIMEParse.parseRanges(header);
        LinkedList<FitnessAndQuality> weightedMatches = new LinkedList<FitnessAndQuality>();
        for (String s : supported) {
            FitnessAndQuality fitnessAndQuality = MIMEParse.fitnessAndQualityParsed(s, parseResults);
            fitnessAndQuality.mimeType = s;
            weightedMatches.add(fitnessAndQuality);
        }
        Collections.sort(weightedMatches);
        FitnessAndQuality lastOne = (FitnessAndQuality)weightedMatches.getLast();
        return NumberUtils.compare((float)lastOne.quality, (float)0.0f) != 0 ? lastOne.mimeType : "";
    }

    protected static class FitnessAndQuality
    implements Comparable<FitnessAndQuality> {
        int fitness;
        float quality;
        String mimeType;

        public FitnessAndQuality(int fitness, float quality) {
            this.fitness = fitness;
            this.quality = quality;
        }

        @Override
        public int compareTo(FitnessAndQuality o) {
            if (this.fitness != o.fitness) {
                return this.fitness < o.fitness ? -1 : 1;
            }
            return this.quality == o.quality ? 0 : (this.quality < o.quality ? -1 : 1);
        }
    }

    protected static class ParseResults {
        String type;
        String subType;
        Map<String, String> params;

        protected ParseResults() {
        }

        public String toString() {
            StringBuffer s = new StringBuffer("('" + this.type + "', '" + this.subType + "', {");
            for (Map.Entry<String, String> e : this.params.entrySet()) {
                s.append("'" + e.getKey() + "':'" + e.getValue() + "',");
            }
            return s.append("})").toString();
        }
    }
}

