/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder.downgrade;

import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.cache.impl.FolderQueryCacheManager;
import com.openexchange.contact.ContactService;
import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.database.provider.StaticDBPoolProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.AppointmentSqlFactoryService;
import com.openexchange.groupware.calendar.CalendarCache;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.downgrade.DowngradeEvent;
import com.openexchange.groupware.downgrade.DowngradeListener;
import com.openexchange.groupware.infostore.facade.impl.InfostoreFacadeImpl;
import com.openexchange.groupware.tasks.Tasks;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.downgrade.sql.OXFolderDowngradeSQL;
import com.openexchange.tools.oxfolder.memory.ConditionTreeMapManagement;
import com.openexchange.tools.session.ServerSessionAdapter;
import gnu.trove.TIntCollection;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OXFolderDowngradeListener
extends DowngradeListener {
    private static final String TABLE_FOLDER_WORKING = "oxfolder_tree";
    private static final String TABLE_PERMISSIONS_WORKING = "oxfolder_permissions";
    private static final Logger LOG = LoggerFactory.getLogger(OXFolderDowngradeListener.class);

    @Override
    public void downgradePerformed(DowngradeEvent event) throws OXException {
        UserConfiguration newUserConfiguration = event.getNewUserConfiguration();
        if (!newUserConfiguration.hasCalendar()) {
            try {
                OXFolderDowngradeListener.deleteCalendarFolderData(newUserConfiguration.getUserId(), event);
                LOG.info("All calendar-related folder data removed due to loss of calendar module access");
            }
            catch (Exception e) {
                LOG.warn("Could not remove all calendar-related folder data caused by loss of calendar module access.");
                LOG.debug("", (Throwable)e);
            }
        }
        if (!newUserConfiguration.hasTask()) {
            try {
                OXFolderDowngradeListener.deleteTaskFolderData(newUserConfiguration.getUserId(), event);
                LOG.info("All task-related folder data removed due to loss of task module access");
            }
            catch (Exception e) {
                LOG.warn("Could not remove all task-related folder data caused by loss of task module access.");
                LOG.debug("", (Throwable)e);
            }
        }
        if (!newUserConfiguration.hasInfostore()) {
            try {
                this.deleteInfostoreFolderData(newUserConfiguration.getUserId(), event);
                LOG.info("All infostore-related folder data removed due to loss of infostore module access");
            }
            catch (Exception e) {
                LOG.warn("Could not remove all infostore-related folder data caused by loss of infostore module access.");
                LOG.debug("", (Throwable)e);
            }
        }
        if (!newUserConfiguration.hasFullSharedFolderAccess()) {
            try {
                OXFolderDowngradeListener.deleteSharedFolderData(newUserConfiguration.getUserId(), event);
                LOG.info("All shared folder data removed due to loss of full shared folder access");
            }
            catch (Exception e) {
                LOG.warn("Could not remove all shared folder data caused by loss of full shared folder access.");
                LOG.debug("", (Throwable)e);
            }
        }
        try {
            if (FolderQueryCacheManager.isInitialized()) {
                FolderQueryCacheManager.getInstance().invalidateContextQueries(event.getContext().getContextId());
            }
            if (CalendarCache.isInitialized()) {
                CalendarCache.getInstance().invalidateGroup(event.getContext().getContextId());
            }
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
        }
    }

    private static void deleteCalendarFolderData(int entity, DowngradeEvent event) throws OXException {
        OXFolderDowngradeListener.deleteModuleFolderData(entity, 2, event, true, true);
    }

    private static void deleteTaskFolderData(int entity, DowngradeEvent event) throws OXException {
        OXFolderDowngradeListener.deleteModuleFolderData(entity, 1, event, true, true);
    }

    private void deleteInfostoreFolderData(int entity, DowngradeEvent event) throws OXException {
        int cid = event.getContext().getContextId();
        try {
            int fuid = OXFolderDowngradeSQL.cleanDefaultModuleFolder(entity, 8, cid, TABLE_FOLDER_WORKING, TABLE_PERMISSIONS_WORKING, event.getWriteCon());
            if (fuid != -1) {
                OXFolderDowngradeListener.removeFromFolderCache(new int[]{fuid}, entity, event.getContext());
            }
            TIntSet fuids = OXFolderDowngradeSQL.gatherSubInfostoreFolders(entity, cid, TABLE_FOLDER_WORKING, TABLE_PERMISSIONS_WORKING, event.getWriteCon());
            OXFolderDowngradeListener.deleteFoldersContent((TIntCollection)fuids, event);
            OXFolderDowngradeSQL.deleteFolderPermissions((TIntCollection)fuids, cid, TABLE_PERMISSIONS_WORKING, event.getWriteCon());
            OXFolderDowngradeSQL.deleteFolders((TIntCollection)fuids, cid, TABLE_FOLDER_WORKING, event.getWriteCon());
            OXFolderDowngradeListener.removeFromFolderCache((TIntCollection)fuids, entity, event.getContext());
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        OXFolderDowngradeListener.deleteModuleFolderData(entity, 8, event, false, false);
    }

    private static void deleteModuleFolderData(int entity, int module, DowngradeEvent event, boolean checkPrivate, boolean allPublic) throws OXException {
        TIntHashSet ids = new TIntHashSet(128);
        int cid = event.getContext().getContextId();
        Connection writeCon = event.getWriteCon();
        try {
            TIntCollection fuids = null;
            if (checkPrivate) {
                fuids = OXFolderDowngradeSQL.getModulePrivateFolders(module, entity, cid, TABLE_FOLDER_WORKING, writeCon);
                OXFolderDowngradeListener.deleteFoldersContent(fuids, event);
                OXFolderDowngradeSQL.deleteFolderPermissions(fuids, cid, TABLE_PERMISSIONS_WORKING, writeCon);
                OXFolderDowngradeSQL.deleteFolders(fuids, cid, TABLE_FOLDER_WORKING, writeCon);
                ids.addAll(fuids);
                fuids = null;
                int fuid = OXFolderDowngradeSQL.cleanDefaultModuleFolder(entity, module, cid, TABLE_FOLDER_WORKING, TABLE_PERMISSIONS_WORKING, writeCon);
                if (fuid != -1) {
                    ids.add(fuid);
                }
            }
            OXFolderDowngradeSQL.dropModuleSystemPermission(module, entity, cid, TABLE_FOLDER_WORKING, TABLE_PERMISSIONS_WORKING, writeCon);
            fuids = OXFolderDowngradeSQL.getAffectedPublicFolders(entity, module, cid, TABLE_FOLDER_WORKING, TABLE_PERMISSIONS_WORKING, writeCon, allPublic);
            TIntIterator iter = fuids.iterator();
            int i = fuids.size();
            while (i-- > 0) {
                int fuid = iter.next();
                OXFolderDowngradeSQL.handleAffectedPublicFolder(entity, fuid, cid, TABLE_PERMISSIONS_WORKING, writeCon);
                ids.add(fuid);
            }
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        OXFolderDowngradeListener.removeFromFolderCache((TIntCollection)ids, entity, event.getContext());
    }

    private static void deleteFoldersContent(TIntCollection fuids, DowngradeEvent event) throws OXException {
        OXFolderAccess access = new OXFolderAccess(event.getWriteCon(), event.getContext());
        TIntIterator iter = fuids.iterator();
        int i = fuids.size();
        block7: while (i-- > 0) {
            int fuid = iter.next();
            int imodule = access.getFolderModule(fuid);
            switch (imodule) {
                case 2: {
                    OXFolderDowngradeListener.deleteContainedAppointments(fuid, event);
                    continue block7;
                }
                case 1: {
                    OXFolderDowngradeListener.deleteContainedTasks(fuid, event);
                    continue block7;
                }
                case 3: {
                    OXFolderDowngradeListener.deleteContainedContacts(fuid, event);
                    continue block7;
                }
                case 4: {
                    continue block7;
                }
                case 8: {
                    OXFolderDowngradeListener.deleteContainedDocuments(fuid, event);
                    continue block7;
                }
            }
            throw OXFolderExceptionCode.UNKNOWN_MODULE.create(imodule, event.getContext().getContextId());
        }
    }

    private static void deleteContainedAppointments(int folderID, DowngradeEvent event) throws OXException {
        AppointmentSqlFactoryService service = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class);
        if (null != service) {
            AppointmentSQLInterface cSql = service.createAppointmentSql(event.getSession());
            try {
                if (null == event.getWriteCon()) {
                    cSql.deleteAppointmentsInFolder(folderID);
                } else {
                    cSql.deleteAppointmentsInFolder(folderID, event.getWriteCon());
                }
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteContainedTasks(int folderID, DowngradeEvent event) throws OXException {
        Tasks tasks2 = Tasks.getInstance();
        if (null == event.getWriteCon()) {
            Connection wc = null;
            try {
                wc = DBPool.pickupWriteable(event.getContext());
                tasks2.deleteTasksInFolder(event.getSession(), wc, folderID);
            }
            finally {
                if (null != wc) {
                    DBPool.closeWriterSilent(event.getContext(), wc);
                }
            }
        } else {
            tasks2.deleteTasksInFolder(event.getSession(), event.getWriteCon(), folderID);
        }
    }

    private static void deleteContainedContacts(int folderID, DowngradeEvent event) throws OXException {
        ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class);
        if (null != contactService) {
            contactService.deleteContacts(event.getSession(), String.valueOf(folderID));
        }
    }

    private static void deleteContainedDocuments(int folderID, DowngradeEvent event) throws OXException {
        InfostoreFacadeImpl db;
        if (event.getWriteCon() == null) {
            db = new InfostoreFacadeImpl(new DBPoolProvider());
        } else {
            db = new InfostoreFacadeImpl(new StaticDBPoolProvider(event.getWriteCon()));
            db.setCommitsTransaction(false);
        }
        db.setTransactional(true);
        try {
            db.startTransaction();
            db.removeDocument(folderID, System.currentTimeMillis(), ServerSessionAdapter.valueOf(event.getSession(), event.getContext()));
            db.commit();
        }
        catch (OXException x) {
            db.rollback();
            throw x;
        }
        finally {
            db.finish();
        }
    }

    private static void deleteSharedFolderData(int entity, DowngradeEvent event) throws OXException {
        int cid = event.getContext().getContextId();
        TIntHashSet set = new TIntHashSet();
        try {
            TIntSet tmp = OXFolderDowngradeSQL.removeShareAccess(entity, cid, TABLE_FOLDER_WORKING, TABLE_PERMISSIONS_WORKING, event.getWriteCon());
            set.addAll((TIntCollection)tmp);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        OXFolderDowngradeListener.removeFromFolderCache((TIntCollection)set, entity, event.getContext());
    }

    private static void removeFromFolderCache(TIntCollection col, int userId, Context ctx) {
        OXFolderDowngradeListener.removeFromFolderCache(col.toArray(), userId, ctx);
    }

    private static void removeFromFolderCache(int[] folderIDs, int userId, Context ctx) {
        EventAdmin eventAdmin;
        ConditionTreeMapManagement.dropFor(ctx.getContextId());
        if (FolderCacheManager.isEnabled() && FolderCacheManager.isInitialized()) {
            try {
                FolderCacheManager.getInstance().removeFolderObjects(folderIDs, ctx);
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
        }
        if (null != (eventAdmin = ServerServiceRegistry.getInstance().getService(EventAdmin.class))) {
            for (int folderID : folderIDs) {
                Hashtable<String, Object> props = new Hashtable<String, Object>(1);
                ((Dictionary)props).put("com.openexchange.folderstorage.folder", String.valueOf(folderID));
                ((Dictionary)props).put("com.openexchange.folderstorage.context", ctx.getContextId());
                ((Dictionary)props).put("com.openexchange.folderstorage.user", userId);
                ((Dictionary)props).put("com.openexchange.folderstorage.content-related", Boolean.FALSE);
                Event event = new Event("com/openexchange/folderstorage/attributes", props);
                eventAdmin.postEvent(event);
            }
        }
    }

    @Override
    public int getOrder() {
        return 10;
    }
}

