/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder.deletelistener;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.delete.DeleteFailedExceptionCodes;
import com.openexchange.tools.oxfolder.deletelistener.CorruptPermission;
import com.openexchange.tools.oxfolder.deletelistener.sql.DetectCorruptPermissions;
import com.openexchange.tools.oxfolder.deletelistener.sql.GroupPermissionMerger;
import com.openexchange.tools.oxfolder.deletelistener.sql.UserPermissionMerger;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OXFolderDeleteListenerHelper {
    private static final Logger LOG = LoggerFactory.getLogger(OXFolderDeleteListenerHelper.class);

    private OXFolderDeleteListenerHelper() {
    }

    public static void ensureConsistency(Context ctx, Connection writeCon) throws OXException {
        try {
            OXFolderDeleteListenerHelper.checkUserPermissions(ctx.getContextId(), writeCon);
            OXFolderDeleteListenerHelper.checkGroupPermissions(ctx.getContextId(), writeCon);
        }
        catch (SQLException e) {
            throw DeleteFailedExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        catch (Exception e) {
            throw DeleteFailedExceptionCodes.ERROR.create(e, e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void checkUserPermissions(int cid, Connection writeCon) throws SQLException, Exception {
        CorruptPermission[] corruptPermissions = null;
        try {
            corruptPermissions = DetectCorruptPermissions.detectCorruptUserPermissions(cid, writeCon);
        }
        catch (SQLException e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
        if (null != corruptPermissions && corruptPermissions.length > 0) {
            LOG.info("{} corrupt user permissions detected", (Object)corruptPermissions.length);
            boolean performTransaction = writeCon.getAutoCommit();
            if (performTransaction) {
                writeCon.setAutoCommit(false);
            }
            try {
                UserPermissionMerger.handleCorruptUserPermissions(corruptPermissions, writeCon);
                if (!performTransaction) return;
                writeCon.commit();
                return;
            }
            catch (SQLException e) {
                LOG.error("", (Throwable)e);
                if (!performTransaction) throw e;
                writeCon.rollback();
                throw e;
            }
            catch (Throwable t) {
                LOG.error("", t);
                if (!performTransaction) throw t instanceof Exception ? (Exception)t : new Exception(t.getMessage(), t);
                writeCon.rollback();
                throw t instanceof Exception ? (Exception)t : new Exception(t.getMessage(), t);
            }
            finally {
                if (performTransaction) {
                    writeCon.setAutoCommit(true);
                }
            }
        } else {
            LOG.info("No corrupt user permissions detected");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void checkGroupPermissions(int cid, Connection writeCon) throws SQLException, Exception {
        CorruptPermission[] corruptPermissions = null;
        try {
            corruptPermissions = DetectCorruptPermissions.detectCorruptGroupPermissions(cid, writeCon);
        }
        catch (SQLException e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
        if (null != corruptPermissions && corruptPermissions.length > 0) {
            LOG.info("{} corrupt group permissions detected on host ", (Object)corruptPermissions.length);
            boolean performTransaction = writeCon.getAutoCommit();
            if (performTransaction) {
                writeCon.setAutoCommit(false);
            }
            try {
                GroupPermissionMerger.handleCorruptGroupPermissions(corruptPermissions, writeCon);
                if (!performTransaction) return;
                writeCon.commit();
                return;
            }
            catch (SQLException e) {
                LOG.error("", (Throwable)e);
                if (!performTransaction) throw e;
                writeCon.rollback();
                throw e;
            }
            catch (Throwable t) {
                LOG.error("", t);
                if (!performTransaction) throw t instanceof Exception ? (Exception)t : new Exception(t.getMessage(), t);
                writeCon.rollback();
                throw t instanceof Exception ? (Exception)t : new Exception(t.getMessage(), t);
            }
            finally {
                if (performTransaction) {
                    writeCon.setAutoCommit(true);
                }
            }
        } else {
            LOG.info("No corrupt group permissions detected on host ");
        }
    }
}

