/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder;

import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.cache.impl.FolderQueryCacheManager;
import com.openexchange.cache.registry.CacheAvailabilityListener;
import com.openexchange.cache.registry.CacheAvailabilityRegistry;
import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.management.ManagementService;
import com.openexchange.server.Initialization;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.oxfolder.GABRestorerMBeanImpl;
import com.openexchange.tools.oxfolder.memory.ConditionTreeMapManagement;
import com.openexchange.tools.oxfolder.permissionLoader.PermissionLoaderService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OXFolderProperties
implements Initialization,
CacheAvailabilityListener {
    private static final Logger LOG = LoggerFactory.getLogger(OXFolderProperties.class);
    private static OXFolderProperties instance = new OXFolderProperties();
    private final AtomicBoolean started = new AtomicBoolean();
    private boolean enableDBGrouping = true;
    private boolean enableFolderCache = true;
    private boolean ignoreSharedAddressbook = false;
    volatile boolean enableInternalUsersEdit = true;
    private boolean enableSharedFolderCaching = true;
    private static final String WARN_FOLDER_PROPERTIES_INIT = "Folder properties have not been started.";

    public static OXFolderProperties getInstance() {
        return instance;
    }

    private OXFolderProperties() {
    }

    public void start() throws OXException {
        if (!this.started.compareAndSet(false, true)) {
            LOG.error("Folder properties have already been started", new Throwable());
            return;
        }
        this.init();
        PermissionLoaderService.getInstance().startUp();
        CacheAvailabilityRegistry reg = CacheAvailabilityRegistry.getInstance();
        if (reg != null) {
            reg.registerListener(this);
        }
        if (this.enableFolderCache) {
            FolderCacheManager.initInstance();
        }
        FolderQueryCacheManager.initInstance();
        ConditionTreeMapManagement.startInstance();
    }

    public void stop() throws OXException {
        if (!this.started.compareAndSet(true, false)) {
            LOG.error("Folder properties cannot be stopped since they have not been started before", new Throwable());
            return;
        }
        CacheAvailabilityRegistry reg = CacheAvailabilityRegistry.getInstance();
        if (reg != null) {
            reg.unregisterListener(this);
        }
        ConditionTreeMapManagement.stopInstance();
        FolderCacheManager.releaseInstance();
        FolderQueryCacheManager.releaseInstance();
        PermissionLoaderService.dropInstance();
        this.reset();
    }

    @Override
    public void handleAvailability() throws OXException {
        FolderQueryCacheManager fqcm;
        FolderCacheManager fcm = FolderCacheManager.getInstance();
        if (null != fcm) {
            fcm.initCache();
        }
        if (null != (fqcm = FolderQueryCacheManager.getInstance())) {
            fqcm.initCache();
        }
    }

    @Override
    public void handleAbsence() throws OXException {
        FolderQueryCacheManager fqcm;
        FolderCacheManager fcm = FolderCacheManager.getInstance();
        if (null != fcm) {
            fcm.releaseCache();
        }
        if (null != (fqcm = FolderQueryCacheManager.getInstance())) {
            fqcm.releaseCache();
        }
    }

    private void reset() {
        this.enableSharedFolderCaching = true;
        this.enableDBGrouping = true;
        this.enableFolderCache = true;
        this.ignoreSharedAddressbook = false;
        this.enableInternalUsersEdit = true;
    }

    private void init() {
        ConfigurationService configurationService = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        if (configurationService == null) {
            LOG.error("Cannot look-up configuration service");
            return;
        }
        String value = configurationService.getProperty("ENABLE_SHARED_FOLDER_CACHING");
        if (null != value) {
            this.enableSharedFolderCaching = Boolean.parseBoolean(value.trim());
        }
        if (null == (value = configurationService.getProperty("ENABLE_DB_GROUPING"))) {
            LOG.warn("Missing property ENABLE_DB_GROUPING.");
        } else {
            this.enableDBGrouping = Boolean.parseBoolean(value.trim());
        }
        value = configurationService.getProperty("ENABLE_FOLDER_CACHE");
        if (null == value) {
            LOG.warn("Missing property ENABLE_FOLDER_CACHE");
        } else {
            this.enableFolderCache = Boolean.parseBoolean(value.trim());
        }
        value = configurationService.getProperty("IGNORE_SHARED_ADDRESSBOOK");
        if (null == value) {
            LOG.warn("Missing property IGNORE_SHARED_ADDRESSBOOK");
        } else {
            this.ignoreSharedAddressbook = Boolean.parseBoolean(value.trim());
        }
        value = configurationService.getProperty("ENABLE_INTERNAL_USER_EDIT");
        if (null == value) {
            LOG.warn("Missing property ENABLE_INTERNAL_USER_EDIT");
        } else {
            boolean enableInternalUsersEdit;
            this.enableInternalUsersEdit = enableInternalUsersEdit = Boolean.parseBoolean(value.trim());
        }
        this.logInfo();
    }

    private void logInfo() {
        StringBuilder sb = new StringBuilder(512);
        sb.append("\nFolder Properties & Folder Cache Properties:\n");
        sb.append("\tENABLE_SHARED_FOLDER_CACHING=").append(this.enableSharedFolderCaching).append('\n');
        sb.append("\tENABLE_DB_GROUPING=").append(this.enableDBGrouping).append('\n');
        sb.append("\tENABLE_FOLDER_CACHE=").append(this.enableFolderCache).append('\n');
        sb.append("\tENABLE_INTERNAL_USER_EDIT=").append(this.enableInternalUsersEdit).append('\n');
        sb.append("\tIGNORE_SHARED_ADDRESSBOOK=").append(this.ignoreSharedAddressbook);
        LOG.info(sb.toString());
    }

    public static boolean isEnableDBGrouping() {
        if (!OXFolderProperties.instance.started.get()) {
            LOG.error(WARN_FOLDER_PROPERTIES_INIT, new Throwable());
        }
        return OXFolderProperties.instance.enableDBGrouping;
    }

    public static boolean isEnableFolderCache() {
        if (!OXFolderProperties.instance.started.get()) {
            LOG.error(WARN_FOLDER_PROPERTIES_INIT, new Throwable());
        }
        return OXFolderProperties.instance.enableFolderCache;
    }

    public static boolean isIgnoreSharedAddressbook() {
        if (!OXFolderProperties.instance.started.get()) {
            LOG.error(WARN_FOLDER_PROPERTIES_INIT, new Throwable());
        }
        return OXFolderProperties.instance.ignoreSharedAddressbook;
    }

    public static boolean isEnableInternalUsersEdit() {
        if (!OXFolderProperties.instance.started.get()) {
            LOG.error(WARN_FOLDER_PROPERTIES_INIT, new Throwable());
        }
        return OXFolderProperties.instance.enableInternalUsersEdit;
    }

    public static boolean isEnableSharedFolderCaching() {
        if (!OXFolderProperties.instance.started.get()) {
            LOG.error(WARN_FOLDER_PROPERTIES_INIT, new Throwable());
        }
        return OXFolderProperties.instance.enableSharedFolderCaching;
    }

    public static ObjectName registerRestorerMBean(ManagementService managementService) {
        try {
            ObjectName objectName = OXFolderProperties.getObjectName(GABRestorerMBeanImpl.class.getName(), "com.openexchange.globaladdressbook");
            managementService.registerMBean(objectName, (Object)new GABRestorerMBeanImpl());
            return objectName;
        }
        catch (MalformedObjectNameException e) {
            LOG.error("", (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            LOG.error("", (Throwable)e);
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
        }
        return null;
    }

    public static void unregisterRestorerMBean(ObjectName objectName, ManagementService managementService) {
        if (objectName != null) {
            try {
                managementService.unregisterMBean(objectName);
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    public static ObjectName getObjectName(String className, String domain) throws MalformedObjectNameException {
        int pos = className.lastIndexOf(46);
        return new ObjectName(domain, "name", pos == -1 ? className : className.substring(pos + 1));
    }
}

