/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.sessiond.impl;

import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.SessionHolderExtended;

public class ThreadLocalSessionHolder
implements SessionHolderExtended {
    private static final ThreadLocalSessionHolder INSTANCE = new ThreadLocalSessionHolder();
    private final ThreadLocal<ServerSession> session = new ThreadLocal();

    public static ThreadLocalSessionHolder getInstance() {
        return INSTANCE;
    }

    private ThreadLocalSessionHolder() {
    }

    public void setSession(ServerSession serverSession) {
        this.session.set(serverSession);
    }

    public void clear() {
        this.session.remove();
    }

    @Override
    public Context getContext() {
        return this.getSessionObject().getContext();
    }

    @Override
    public Session optSessionObject() {
        return this.session.get();
    }

    @Override
    public ServerSession getSessionObject() {
        return this.session.get();
    }

    @Override
    public User getUser() {
        return this.getSessionObject().getUser();
    }
}

