/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.transport.config;

import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Reloadable;
import com.openexchange.mail.transport.config.TransportProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransportReloadable
implements Reloadable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransportReloadable.class);
    private static final TransportReloadable INSTANCE = new TransportReloadable();
    private static final String CONFIGFILE = "transport.properties";
    private static final String[] PROPERTIES = new String[]{"all properties in file"};
    private final List<Reloadable> reloadables = new CopyOnWriteArrayList<Reloadable>();

    public static TransportReloadable getInstance() {
        return INSTANCE;
    }

    private TransportReloadable() {
    }

    public void addReloadable(Reloadable reloadable) {
        this.reloadables.add(reloadable);
    }

    public void reloadConfiguration(ConfigurationService configService) {
        try {
            TransportProperties transportProperties = TransportProperties.getInstance();
            if (null != transportProperties) {
                transportProperties.resetProperties();
                transportProperties.loadProperties();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to reload transport properties", (Throwable)e);
        }
        for (Reloadable reloadable : this.reloadables) {
            reloadable.reloadConfiguration(configService);
        }
    }

    public Map<String, String[]> getConfigFileNames() {
        HashMap<String, String[]> map = new HashMap<String, String[]>(1);
        map.put(CONFIGFILE, PROPERTIES);
        return map;
    }
}

