/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.search.service;

import com.openexchange.exception.OXException;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.MessageHeaders;
import com.openexchange.mail.search.BccTerm;
import com.openexchange.mail.search.BodyTerm;
import com.openexchange.mail.search.CcTerm;
import com.openexchange.mail.search.ComparisonType;
import com.openexchange.mail.search.FlagTerm;
import com.openexchange.mail.search.FromTerm;
import com.openexchange.mail.search.HeaderTerm;
import com.openexchange.mail.search.ORTerm;
import com.openexchange.mail.search.ReceivedDateTerm;
import com.openexchange.mail.search.SearchTerm;
import com.openexchange.mail.search.SentDateTerm;
import com.openexchange.mail.search.SizeTerm;
import com.openexchange.mail.search.SubjectTerm;
import com.openexchange.mail.search.ToTerm;
import com.openexchange.search.SearchAttributeFetcher;
import com.openexchange.search.SingleSearchTerm;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.mail.internet.InternetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailAttributeFetcher
implements SearchAttributeFetcher<MailMessage> {
    static final Logger LOG = LoggerFactory.getLogger(MailAttributeFetcher.class);
    private static final Map<String, AttributeGetter> GETTERS;
    private static final MailAttributeFetcher instance;

    public static MailAttributeFetcher getInstance() {
        return instance;
    }

    private MailAttributeFetcher() {
    }

    public <T> T getAttribute(String attributeName, MailMessage candidate) {
        AttributeGetter getter = GETTERS.get(attributeName);
        if (null == getter) {
            LOG.info("No getter for field: {}", (Object)attributeName);
            return null;
        }
        Object retval = getter.getObject(candidate);
        return (T)retval;
    }

    public SearchTerm<?> getSearchTerm(String attributeName, SingleSearchTerm.SingleOperation operation, Object constant) {
        AttributeGetter getter = GETTERS.get(attributeName);
        if (null == getter) {
            LOG.info("No getter for field: {}", (Object)attributeName);
            return null;
        }
        return getter.getSearchTerm(operation, constant);
    }

    static {
        HashMap<String, AttributeGetter> m = new HashMap<String, AttributeGetter>(25);
        m.put(MailJSONField.CID.getKey(), new AttributeGetter(){

            @Override
            public Object getObject(MailMessage candidate) {
                return candidate.getContentId();
            }

            @Override
            public SearchTerm<?> getSearchTerm(SingleSearchTerm.SingleOperation operation, Object constant) {
                if (SingleSearchTerm.SingleOperation.EQUALS != operation) {
                    throw new IllegalArgumentException("Unsupported operation for header search: " + operation);
                }
                return new HeaderTerm(MessageHeaders.HDR_CONTENT_ID, constant.toString());
            }
        });
        m.put(MailJSONField.CONTENT.getKey(), new AttributeGetter(){

            @Override
            public Object getObject(MailMessage candidate) {
                try {
                    return candidate.getContent();
                }
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                    return null;
                }
            }

            @Override
            public SearchTerm<?> getSearchTerm(SingleSearchTerm.SingleOperation operation, Object constant) {
                if (SingleSearchTerm.SingleOperation.EQUALS != operation) {
                    throw new IllegalArgumentException("Unsupported operation for header search: " + operation);
                }
                return new BodyTerm(constant.toString());
            }
        });
        m.put(MailJSONField.CONTENT_TYPE.getKey(), new AttributeGetter(){

            @Override
            public Object getObject(MailMessage candidate) {
                return candidate.getContentType().toString();
            }

            @Override
            public SearchTerm<?> getSearchTerm(SingleSearchTerm.SingleOperation operation, Object constant) {
                if (SingleSearchTerm.SingleOperation.EQUALS != operation) {
                    throw new IllegalArgumentException("Unsupported operation for header search: " + operation);
                }
                return new HeaderTerm(MessageHeaders.HDR_CONTENT_TYPE, constant.toString());
            }
        });
        m.put(MailJSONField.DISPOSITION.getKey(), new AttributeGetter(){

            @Override
            public Object getObject(MailMessage candidate) {
                return candidate.getContentDisposition().getDisposition();
            }

            @Override
            public SearchTerm<?> getSearchTerm(SingleSearchTerm.SingleOperation operation, Object constant) {
                if (SingleSearchTerm.SingleOperation.EQUALS != operation) {
                    throw new IllegalArgumentException("Unsupported operation for header search: " + operation);
                }
                return new HeaderTerm(MessageHeaders.HDR_CONTENT_DISPOSITION, constant.toString());
            }
        });
        m.put(MailJSONField.DISPOSITION_NOTIFICATION_TO.getKey(), new AttributeGetter(){

            @Override
            public Object getObject(MailMessage candidate) {
                InternetAddress dispositionNotification = candidate.getDispositionNotification();
                return null == dispositionNotification ? null : dispositionNotification.toUnicodeString();
            }

            @Override
            public SearchTerm<?> getSearchTerm(SingleSearchTerm.SingleOperation operation, Object constant) {
                if (SingleSearchTerm.SingleOperation.EQUALS != operation) {
                    throw new IllegalArgumentException("Unsupported operation for header search: " + operation);
                }
                return new HeaderTerm(MessageHeaders.HDR_DISP_NOT_TO, constant.toString());
            }
        });
        m.put(MailJSONField.FLAGS.getKey(), new AttributeGetter(){

            @Override
            public Object getObject(MailMessage candidate) {
                return candidate.getFlags();
            }

            @Override
            public SearchTerm<?> getSearchTerm(SingleSearchTerm.SingleOperation operation, Object constant) {
                if (SingleSearchTerm.SingleOperation.EQUALS != operation) {
                    throw new IllegalArgumentException("Unsupported operation for flag search: " + operation);
                }
                try {
                    return new FlagTerm(Integer.parseInt(constant.toString()), true);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Unsupported value for flag search: " + operation);
                }
            }
        });
        m.put(MailJSONField.FROM.getKey(), new AttributeGetter(){

            @Override
            public Object getObject(MailMessage candidate) {
                InternetAddress[] from = candidate.getFrom();
                return null == from || from.length == 0 ? null : from[0].toUnicodeString();
            }

            @Override
            public SearchTerm<?> getSearchTerm(SingleSearchTerm.SingleOperation operation, Object constant) {
                if (SingleSearchTerm.SingleOperation.EQUALS != operation) {
                    throw new IllegalArgumentException("Unsupported operation for from search: " + operation);
                }
                return new FromTerm(constant.toString());
            }
        });
        m.put(MailJSONField.PRIORITY.getKey(), new AttributeGetter(){

            @Override
            public Object getObject(MailMessage candidate) {
                return candidate.getPriority();
            }

            @Override
            public SearchTerm<?> getSearchTerm(SingleSearchTerm.SingleOperation operation, Object constant) {
                int parsedPrio;
                if (SingleSearchTerm.SingleOperation.EQUALS != operation) {
                    throw new IllegalArgumentException("Unsupported operation for header search: " + operation);
                }
                String string = constant.toString();
                try {
                    parsedPrio = Integer.parseInt(string);
                }
                catch (NumberFormatException e) {
                    parsedPrio = -1;
                }
                String importance = parsedPrio >= 0 ? (3 == parsedPrio ? "Medium" : (parsedPrio > 3 ? "Low" : "High")) : "Medium";
                return new ORTerm(new HeaderTerm(MessageHeaders.HDR_IMPORTANCE, importance), new HeaderTerm(MessageHeaders.HDR_X_PRIORITY, string));
            }
        });
        m.put(MailJSONField.RECEIVED_DATE.getKey(), new AttributeGetter(){

            @Override
            public Object getObject(MailMessage candidate) {
                Date d = candidate.getReceivedDate();
                return null == d ? null : Long.valueOf(d.getTime());
            }

            @Override
            public SearchTerm<?> getSearchTerm(SingleSearchTerm.SingleOperation operation, Object constant) {
                ComparisonType ct = SingleSearchTerm.SingleOperation.EQUALS == operation ? ComparisonType.EQUALS : (SingleSearchTerm.SingleOperation.GREATER_THAN == operation ? ComparisonType.GREATER_THAN : ComparisonType.LESS_THAN);
                try {
                    return new ReceivedDateTerm(ct, new Date(Long.parseLong(constant.toString())));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Unsupported value for received date search: " + operation);
                }
            }
        });
        m.put(MailJSONField.RECIPIENT_BCC.getKey(), new AttributeGetter(){

            @Override
            public Object getObject(MailMessage candidate) {
                InternetAddress[] internetAddresses = candidate.getBcc();
                if (null == internetAddresses) {
                    return null;
                }
                int length = internetAddresses.length;
                if (length == 0) {
                    return null;
                }
                StringBuilder sb = new StringBuilder(length * 16);
                sb.append(internetAddresses[0].toUnicodeString());
                for (int i = 1; i < length; ++i) {
                    sb.append(',').append(internetAddresses[i].toUnicodeString());
                }
                return sb.toString();
            }

            @Override
            public SearchTerm<?> getSearchTerm(SingleSearchTerm.SingleOperation operation, Object constant) {
                if (SingleSearchTerm.SingleOperation.EQUALS != operation) {
                    throw new IllegalArgumentException("Unsupported operation for BCC search: " + operation);
                }
                return new BccTerm(constant.toString());
            }
        });
        m.put(MailJSONField.RECIPIENT_CC.getKey(), new AttributeGetter(){

            @Override
            public Object getObject(MailMessage candidate) {
                InternetAddress[] internetAddresses = candidate.getCc();
                if (null == internetAddresses) {
                    return null;
                }
                int length = internetAddresses.length;
                if (length == 0) {
                    return null;
                }
                StringBuilder sb = new StringBuilder(length * 16);
                sb.append(internetAddresses[0].toUnicodeString());
                for (int i = 1; i < length; ++i) {
                    sb.append(',').append(internetAddresses[i].toUnicodeString());
                }
                return sb.toString();
            }

            @Override
            public SearchTerm<?> getSearchTerm(SingleSearchTerm.SingleOperation operation, Object constant) {
                if (SingleSearchTerm.SingleOperation.EQUALS != operation) {
                    throw new IllegalArgumentException("Unsupported operation for CC search: " + operation);
                }
                return new CcTerm(constant.toString());
            }
        });
        m.put(MailJSONField.RECIPIENT_TO.getKey(), new AttributeGetter(){

            @Override
            public Object getObject(MailMessage candidate) {
                InternetAddress[] internetAddresses = candidate.getTo();
                if (null == internetAddresses) {
                    return null;
                }
                int length = internetAddresses.length;
                if (length == 0) {
                    return null;
                }
                StringBuilder sb = new StringBuilder(length * 16);
                sb.append(internetAddresses[0].toUnicodeString());
                for (int i = 1; i < length; ++i) {
                    sb.append(',').append(internetAddresses[i].toUnicodeString());
                }
                return sb.toString();
            }

            @Override
            public SearchTerm<?> getSearchTerm(SingleSearchTerm.SingleOperation operation, Object constant) {
                if (SingleSearchTerm.SingleOperation.EQUALS != operation) {
                    throw new IllegalArgumentException("Unsupported operation for TO search: " + operation);
                }
                return new ToTerm(constant.toString());
            }
        });
        m.put(MailJSONField.SENT_DATE.getKey(), new AttributeGetter(){

            @Override
            public Object getObject(MailMessage candidate) {
                Date d = candidate.getSentDate();
                return null == d ? null : Long.valueOf(d.getTime());
            }

            @Override
            public SearchTerm<?> getSearchTerm(SingleSearchTerm.SingleOperation operation, Object constant) {
                ComparisonType ct = SingleSearchTerm.SingleOperation.EQUALS == operation ? ComparisonType.EQUALS : (SingleSearchTerm.SingleOperation.GREATER_THAN == operation ? ComparisonType.GREATER_THAN : ComparisonType.LESS_THAN);
                try {
                    return new SentDateTerm(ct, new Date(Long.parseLong(constant.toString())));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Unsupported value for sent date search: " + operation);
                }
            }
        });
        m.put(MailJSONField.SIZE.getKey(), new AttributeGetter(){

            @Override
            public Object getObject(MailMessage candidate) {
                return candidate.getSize();
            }

            @Override
            public SearchTerm<?> getSearchTerm(SingleSearchTerm.SingleOperation operation, Object constant) {
                ComparisonType ct = SingleSearchTerm.SingleOperation.EQUALS == operation ? ComparisonType.EQUALS : (SingleSearchTerm.SingleOperation.GREATER_THAN == operation ? ComparisonType.GREATER_THAN : ComparisonType.LESS_THAN);
                try {
                    return new SizeTerm(ct, (int)Long.parseLong(constant.toString()));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Unsupported value for size search: " + operation);
                }
            }
        });
        m.put(MailJSONField.SUBJECT.getKey(), new AttributeGetter(){

            @Override
            public Object getObject(MailMessage candidate) {
                return candidate.getSubject();
            }

            @Override
            public SearchTerm<?> getSearchTerm(SingleSearchTerm.SingleOperation operation, Object constant) {
                if (SingleSearchTerm.SingleOperation.EQUALS != operation) {
                    throw new IllegalArgumentException("Unsupported operation for subject search: " + operation);
                }
                return new SubjectTerm(constant.toString());
            }
        });
        GETTERS = Collections.unmodifiableMap(m);
        instance = new MailAttributeFetcher();
    }

    private static interface AttributeGetter {
        public Object getObject(MailMessage var1);

        public SearchTerm<?> getSearchTerm(SingleSearchTerm.SingleOperation var1, Object var2);
    }
}

