/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.search;

import com.openexchange.java.Strings;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.search.SearchTerm;
import javax.mail.internet.AddressException;

public abstract class AbstractAddressTerm
extends SearchTerm<String> {
    private static final long serialVersionUID = -1266840509034246826L;
    protected final String addr;
    private String lowerCaseAddr;

    protected AbstractAddressTerm(String pattern) {
        String addr;
        try {
            addr = new QuotedInternetAddress(pattern, false).getUnicodeAddress();
        }
        catch (AddressException e) {
            addr = pattern;
        }
        this.addr = addr;
    }

    protected String getLowerCaseAddr() {
        String s = this.lowerCaseAddr;
        if (null == s) {
            this.lowerCaseAddr = s = Strings.asciiLowerCase((String)this.addr);
        }
        return s;
    }

    @Override
    public String getPattern() {
        return this.addr;
    }

    @Override
    public boolean isAscii() {
        return AbstractAddressTerm.isAscii(this.addr);
    }

    @Override
    public boolean containsWildcard() {
        return null == this.addr ? false : this.addr.indexOf(42) >= 0 || this.addr.indexOf(63) >= 0;
    }
}

