/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.processing;

import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.java.Strings;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.processing.LocaleAndTimeZone;
import com.openexchange.mail.mime.processing.MimeProcessingUtility;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import java.util.Date;
import java.util.regex.Pattern;
import javax.mail.internet.InternetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMimeProcessing {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMimeProcessing.class);
    private static final Pattern PATTERN_FROM = Pattern.compile(Pattern.quote("#FROM#"));
    private static final Pattern PATTERN_TO = Pattern.compile(Pattern.quote("#TO#"));
    private static final Pattern PATTERN_CC = Pattern.compile(Pattern.quote("#CC#"));
    private static final Pattern PATTERN_CCLINE = Pattern.compile(Pattern.quote("#CC_LINE#"));
    private static final Pattern PATTERN_DATE = Pattern.compile(Pattern.quote("#DATE#"));
    private static final Pattern PATTERN_TIME = Pattern.compile(Pattern.quote("#TIME#"));
    private static final Pattern PATTERN_SUBJECT = Pattern.compile(Pattern.quote("#SUBJECT#"));
    private static final Pattern PATTERN_SENDER = Pattern.compile(Pattern.quote("#SENDER#"));

    protected AbstractMimeProcessing() {
    }

    protected static String generatePrefixText(String prefixTemplate, LocaleAndTimeZone ltz, MailMessage msg) {
        InternetAddress[] cc;
        InternetAddress[] from;
        StringHelper strHelper = StringHelper.valueOf(ltz.locale);
        String prefix = strHelper.getString(prefixTemplate);
        if (prefix.indexOf("#FROM#") >= 0) {
            from = msg.getFrom();
            prefix = PATTERN_FROM.matcher(prefix).replaceAll(from == null || from.length == 0 ? "" : Strings.quoteReplacement((String)MimeProcessingUtility.addr2String(from[0])));
        }
        if (prefix.indexOf("#TO#") >= 0) {
            InternetAddress[] to = msg.getTo();
            prefix = PATTERN_TO.matcher(prefix).replaceAll(to == null || to.length == 0 ? "" : Strings.quoteReplacement((String)MimeProcessingUtility.addrs2String(to)));
        }
        if (prefix.indexOf("#CC#") >= 0) {
            cc = msg.getCc();
            prefix = PATTERN_CC.matcher(prefix).replaceAll(cc == null || cc.length == 0 ? "" : Strings.quoteReplacement((String)MimeProcessingUtility.addrs2String(cc)));
        }
        if (prefix.indexOf("#CC_LINE#") >= 0) {
            cc = msg.getCc();
            prefix = PATTERN_CCLINE.matcher(prefix).replaceAll(cc == null || cc.length == 0 ? "" : Strings.quoteReplacement((String)new StringBuilder(64).append("\nCc: ").append(MimeProcessingUtility.addrs2String(cc)).toString()));
        }
        Date date = msg.getSentDate();
        if (prefix.indexOf("#DATE#") >= 0) {
            try {
                prefix = PATTERN_DATE.matcher(prefix).replaceAll(date == null ? "" : Strings.quoteReplacement((String)MimeProcessingUtility.getFormattedDate(date, 1, ltz.locale, ltz.timeZone)));
            }
            catch (Exception t) {
                LOG.warn("", (Throwable)t);
                prefix = PATTERN_DATE.matcher(prefix).replaceAll("");
            }
        }
        if (prefix.indexOf("#TIME#") >= 0) {
            try {
                prefix = PATTERN_TIME.matcher(prefix).replaceAll(date == null ? "" : Strings.quoteReplacement((String)MimeProcessingUtility.getFormattedTime(date, 3, ltz.locale, ltz.timeZone)));
            }
            catch (Exception t) {
                LOG.warn("", (Throwable)t);
                prefix = PATTERN_TIME.matcher(prefix).replaceAll("");
            }
        }
        if (prefix.indexOf("#SUBJECT#") >= 0) {
            String decodedSubject = MimeMessageUtility.decodeMultiEncodedHeader(msg.getSubject());
            prefix = PATTERN_SUBJECT.matcher(prefix).replaceAll(decodedSubject == null ? "" : Strings.quoteReplacement((String)decodedSubject));
        }
        if (prefix.indexOf("#SENDER#") >= 0) {
            from = msg.getFrom();
            prefix = PATTERN_SENDER.matcher(prefix).replaceAll(from == null || from.length == 0 ? "" : Strings.quoteReplacement((String)MimeProcessingUtility.addr2String(from[0])));
        }
        return prefix;
    }
}

