/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Reloadable;
import com.openexchange.configuration.SystemConfig;
import com.openexchange.java.Charsets;
import com.openexchange.java.SortableConcurrentList;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.mail.config.MailReloadable;
import com.openexchange.mail.mime.MimeTypeFileLineParser;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MimeType2ExtMap {
    private static final Logger LOG = LoggerFactory.getLogger(MimeType2ExtMap.class);
    private static volatile ConcurrentMap<String, MimeTypeAssociation> typeMap;
    private static volatile ConcurrentMap<String, List<String>> extMap;
    private static final String MIME_APPL_OCTET = "application/octet-stream";
    private static final List<String> DEFAULT_MIME_TYPES;
    private static final String DEFAULT_EXT = "dat";
    private static final List<String> DEFAULT_EXTENSIONS;

    private MimeType2ExtMap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void reset() {
        if (null == typeMap) return;
        Class<MimeType2ExtMap> clazz = MimeType2ExtMap.class;
        synchronized (MimeType2ExtMap.class) {
            if (null == typeMap) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            typeMap = null;
            extMap = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init() {
        if (null != typeMap) return;
        Class<MimeType2ExtMap> clazz = MimeType2ExtMap.class;
        synchronized (MimeType2ExtMap.class) {
            if (null != typeMap) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            try {
                URL url;
                String javaHome;
                File file;
                ConcurrentHashMap<String, MimeTypeAssociation> typeMapping = new ConcurrentHashMap<String, MimeTypeAssociation>(1024, 0.9f, 1);
                typeMap = typeMapping;
                ConcurrentHashMap<String, List<String>> extMapping = new ConcurrentHashMap<String, List<String>>(1024, 0.9f, 1);
                extMap = extMapping;
                StringBuilder sb = new StringBuilder(128);
                boolean debugEnabled = LOG.isDebugEnabled();
                String homeDir = System.getProperty("user.home");
                if (homeDir != null && (file = new File(sb.append(homeDir).append(File.separatorChar).append(".mime.types").toString())).exists()) {
                    if (debugEnabled) {
                        sb.setLength(0);
                        LOG.debug(sb.append("Loading MIME type file \"").append(file.getPath()).append('\"').toString());
                    }
                    MimeType2ExtMap.loadInternal(file, typeMapping, extMapping);
                }
                if ((javaHome = System.getProperty("java.home")) != null) {
                    sb.setLength(0);
                    file = new File(sb.append(javaHome).append(File.separatorChar).append("lib").append(File.separator).append("mime.types").toString());
                    if (file.exists()) {
                        if (debugEnabled) {
                            sb.setLength(0);
                            LOG.debug(sb.append("Loading MIME type file \"").append(file.getPath()).append('\"').toString());
                        }
                        MimeType2ExtMap.loadInternal(file, typeMapping, extMapping);
                    }
                }
                Enumeration<URL> e = ClassLoader.getSystemResources("META-INF/mime.types");
                while (e.hasMoreElements()) {
                    url = e.nextElement();
                    if (debugEnabled) {
                        sb.setLength(0);
                        LOG.debug(sb.append("Loading MIME type file \"").append(url.getFile()).append('\"').toString());
                    }
                    MimeType2ExtMap.loadInternal(url, typeMapping, extMapping);
                }
                e = ClassLoader.getSystemResources("META-INF/mimetypes.default");
                while (e.hasMoreElements()) {
                    url = e.nextElement();
                    if (debugEnabled) {
                        sb.setLength(0);
                        LOG.debug(sb.append("Loading MIME type file \"").append(url.getFile()).append('\"').toString());
                    }
                    MimeType2ExtMap.loadInternal(url, typeMapping, extMapping);
                }
                String mimeTypesFileName = SystemConfig.getProperty(SystemConfig.Property.MimeTypeFileName);
                if (mimeTypesFileName != null && (mimeTypesFileName = mimeTypesFileName.trim()).length() > 0) {
                    File file2;
                    ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
                    File file3 = file2 = null == service ? null : service.getFileByName(mimeTypesFileName);
                    if (null != file2 && file2.exists()) {
                        if (debugEnabled) {
                            sb.setLength(0);
                            LOG.debug(sb.append("Loading MIME type file \"").append(file2.getPath()).append('\"').toString());
                        }
                        MimeType2ExtMap.loadInternal(file2, typeMapping, extMapping);
                    }
                }
                LOG.debug("MIMEType2ExtMap successfully initialized");
            }
            catch (IOException e) {
                LOG.error("", (Throwable)e);
            }
            return;
        }
    }

    public static void addMimeType(String mimeType, String fileExtension) {
        MimeType2ExtMap.addMimeType(mimeType, Collections.singletonList(fileExtension));
    }

    public static void addMimeType(String mimeType, List<String> fileExtensions) {
        CopyOnWriteArrayList<String> nl;
        MimeType2ExtMap.init();
        ConcurrentMap<String, MimeTypeAssociation> tm = typeMap;
        for (String ext : fileExtensions) {
            MimeType2ExtMap.addTypeMapping(ext, mimeType, tm);
        }
        ConcurrentMap<String, List<String>> em = extMap;
        CopyOnWriteArrayList<String> list = (CopyOnWriteArrayList<String>)em.get(mimeType);
        if (null == list && null == (list = (List)em.putIfAbsent(mimeType, nl = new CopyOnWriteArrayList<String>()))) {
            list = nl;
        }
        list.add(mimeType);
    }

    public static String getContentType(File file) {
        return MimeType2ExtMap.getContentType(file.getName(), MIME_APPL_OCTET);
    }

    public static String getContentType(File file, String fallBack) {
        return MimeType2ExtMap.getContentType(file.getName(), fallBack);
    }

    public static String getContentType(String fileName) {
        return MimeType2ExtMap.getContentType(fileName, MIME_APPL_OCTET);
    }

    public static String getContentType(String fileName, String fallBack) {
        MimeType2ExtMap.init();
        if (Strings.isEmpty((String)fileName)) {
            return fallBack;
        }
        String fn = Strings.unquote((String)fileName);
        int pos = fn.lastIndexOf(46);
        if (pos < 0) {
            return fallBack;
        }
        String s1 = fn.substring(pos + 1);
        if (s1.length() == 0) {
            return fallBack;
        }
        MimeTypeAssociation mta = (MimeTypeAssociation)typeMap.get(Strings.toLowerCase((CharSequence)s1));
        if (null == mta) {
            return fallBack;
        }
        String type = mta.get();
        return null == type ? fallBack : type;
    }

    public static List<String> getContentTypes(String fileName) {
        return MimeType2ExtMap.getContentTypes(fileName, DEFAULT_MIME_TYPES);
    }

    public static List<String> getContentTypes(String fileName, List<String> fallBack) {
        MimeType2ExtMap.init();
        if (Strings.isEmpty((String)fileName)) {
            return fallBack;
        }
        String fn = Strings.unquote((String)fileName);
        int pos = fn.lastIndexOf(46);
        if (pos < 0) {
            return fallBack;
        }
        String s1 = fn.substring(pos + 1);
        if (s1.length() == 0) {
            return fallBack;
        }
        MimeTypeAssociation mta = (MimeTypeAssociation)typeMap.get(Strings.toLowerCase((CharSequence)s1));
        if (null == mta) {
            return fallBack;
        }
        List<String> all = mta.getAll();
        return null == all || all.isEmpty() ? fallBack : all;
    }

    public static String getContentTypeByExtension(String extension) {
        return MimeType2ExtMap.getContentTypeByExtension(extension, MIME_APPL_OCTET);
    }

    public static String getContentTypeByExtension(String extension, String fallBack) {
        MimeType2ExtMap.init();
        if (Strings.isEmpty((String)extension)) {
            return fallBack;
        }
        MimeTypeAssociation mta = (MimeTypeAssociation)typeMap.get(Strings.toLowerCase((CharSequence)extension));
        if (null == mta) {
            return fallBack;
        }
        String type = mta.get();
        return null == type ? fallBack : type;
    }

    public static List<String> getFileExtensions(String mimeType) {
        MimeType2ExtMap.init();
        if (Strings.isEmpty((String)mimeType)) {
            return DEFAULT_EXTENSIONS;
        }
        if (!extMap.containsKey(Strings.toLowerCase((CharSequence)mimeType))) {
            return DEFAULT_EXTENSIONS;
        }
        List list = (List)extMap.get(mimeType);
        return null == list ? DEFAULT_EXTENSIONS : Collections.unmodifiableList(list);
    }

    public static String getFileExtension(String mimeType) {
        return MimeType2ExtMap.getFileExtension(mimeType, DEFAULT_EXT);
    }

    public static String getFileExtension(String mimeType, String defaultExt) {
        MimeType2ExtMap.init();
        if (Strings.isEmpty((String)mimeType)) {
            return defaultExt;
        }
        if (!extMap.containsKey(Strings.toLowerCase((CharSequence)mimeType))) {
            return defaultExt;
        }
        List list = (List)extMap.get(mimeType);
        return null == list || list.isEmpty() ? defaultExt : (String)list.get(0);
    }

    public static void load(String fileStr, ConcurrentMap<String, MimeTypeAssociation> typeMapping, ConcurrentMap<String, List<String>> extMapping) {
        MimeType2ExtMap.init();
        MimeType2ExtMap.load(new File(fileStr), typeMapping, extMapping);
    }

    public static void load(File file, ConcurrentMap<String, MimeTypeAssociation> typeMapping, ConcurrentMap<String, List<String>> extMapping) {
        MimeType2ExtMap.init();
        MimeType2ExtMap.loadInternal(file, typeMapping, extMapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadInternal(File file, ConcurrentMap<String, MimeTypeAssociation> typeMapping, ConcurrentMap<String, List<String>> extMapping) {
        FileInputStream stream = null;
        BufferedReader reader = null;
        try {
            stream = new FileInputStream(file);
            reader = new BufferedReader(new InputStreamReader((InputStream)stream, Charsets.ISO_8859_1));
            MimeType2ExtMap.parse(reader, typeMapping, extMapping);
        }
        catch (Exception e) {
            try {
                LOG.error("", (Throwable)e);
            }
            catch (Throwable throwable) {
                Streams.close((Closeable[])new Closeable[]{reader, stream});
                throw throwable;
            }
            Streams.close((Closeable[])new Closeable[]{reader, stream});
        }
        Streams.close((Closeable[])new Closeable[]{reader, stream});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadInternal(URL url, ConcurrentMap<String, MimeTypeAssociation> typeMapping, ConcurrentMap<String, List<String>> extMapping) {
        InputStream stream = null;
        BufferedReader reader = null;
        try {
            stream = url.openStream();
            reader = new BufferedReader(new InputStreamReader(stream, Charsets.ISO_8859_1));
            MimeType2ExtMap.parse(reader, typeMapping, extMapping);
        }
        catch (Exception e) {
            try {
                LOG.error("", (Throwable)e);
            }
            catch (Throwable throwable) {
                Streams.close((Closeable[])new Closeable[]{reader, stream});
                throw throwable;
            }
            Streams.close((Closeable[])new Closeable[]{reader, stream});
        }
        Streams.close((Closeable[])new Closeable[]{reader, stream});
    }

    private static void parse(BufferedReader reader, ConcurrentMap<String, MimeTypeAssociation> typeMapping, ConcurrentMap<String, List<String>> extMapping) throws IOException {
        String line = null;
        StringBuilder strBuilder = new StringBuilder(64);
        while ((line = reader.readLine()) != null) {
            int i = strBuilder.length();
            strBuilder.append(line);
            if (i > 0 && strBuilder.charAt(i - 1) == '\\') {
                strBuilder.delete(0, i - 1);
                continue;
            }
            MimeType2ExtMap.parseEntry(strBuilder.toString().trim(), typeMapping, extMapping);
            strBuilder.setLength(0);
        }
        if (strBuilder.length() > 0) {
            MimeType2ExtMap.parseEntry(strBuilder.toString().trim(), typeMapping, extMapping);
        }
    }

    private static void parseEntry(String entry, ConcurrentMap<String, MimeTypeAssociation> typeMapping, ConcurrentMap<String, List<String>> extMapping) {
        if (entry.length() == 0) {
            return;
        }
        if (entry.charAt(0) == '#') {
            return;
        }
        if (entry.indexOf(61) > 0) {
            MimeTypeFileLineParser parser = new MimeTypeFileLineParser(entry);
            String type = parser.getType();
            List<String> exts = parser.getExtensions();
            if (type != null && exts != null) {
                for (String ext : exts) {
                    MimeType2ExtMap.addTypeMapping(ext, type, typeMapping);
                }
                if (extMapping.containsKey(type)) {
                    ((List)extMapping.get(type)).addAll(exts);
                } else {
                    extMapping.put(type, exts);
                }
            }
        } else {
            String[] tokens = entry.split("[ \t\n\r\f]+");
            if (tokens.length > 1) {
                String type = Strings.toLowerCase((CharSequence)tokens[0]);
                CopyOnWriteArrayList<String> set = new CopyOnWriteArrayList<String>();
                for (int i = 1; i < tokens.length; ++i) {
                    String ext = Strings.toLowerCase((CharSequence)tokens[i]);
                    set.add(ext);
                    MimeType2ExtMap.addTypeMapping(ext, type, typeMapping);
                }
                if (extMapping.containsKey(type)) {
                    ((List)extMapping.get(type)).addAll(set);
                } else {
                    extMapping.put(type, set);
                }
            }
        }
    }

    private static void addTypeMapping(String ext, String mimeType, ConcurrentMap<String, MimeTypeAssociation> typeMapping) {
        MimeTypeAssociation nmta;
        MimeTypeAssociation mta = (MimeTypeAssociation)typeMapping.get(ext);
        if (null == mta && null == (mta = typeMapping.putIfAbsent(ext, nmta = new MimeTypeAssociation()))) {
            mta = nmta;
        }
        mta.add(mimeType);
    }

    static {
        MailReloadable.getInstance().addReloadable(new Reloadable(){

            public void reloadConfiguration(ConfigurationService configService) {
                MimeType2ExtMap.reset();
                MimeType2ExtMap.init();
            }

            public Map<String, String[]> getConfigFileNames() {
                return null;
            }
        });
        DEFAULT_MIME_TYPES = Collections.singletonList(MIME_APPL_OCTET);
        DEFAULT_EXTENSIONS = Collections.singletonList(DEFAULT_EXT);
    }

    private static final class ComparableMimeTypeEntry
    implements Comparable<ComparableMimeTypeEntry> {
        final String mimeType;

        ComparableMimeTypeEntry(String mimeType) {
            this.mimeType = mimeType;
        }

        @Override
        public int compareTo(ComparableMimeTypeEntry o) {
            int len2;
            int len1 = this.mimeType.length();
            return len1 < (len2 = o.mimeType.length()) ? -1 : (len1 == len2 ? 0 : 1);
        }

        public String toString() {
            return this.mimeType;
        }
    }

    private static final class MimeTypeAssociation {
        private final SortableConcurrentList<ComparableMimeTypeEntry> mimeTypeEntries = new SortableConcurrentList();

        MimeTypeAssociation() {
        }

        void add(String mimeType) {
            if (null != mimeType) {
                this.mimeTypeEntries.addAndSort((Comparable)new ComparableMimeTypeEntry(mimeType));
            }
        }

        String get() {
            List snapshot = this.mimeTypeEntries.getSnapshot();
            ComparableMimeTypeEntry e = snapshot.isEmpty() ? null : (ComparableMimeTypeEntry)snapshot.get(0);
            return null == e ? null : e.mimeType;
        }

        List<String> getAll() {
            List snapshot = this.mimeTypeEntries.getSnapshot();
            ArrayList<String> types = new ArrayList<String>(snapshot.size());
            for (ComparableMimeTypeEntry e : snapshot) {
                types.add(e.mimeType);
            }
            return types;
        }

        public String toString() {
            return this.mimeTypeEntries.toString();
        }
    }
}

