/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.exception.OXException;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailFolderStorageEnhanced;
import com.openexchange.mail.api.IMailFolderStorageEnhanced2;
import com.openexchange.mail.dataobjects.MailFolder;

class FolderInfo {
    final int total;
    final int unread;

    static FolderInfo getFolderInfo(String fullName, IMailFolderStorage folderStorage) throws OXException {
        if (folderStorage instanceof IMailFolderStorageEnhanced2) {
            IMailFolderStorageEnhanced2 enhanced2 = (IMailFolderStorageEnhanced2)folderStorage;
            int[] totalAndUnread = enhanced2.getTotalAndUnreadCounter(fullName);
            return new FolderInfo(totalAndUnread[0], totalAndUnread[1]);
        }
        if (folderStorage instanceof IMailFolderStorageEnhanced) {
            IMailFolderStorageEnhanced enhanced = (IMailFolderStorageEnhanced)folderStorage;
            int total = enhanced.getTotalCounter(fullName);
            int unread = enhanced.getUnreadCounter(fullName);
            return new FolderInfo(total, unread);
        }
        MailFolder folder = folderStorage.getFolder(fullName);
        return new FolderInfo(folder.getMessageCount(), folder.getUnreadMessageCount());
    }

    FolderInfo(int total, int unread) {
        this.total = total;
        this.unread = unread;
    }

    public String toString() {
        return new StringBuilder(32).append("{total=").append(this.total).append(", unread=").append(this.unread).append('}').toString();
    }
}

