/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.server.ServiceLookup;

@Action(method=RequestMethod.PUT, name="all_seen", description="Marks all mails as seen in specified mailbox/folder", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="folder", description="Identifier of the folder.")}, responseDescription="True")
public final class AllSeenAction
extends AbstractMailAction {
    public AllSeenAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        try {
            String folder = req.checkParameter("folder");
            MailServletInterface mailInterface = this.getMailInterface(req);
            mailInterface.updateMessageFlags(folder, null, 32, true);
            return new AJAXRequestResult((Object)Boolean.TRUE, "native");
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }
}

