/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n.tools;

import com.openexchange.i18n.I18nService;
import com.openexchange.i18n.I18nTranslator;
import com.openexchange.i18n.Translator;
import com.openexchange.server.services.I18nServices;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringHelper {
    private static final Logger LOG = LoggerFactory.getLogger(StringHelper.class);
    private static final ConcurrentMap<Locale, StringHelper> CACHE = new ConcurrentHashMap<Locale, StringHelper>(16, 0.9f, 1);
    private static final ConcurrentMap<Locale, Translator> TRANSLATOR_CACHE = new ConcurrentHashMap<Locale, Translator>(16, 0.9f, 1);
    private static final Locale DEFAULT_LOCALE = Locale.US;
    private final Locale locale;

    public static StringHelper valueOf(Locale locale) {
        StringHelper newHelper;
        Locale loc = null == locale ? DEFAULT_LOCALE : locale;
        StringHelper sh = (StringHelper)CACHE.get(loc);
        if (null == sh && null == (sh = CACHE.putIfAbsent(loc, newHelper = new StringHelper(loc)))) {
            sh = newHelper;
        }
        return sh;
    }

    public static Translator translatorFor(Locale locale) {
        Locale loc = null == locale ? DEFAULT_LOCALE : locale;
        Translator t = (Translator)TRANSLATOR_CACHE.get(loc);
        if (null == t) {
            I18nService service = I18nServices.getInstance().getService(loc);
            if (null == service) {
                return Translator.EMPTY;
            }
            I18nTranslator nt = new I18nTranslator(service);
            t = TRANSLATOR_CACHE.putIfAbsent(loc, (Translator)nt);
            if (null == t) {
                t = nt;
            }
        }
        return t;
    }

    private StringHelper(Locale locale) {
        this.locale = locale;
    }

    public final String getString(String key) {
        if (null == this.locale) {
            return key;
        }
        try {
            I18nService tool = I18nServices.getInstance().getService(this.locale);
            if (tool == null) {
                LOG.debug("No service for {}  found. Using default for bundle ", (Object)this.locale);
                return key;
            }
            return tool.getLocalized(key);
        }
        catch (MissingResourceException x) {
            LOG.debug("MissingResource for {}. Using default for bundle ", (Object)this.locale, (Object)x);
            return key;
        }
    }

    public int hashCode() {
        return this.locale == null ? 0 : this.locale.getClass().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof StringHelper) {
            StringHelper sh = (StringHelper)o;
            if (this.locale == null && sh.locale == null) {
                return true;
            }
            if (this.locale == null && sh.locale != null) {
                return false;
            }
            if (this.locale != null && sh.locale == null) {
                return false;
            }
            return sh.locale.equals(this.locale);
        }
        return false;
    }
}

