/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;

public final class MailAccountMigrateReplyToTask
extends UpdateTaskAdapter {
    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BLOCKING);
    }

    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        Connection con = Database.getNoTimeout(contextId, true);
        boolean committed = false;
        try {
            con.setAutoCommit(false);
            this.process("user_mail_account", con);
            this.process("user_transport_account", con);
            con.commit();
            committed = true;
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            if (!committed) {
                DBUtils.rollback(con);
            }
            DBUtils.autocommit(con);
            Database.backNoTimeout(contextId, true, con);
        }
    }

    private void process(String tableName, Connection con) throws OXException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT cid, user, id, value FROM " + tableName + "_properties WHERE name = ?");
            stmt.setString(1, "replyto");
            rs = stmt.executeQuery();
            if (rs.next()) {
                class Prop {
                    int context;
                    int user;
                    int id;
                    String value;

                    Prop(ResultSet rs) throws SQLException {
                        this.context = rs.getInt(1);
                        this.user = rs.getInt(2);
                        this.id = rs.getInt(3);
                        this.value = rs.getString(4);
                    }
                }
                LinkedList<Prop> props = new LinkedList<Prop>();
                do {
                    props.add(new Prop(rs));
                } while (rs.next());
                DBUtils.closeSQLStuff(rs, stmt);
                rs = null;
                stmt = con.prepareStatement("UPDATE " + tableName + " SET replyTo = ? WHERE cid = ? AND user = ? AND id = ?");
                for (Prop prop : props) {
                    int pos = 1;
                    stmt.setString(pos++, prop.value);
                    stmt.setInt(pos++, prop.context);
                    stmt.setInt(pos++, prop.user);
                    stmt.setInt(pos, prop.id);
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
    }
}

