/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.database.IncorrectStringSQLException;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.OXCalendarExceptionCodes;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.search.Order;
import com.openexchange.groupware.search.TaskSearchObject;
import com.openexchange.groupware.tasks.Mapper;
import com.openexchange.groupware.tasks.Mapping;
import com.openexchange.groupware.tasks.SQL;
import com.openexchange.groupware.tasks.StorageType;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.groupware.tasks.TaskIterator;
import com.openexchange.groupware.tasks.TaskIterator2;
import com.openexchange.groupware.tasks.TaskStorage;
import com.openexchange.groupware.tasks.Tools;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.Charsets;
import com.openexchange.server.impl.DBPool;
import com.openexchange.tools.StringCollection;
import com.openexchange.tools.arrays.Arrays;
import com.openexchange.tools.sql.DBUtils;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdbTaskStorage
extends TaskStorage {
    static final Logger LOG = LoggerFactory.getLogger(RdbTaskStorage.class);
    private static final String COUNT_TASKS = "SELECT COUNT(task.id) FROM task JOIN task_folder USING (cid,id) WHERE task.cid=? AND task_folder.folder=?";
    private static final Map<StorageType, String> LIST_MODIFIED = new EnumMap<StorageType, String>(StorageType.class);
    private static final String ONLY_OWN = " AND created_from=?";
    private static final String NO_PRIVATE = " AND private=false";

    RdbTaskStorage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TaskIterator load(Context ctx, int[] taskIds, int[] columns) throws OXException {
        Connection con = DBPool.pickup(ctx);
        try {
            TaskIterator taskIterator = null;
            return taskIterator;
        }
        finally {
            DBPool.closeReaderSilent(ctx, con);
        }
    }

    @Override
    public void delete(Context ctx, Connection con, int taskId, Date lastRead, StorageType type, boolean sanityCheck) throws OXException {
        String sql = "DELETE FROM @table@ WHERE cid=? AND id=? AND last_modified<=?";
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("DELETE FROM @table@ WHERE cid=? AND id=? AND last_modified<=?".replace("@table@", SQL.TASK_TABLES.get((Object)type)));
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, taskId);
            stmt.setLong(pos++, lastRead.getTime());
            int count = stmt.executeUpdate();
            if (sanityCheck && 1 != count) {
                throw TaskExceptionCode.MODIFIED.create();
            }
        }
        catch (SQLException e) {
            try {
                throw TaskExceptionCode.SQL_ERROR.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(null, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(null, stmt);
    }

    @Override
    public int countTasks(Context ctx, int userId, int folderId, boolean onlyOwn, boolean noPrivate) throws OXException {
        int number = 0;
        number = this.countTasks(ctx, folderId, onlyOwn, userId, noPrivate);
        return number;
    }

    @Override
    public TaskIterator list(final Context ctx, final int folderId, int from, int to, int orderBy, Order order, int[] columns, final boolean onlyOwn, final int userId, boolean noPrivate) throws OXException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append(SQL.getFields(columns, false));
        sql.append(" FROM task JOIN task_folder USING (cid,id) ");
        sql.append("WHERE task.cid=? AND task_folder.folder=?");
        if (onlyOwn) {
            sql.append(ONLY_OWN);
        }
        if (noPrivate) {
            sql.append(NO_PRIVATE);
        }
        sql.append(SQL.getOrder(orderBy, order));
        sql.append(SQL.getLimit(from, to));
        return new TaskIterator2(ctx, userId, sql.toString(), new TaskIterator2.StatementSetter(){

            @Override
            public void perform(PreparedStatement stmt) throws SQLException {
                int pos = 1;
                stmt.setInt(pos++, ctx.getContextId());
                stmt.setInt(pos++, folderId);
                if (onlyOwn) {
                    stmt.setInt(pos++, userId);
                }
            }
        }, folderId, columns, StorageType.ACTIVE);
    }

    @Override
    public TaskIterator search(final Context ctx, final int userId, final TaskSearchObject search, int orderBy, Order order, int[] columns, final List<Integer> all, final List<Integer> own, final List<Integer> shared) throws OXException {
        String patternCondition;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append(SQL.getFields(columns, true, true, null));
        sql.append(" FROM task JOIN task_folder USING (cid,id) ");
        sql.append("WHERE task.cid=? AND ");
        sql.append(SQL.allFoldersWhere(all, own, shared));
        final String rangeCondition = SQL.getRangeWhere(search);
        if (rangeCondition.length() > 0) {
            sql.append(" AND ");
            sql.append(rangeCondition);
        }
        if ((patternCondition = SQL.getPatternWhere(search)).length() > 0) {
            sql.append(" AND ");
            sql.append(patternCondition);
        }
        sql.append(" GROUP BY task.id");
        sql.append(SQL.getOrder(orderBy, order));
        return new TaskIterator2(ctx, userId, sql.toString(), new TaskIterator2.StatementSetter(){

            @Override
            public void perform(PreparedStatement stmt) throws SQLException {
                int i;
                int pos = 1;
                stmt.setInt(pos++, ctx.getContextId());
                Iterator i$ = all.iterator();
                while (i$.hasNext()) {
                    i = (Integer)i$.next();
                    stmt.setInt(pos++, i);
                }
                i$ = own.iterator();
                while (i$.hasNext()) {
                    i = (Integer)i$.next();
                    stmt.setInt(pos++, i);
                }
                if (own.size() > 0) {
                    stmt.setInt(pos++, userId);
                }
                i$ = shared.iterator();
                while (i$.hasNext()) {
                    i = (Integer)i$.next();
                    stmt.setInt(pos++, i);
                }
                if (rangeCondition.length() > 0) {
                    for (Date date : search.getRange()) {
                        stmt.setTimestamp(pos++, new Timestamp(date.getTime()));
                    }
                }
                if (patternCondition.length() > 0) {
                    String pattern = StringCollection.prepareForSearch(search.getPattern());
                    stmt.setString(pos++, pattern);
                    stmt.setString(pos++, pattern);
                    stmt.setString(pos++, pattern);
                }
                LOG.trace(stmt.toString());
            }
        }, -1, columns, StorageType.ACTIVE);
    }

    private int countTasks(Context ctx, int folderId, boolean onlyOwn, int userId, boolean noPrivate) throws OXException {
        Connection con = DBPool.pickup(ctx);
        int number = 0;
        try {
            ResultSet result;
            StringBuilder sql = new StringBuilder(COUNT_TASKS);
            if (onlyOwn) {
                sql.append(ONLY_OWN);
            }
            if (noPrivate) {
                sql.append(NO_PRIVATE);
            }
            PreparedStatement stmt = con.prepareStatement(sql.toString());
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, folderId);
            if (onlyOwn) {
                stmt.setInt(pos++, userId);
            }
            if ((result = stmt.executeQuery()).next()) {
                number = result.getInt(1);
            }
            result.close();
            stmt.close();
        }
        catch (SQLException e) {
            throw TaskExceptionCode.SQL_ERROR.create(e, new Object[0]);
        }
        finally {
            DBPool.closeReaderSilent(ctx, con);
        }
        return number;
    }

    @Override
    public void insertTask(Context ctx, Connection con, Task task, StorageType type, int[] columns) throws OXException {
        if (type == StorageType.ACTIVE) {
            this.handleUID(ctx, con, task);
        }
        StringBuilder insert = new StringBuilder();
        insert.append("INSERT INTO ");
        insert.append(SQL.TASK_TABLES.get((Object)type));
        insert.append(" (");
        ArrayList<Mapper<? extends Object>> usedMappers = new ArrayList<Mapper<? extends Object>>();
        for (Mapper<? extends Object> mapper : Mapping.MAPPERS) {
            if (!mapper.isSet(task) || null != columns && !Arrays.contains((int[])columns, (int)mapper.getId())) continue;
            insert.append(mapper.getDBColumnName());
            insert.append(',');
            usedMappers.add(mapper);
        }
        insert.append("cid,id) VALUES (");
        for (int i = 0; i < usedMappers.size(); ++i) {
            insert.append("?,");
        }
        insert.append("?,?)");
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(insert.toString());
            int pos = 1;
            for (int i = 0; i < usedMappers.size(); ++i) {
                ((Mapper)usedMappers.get(i)).toDB(stmt, pos++, task);
            }
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, task.getObjectID());
            stmt.execute();
        }
        catch (DataTruncation e) {
            throw RdbTaskStorage.parseTruncated(con, e, task, type);
        }
        catch (IncorrectStringSQLException e) {
            throw Tools.parseIncorrectString(e);
        }
        catch (SQLException e) {
            throw TaskExceptionCode.SQL_ERROR.create(e, new Object[0]);
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
    }

    private void handleUID(Context ctx, Connection con, Task task) throws OXException {
        if (task.containsUid()) {
            if (RdbTaskStorage.checkUid(ctx, con, task.getUid())) {
                throw OXCalendarExceptionCodes.TASK_UID_ALREDY_EXISTS.create(task.getTitle(), task.getUid());
            }
        } else {
            task.setUid(UUID.randomUUID().toString());
        }
    }

    private static boolean checkUid(Context ctx, Connection con, String uid) throws OXException {
        boolean bl;
        StringBuilder select = new StringBuilder("Select id from task where uid=? and cid=?");
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(select.toString());
            stmt.setString(1, uid);
            stmt.setInt(2, ctx.getContextId());
            rs = stmt.executeQuery();
            bl = rs.next();
        }
        catch (SQLException e) {
            try {
                throw OXCalendarExceptionCodes.CALENDAR_SQL_ERROR.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeResources(rs, (Statement)stmt, null, true, ctx);
                throw throwable;
            }
        }
        DBUtils.closeResources(rs, (Statement)stmt, null, true, ctx);
        return bl;
    }

    @Override
    public boolean existsTask(Context ctx, Connection con, int taskId, StorageType type) throws OXException {
        boolean exists;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append(Mapping.getMapping(1).getDBColumnName());
        sql.append(" FROM ");
        sql.append(SQL.TASK_TABLES.get((Object)type));
        sql.append(" WHERE cid=? AND id=?");
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(sql.toString());
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, taskId);
            result = stmt.executeQuery();
            exists = result.next() && taskId == result.getInt(1);
        }
        catch (SQLException e) {
            try {
                throw TaskExceptionCode.SQL_ERROR.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return exists;
    }

    @Override
    public Task selectTask(Context ctx, Connection con, int taskId, StorageType type) throws OXException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append(SQL.getAllFields());
        sql.append(" FROM ");
        sql.append(SQL.TASK_TABLES.get((Object)type));
        sql.append(" WHERE cid=? AND id=?");
        PreparedStatement stmt = null;
        ResultSet result = null;
        Task task = null;
        try {
            stmt = con.prepareStatement(sql.toString());
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, taskId);
            result = stmt.executeQuery();
            if (result.next()) {
                task = new Task();
                int pos = 1;
                for (Mapper<? extends Object> mapper : Mapping.MAPPERS) {
                    mapper.fromDB(result, pos++, task);
                }
                task.setObjectID(taskId);
            }
        }
        catch (SQLException e) {
            try {
                throw TaskExceptionCode.SQL_ERROR.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        if (null == task) {
            throw TaskExceptionCode.TASK_NOT_FOUND.create(Autoboxing.I((int)taskId), Autoboxing.I((int)ctx.getContextId()));
        }
        return task;
    }

    @Override
    public void updateTask(Context ctx, Connection con, Task task, Date lastRead, int[] modified, StorageType type) throws OXException {
        if (modified.length == 0) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        sql.append(SQL.TASK_TABLES.get((Object)type));
        sql.append(" SET ");
        for (int i : modified) {
            sql.append(Mapping.getMapping(i).getDBColumnName());
            sql.append("=?,");
        }
        sql.setLength(sql.length() - 1);
        sql.append(" WHERE cid=? AND id=? AND last_modified<=?");
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(sql.toString());
            int pos = 1;
            for (int i : modified) {
                Mapping.getMapping(i).toDB(stmt, pos++, task);
            }
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, task.getObjectID());
            stmt.setLong(pos++, lastRead.getTime());
            int updatedRows = stmt.executeUpdate();
            if (0 == updatedRows) {
                throw TaskExceptionCode.MODIFIED.create();
            }
        }
        catch (DataTruncation e) {
            throw RdbTaskStorage.parseTruncated(con, e, task, type);
        }
        catch (IncorrectStringSQLException e) {
            throw Tools.parseIncorrectString(e);
        }
        catch (SQLException e) {
            throw TaskExceptionCode.SQL_ERROR.create(e, new Object[0]);
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
    }

    private static OXException parseTruncated(Connection con, DataTruncation exc, Task task, StorageType type) {
        OXException tske;
        String[] fields = DBUtils.parseTruncatedFields(exc);
        StringBuilder sFields = new StringBuilder();
        OXException.Truncated[] truncateds = new OXException.Truncated[fields.length];
        Mapper<?>[] mappers = SQL.mapColumns(fields);
        for (int i = 0; i < fields.length; ++i) {
            sFields.append(fields[i]);
            sFields.append(", ");
            final Mapper<?> mapper = mappers[i];
            Object tmp = mapper.get(task);
            final int valueLength = tmp instanceof String ? Charsets.getBytes((String)((String)tmp), (Charset)Charsets.UTF_8).length : tmp.toString().length();
            int tmp2 = -1;
            try {
                tmp2 = DBUtils.getColumnSize(con, SQL.TASK_TABLES.get((Object)type), mapper.getDBColumnName());
            }
            catch (SQLException e) {
                LOG.error("", (Throwable)e);
                tmp2 = -1;
            }
            final int length = -1 == tmp2 ? 0 : tmp2;
            truncateds[i] = new OXException.Truncated(){

                public int getId() {
                    return mapper.getId();
                }

                public int getLength() {
                    return valueLength;
                }

                public int getMaxSize() {
                    return length;
                }
            };
        }
        sFields.setLength(sFields.length() - 2);
        if (truncateds.length > 0) {
            OXException.Truncated truncated = truncateds[0];
            tske = TaskExceptionCode.TRUNCATED.create(exc, sFields.toString(), truncated.getMaxSize(), truncated.getLength());
        } else {
            tske = TaskExceptionCode.TRUNCATED.create(exc, sFields.toString(), 0, 0);
        }
        for (OXException.Truncated truncated : truncateds) {
            tske.addProblematic((OXException.ProblematicAttribute)truncated);
        }
        return tske;
    }

    @Override
    public boolean containsNotSelfCreatedTasks(Context ctx, Connection con, int userId, int folderId) throws OXException {
        String sql = "SELECT COUNT(id) FROM task JOIN task_folder USING (cid,id) WHERE task.cid=? AND folder=? AND created_from!=?";
        boolean retval = true;
        try {
            PreparedStatement stmt = con.prepareStatement("SELECT COUNT(id) FROM task JOIN task_folder USING (cid,id) WHERE task.cid=? AND folder=? AND created_from!=?");
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, folderId);
            stmt.setInt(pos++, userId);
            ResultSet result = stmt.executeQuery();
            if (!result.next()) {
                throw TaskExceptionCode.NO_COUNT_RESULT.create();
            }
            retval = result.getInt(1) > 0;
            result.close();
            stmt.close();
        }
        catch (SQLException e) {
            throw TaskExceptionCode.SQL_ERROR.create(e, new Object[0]);
        }
        return retval;
    }

    @Override
    public TaskIterator list(final Context ctx, final int folderId, int from, int to, int orderBy, Order order, int[] columns, final boolean onlyOwn, final int userId, boolean noPrivate, Connection con) throws OXException {
        if (con == null) {
            return this.list(ctx, folderId, from, to, orderBy, order, columns, onlyOwn, userId, noPrivate);
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append(SQL.getFields(columns, false));
        sql.append(" FROM task JOIN task_folder USING (cid,id) ");
        if (folderId != -1) {
            sql.append("WHERE task.cid=? AND task_folder.folder=?");
        } else {
            sql.append("WHERE task.cid=?");
        }
        if (onlyOwn) {
            sql.append(ONLY_OWN);
        }
        if (noPrivate) {
            sql.append(NO_PRIVATE);
        }
        sql.append(SQL.getOrder(orderBy, order));
        sql.append(SQL.getLimit(from, to));
        return new TaskIterator2(ctx, userId, sql.toString(), new TaskIterator2.StatementSetter(){

            @Override
            public void perform(PreparedStatement stmt) throws SQLException {
                int pos = 1;
                stmt.setInt(pos++, ctx.getContextId());
                if (folderId != -1) {
                    stmt.setInt(pos++, folderId);
                }
                if (onlyOwn) {
                    stmt.setInt(pos++, userId);
                }
            }
        }, folderId, columns, StorageType.ACTIVE, con);
    }

    @Override
    int countTasks(Context ctx) throws OXException {
        int retval;
        Connection con = Database.get(ctx, false);
        try {
            retval = this.countTasks(ctx.getContextId(), con);
        }
        catch (SQLException e) {
            throw TaskExceptionCode.SQL_ERROR.create(e, new Object[0]);
        }
        finally {
            Database.back(ctx, false, con);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int countTasks(int contextId, Connection con) throws SQLException, OXException {
        int retval;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement("SELECT count(id) FROM task WHERE cid=?");
            stmt.setInt(1, contextId);
            result = stmt.executeQuery();
            if (!result.next()) {
                throw TaskExceptionCode.NO_COUNT_RESULT.create();
            }
            retval = result.getInt(1);
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(result, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(result, stmt);
        return retval;
    }

    static {
        LIST_MODIFIED.put(StorageType.ACTIVE, "SELECT @fields@ FROM task JOIN task_folder USING (cid,id) WHERE task.cid=? AND folder=? AND last_modified>?");
    }
}

