/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.reminder.TargetService;
import com.openexchange.groupware.tasks.StorageType;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.groupware.tasks.TaskStorage;
import java.sql.Connection;
import java.util.Date;

public final class ModifyThroughDependant
implements TargetService {
    private static final int[] UPDATE_FIELDS = new int[]{5, 3};
    private static final TaskStorage stor = TaskStorage.getInstance();

    @Override
    public void updateTargetObject(Context ctx, Connection con, int targetId) throws OXException {
        Task task;
        try {
            task = stor.selectTask(ctx, con, targetId, StorageType.ACTIVE);
        }
        catch (OXException e) {
            if (TaskExceptionCode.TASK_NOT_FOUND.equals(e)) {
                return;
            }
            throw e;
        }
        Date lastModified = task.getLastModified();
        task.setLastModified(new Date());
        stor.updateTask(ctx, con, task, lastModified, new int[]{5}, StorageType.ACTIVE);
    }

    @Override
    public void updateTargetObject(Context ctx, Connection con, int targetId, int userId) throws OXException {
        Task task;
        try {
            task = stor.selectTask(ctx, con, targetId, StorageType.ACTIVE);
        }
        catch (OXException e) {
            if (TaskExceptionCode.TASK_NOT_FOUND.equals(e)) {
                return;
            }
            throw e;
        }
        Date lastModified = task.getLastModified();
        task.setLastModified(new Date());
        task.setModifiedBy(userId);
        stor.updateTask(ctx, con, task, lastModified, UPDATE_FIELDS, StorageType.ACTIVE);
    }
}

