/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.validation;

import com.openexchange.capabilities.CapabilityService;
import com.openexchange.capabilities.CapabilitySet;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.group.GroupService;
import com.openexchange.groupware.container.ObjectPermission;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.infostore.validation.DocumentMetadataValidation;
import com.openexchange.groupware.infostore.validation.InfostoreValidator;
import com.openexchange.groupware.userconfiguration.UserConfigurationCodes;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.groupware.userconfiguration.UserPermissionBitsStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.share.GuestInfo;
import com.openexchange.share.ShareExceptionCodes;
import com.openexchange.share.ShareService;
import com.openexchange.share.recipient.RecipientType;
import com.openexchange.tools.session.ServerSession;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.LoggerFactory;

public class ObjectPermissionValidator
implements InfostoreValidator {
    private final DBProvider dbProvider;

    public ObjectPermissionValidator(DBProvider dbProvider) {
        this.dbProvider = dbProvider;
    }

    @Override
    public String getName() {
        return ObjectPermissionValidator.class.getSimpleName();
    }

    @Override
    public DocumentMetadataValidation validate(ServerSession session, DocumentMetadata metadata, DocumentMetadata originalDocument, Set<Metadata> updatedColumns) {
        DocumentMetadataValidation validation = new DocumentMetadataValidation();
        List<ObjectPermission> touchedPermissions = ObjectPermissionValidator.getTouchedPermissions(metadata, originalDocument, updatedColumns);
        if (null == touchedPermissions || 0 == touchedPermissions.size()) {
            return validation;
        }
        if (!this.checkPermissionBits(touchedPermissions, validation)) {
            return validation;
        }
        if (!this.checkPermissionEntities(session, touchedPermissions, validation)) {
            return validation;
        }
        if (!this.checkCapabilities(session, touchedPermissions, validation)) {
            return validation;
        }
        return validation;
    }

    private boolean checkCapabilities(ServerSession session, List<ObjectPermission> touchedPermissions, DocumentMetadataValidation validation) {
        ShareService shareService = ServerServiceRegistry.getServize(ShareService.class);
        CapabilitySet capabilities = null;
        try {
            capabilities = ServerServiceRegistry.getServize(CapabilityService.class).getCapabilities((Session)session);
        }
        catch (OXException e) {
            LoggerFactory.getLogger(ObjectPermissionValidator.class).warn("Error getting capabilities for user {}", (Object)Autoboxing.I((int)session.getUserId()), (Object)e);
            validation.setFatalException(e);
        }
        for (ObjectPermission permission : touchedPermissions) {
            GuestInfo guestInfo = null;
            if (!permission.isGroup()) {
                try {
                    guestInfo = shareService.getGuestInfo((Session)session, permission.getEntity());
                }
                catch (OXException e) {
                    LoggerFactory.getLogger(ObjectPermissionValidator.class).warn("Error getting guest info for permission entity {}", (Object)Autoboxing.I((int)permission.getEntity()), (Object)e);
                    validation.setFatalException(e);
                }
            }
            if (null == guestInfo) continue;
            if (RecipientType.ANONYMOUS.equals((Object)guestInfo.getRecipientType())) {
                if (null != capabilities && capabilities.contains("share_links")) continue;
                OXException e = ShareExceptionCodes.NO_SHARE_LINK_PERMISSION.create();
                validation.setError(Metadata.OBJECT_PERMISSIONS_LITERAL, e.getDisplayMessage(session.getUser().getLocale()));
                validation.setException(e);
                return false;
            }
            if (!RecipientType.GUEST.equals((Object)guestInfo.getRecipientType()) || null != capabilities && capabilities.contains("invite_guests")) continue;
            OXException e = ShareExceptionCodes.NO_INVITE_GUEST_PERMISSION.create();
            validation.setError(Metadata.OBJECT_PERMISSIONS_LITERAL, e.getDisplayMessage(session.getUser().getLocale()));
            validation.setException(e);
            return false;
        }
        return true;
    }

    private boolean checkPermissionBits(List<ObjectPermission> touchedPermissions, DocumentMetadataValidation validation) {
        for (ObjectPermission permission : touchedPermissions) {
            int bits = permission.getPermissions();
            if (4 == bits) {
                validation.setError(Metadata.OBJECT_PERMISSIONS_LITERAL, "DELETE object permission is not allowed.");
                validation.setException(InfostoreExceptionCodes.VALIDATION_FAILED_INAPPLICABLE_PERMISSIONS.create(Autoboxing.I((int)permission.getEntity())));
                return false;
            }
            if (2 == bits || 1 == bits) continue;
            validation.setError(Metadata.OBJECT_PERMISSIONS_LITERAL, "Invalid permission bits: " + bits);
            validation.setException(InfostoreExceptionCodes.VALIDATION_FAILED_INAPPLICABLE_PERMISSIONS.create(Autoboxing.I((int)permission.getEntity())));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkPermissionEntities(ServerSession session, List<ObjectPermission> touchedPermissions, DocumentMetadataValidation validation) {
        ArrayList<Integer> userIDs = new ArrayList<Integer>();
        int[] groupIDs = ObjectPermissionValidator.getGroupEntities(touchedPermissions);
        if (null != groupIDs) {
            for (int groupID : groupIDs) {
                try {
                    Group group = ServerServiceRegistry.getServize(GroupService.class).getGroup(session.getContext(), groupID);
                    if (Integer.MAX_VALUE == group.getIdentifier()) {
                        validation.setError(Metadata.OBJECT_PERMISSIONS_LITERAL, "Group " + group.getDisplayName() + " can't be used for object permissions.");
                        validation.setException(InfostoreExceptionCodes.VALIDATION_FAILED_INAPPLICABLE_PERMISSIONS.create(Autoboxing.I((int)groupID)));
                        return false;
                    }
                }
                catch (OXException e) {
                    if ("GRP-0017".equals(e.getErrorCode())) {
                        validation.setError(Metadata.OBJECT_PERMISSIONS_LITERAL, e.getDisplayMessage(session.getUser().getLocale()));
                        validation.setException(InfostoreExceptionCodes.VALIDATION_FAILED_INAPPLICABLE_PERMISSIONS.create(Autoboxing.I((int)groupID)));
                        return false;
                    }
                    LoggerFactory.getLogger(ObjectPermissionValidator.class).warn("Error getting group for permission entity {}", (Object)Autoboxing.I((int)groupID), (Object)e);
                    validation.setFatalException(e);
                }
            }
        }
        userIDs.addAll(ObjectPermissionValidator.getUserEntities(touchedPermissions));
        if (null != userIDs) {
            UserPermissionBitsStorage permissionBitsStorage = UserPermissionBitsStorage.getInstance();
            Connection connection = null;
            try {
                connection = this.dbProvider.getReadConnection(session.getContext());
                Iterator i$ = userIDs.iterator();
                while (i$.hasNext()) {
                    int userID = (Integer)i$.next();
                    try {
                        UserPermissionBits permissionBits = permissionBitsStorage.getUserPermissionBits(connection, userID, session.getContext());
                        if (permissionBits.hasFullSharedFolderAccess() && permissionBits.hasInfostore()) continue;
                        validation.setError(Metadata.OBJECT_PERMISSIONS_LITERAL, "User " + userID + " has no permission to see share items.");
                        validation.setException(InfostoreExceptionCodes.VALIDATION_FAILED_INAPPLICABLE_PERMISSIONS.create(Autoboxing.I((int)userID)));
                        boolean bl = false;
                        return bl;
                    }
                    catch (OXException e) {
                        if (UserConfigurationCodes.NOT_FOUND.equals(e)) {
                            validation.setError(Metadata.OBJECT_PERMISSIONS_LITERAL, e.getDisplayMessage(session.getUser().getLocale()));
                            validation.setException(InfostoreExceptionCodes.VALIDATION_FAILED_INAPPLICABLE_PERMISSIONS.create(Autoboxing.I((int)userID)));
                            boolean bl = false;
                            return bl;
                        }
                        LoggerFactory.getLogger(ObjectPermissionValidator.class).warn("Error getting user configuration for permission entity {}", (Object)Autoboxing.I((int)userID), (Object)e);
                        validation.setFatalException(e);
                    }
                }
            }
            catch (OXException e) {
                LoggerFactory.getLogger(ObjectPermissionValidator.class).warn("Error getting user configuration for permission entities", (Throwable)e);
                validation.setFatalException(e);
            }
            finally {
                if (null != connection) {
                    this.dbProvider.releaseReadConnection(session.getContext(), connection);
                }
            }
        }
        return true;
    }

    private static int[] getGroupEntities(List<ObjectPermission> objectPermissions) {
        if (null != objectPermissions && 0 < objectPermissions.size()) {
            ArrayList<Integer> groupIDs = new ArrayList<Integer>();
            for (ObjectPermission objectPermission : objectPermissions) {
                if (!objectPermission.isGroup()) continue;
                groupIDs.add(Autoboxing.I((int)objectPermission.getEntity()));
            }
            return 0 < groupIDs.size() ? Autoboxing.I2i(groupIDs) : null;
        }
        return null;
    }

    private static List<Integer> getUserEntities(List<ObjectPermission> objectPermissions) {
        ArrayList<Integer> userIDs = new ArrayList<Integer>();
        if (null != objectPermissions && 0 < objectPermissions.size()) {
            for (ObjectPermission objectPermission : objectPermissions) {
                if (objectPermission.isGroup()) continue;
                userIDs.add(Autoboxing.I((int)objectPermission.getEntity()));
            }
        }
        return userIDs;
    }

    private static List<ObjectPermission> getTouchedPermissions(DocumentMetadata metadata, DocumentMetadata originalDocument, Set<Metadata> updatedColumns) {
        if (null == originalDocument) {
            return metadata.getObjectPermissions();
        }
        if (null != updatedColumns && !updatedColumns.contains(Metadata.OBJECT_PERMISSIONS_LITERAL)) {
            return null;
        }
        List<ObjectPermission> originalPermissions = originalDocument.getObjectPermissions();
        List<ObjectPermission> newPermissions = metadata.getObjectPermissions();
        ArrayList<ObjectPermission> touchedPermissions = new ArrayList<ObjectPermission>();
        if (null != newPermissions) {
            for (ObjectPermission permission : newPermissions) {
                ObjectPermission originalPermission = ObjectPermissionValidator.getPermissionByEntity(originalPermissions, permission.getEntity());
                if (null != originalPermission && originalPermission.equals(permission)) continue;
                touchedPermissions.add(permission);
            }
        }
        if (null != originalPermissions) {
            for (ObjectPermission permission : originalPermissions) {
                if (null != ObjectPermissionValidator.getPermissionByEntity(newPermissions, permission.getEntity())) continue;
                touchedPermissions.add(permission);
            }
        }
        return touchedPermissions;
    }

    private static ObjectPermission getPermissionByEntity(List<ObjectPermission> permissions, int entity) {
        if (null != permissions) {
            for (ObjectPermission permission : permissions) {
                if (permission.getEntity() != entity) continue;
                return permission;
            }
        }
        return null;
    }
}

