/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database.impl;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.EffectiveInfostoreFolderPermission;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.database.impl.InfostoreSecurity;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.Strings;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderIteratorSQL;
import com.openexchange.tools.session.ServerSession;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Tools {
    private static final Pattern IS_NUMBERED_WITH_EXTENSION = Pattern.compile("\\(\\d+\\)\\.");
    private static final Pattern IS_NUMBERED = Pattern.compile("\\(\\d+\\)$");

    public static Set<String> getEnhancedWildcards(Set<String> fileNames) {
        HashSet<String> possibleWildcards = new HashSet<String>(fileNames.size());
        for (String filename : fileNames) {
            if (Strings.isEmpty((String)filename)) continue;
            StringBuilder stringBuilder = new StringBuilder(filename);
            Matcher matcher = IS_NUMBERED_WITH_EXTENSION.matcher(filename);
            if (matcher.find()) {
                stringBuilder.replace(matcher.start(), matcher.end() - 1, "(%)");
                possibleWildcards.add(stringBuilder.toString());
                continue;
            }
            matcher = IS_NUMBERED.matcher(filename);
            if (matcher.find()) {
                stringBuilder.replace(matcher.start(), matcher.end(), "(%)");
                possibleWildcards.add(stringBuilder.toString());
                continue;
            }
            int index = 0;
            index = filename.endsWith(".pgp") ? filename.substring(0, filename.length() - 4).lastIndexOf(46) : filename.lastIndexOf(46);
            if (0 >= index) {
                index = filename.length();
            }
            stringBuilder.insert(index, " (%)");
            possibleWildcards.add(stringBuilder.toString());
        }
        return possibleWildcards;
    }

    public static List<Integer> getObjectIDs(List<FileStorageFileAccess.IDTuple> tuples) throws OXException {
        if (null == tuples) {
            return null;
        }
        ArrayList<Integer> ids = new ArrayList<Integer>(tuples.size());
        try {
            for (FileStorageFileAccess.IDTuple tuple : tuples) {
                ids.add(Integer.valueOf(tuple.getId()));
            }
        }
        catch (NumberFormatException e) {
            throw InfostoreExceptionCodes.NOT_EXIST.create();
        }
        return ids;
    }

    public static int[] getObjectIDArray(List<FileStorageFileAccess.IDTuple> tuples) throws OXException {
        if (null == tuples) {
            return null;
        }
        int[] ids = new int[tuples.size()];
        try {
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = Integer.parseInt(tuples.get(i).getId());
            }
        }
        catch (NumberFormatException e) {
            throw InfostoreExceptionCodes.NOT_EXIST.create();
        }
        return ids;
    }

    public static List<Integer> getIDs(List<DocumentMetadata> documents) throws OXException {
        if (null == documents) {
            return null;
        }
        ArrayList<Integer> ids = new ArrayList<Integer>(documents.size());
        for (DocumentMetadata document : documents) {
            ids.add(document.getId());
        }
        return ids;
    }

    public static Map<Integer, Long> getIDsToFolders(List<FileStorageFileAccess.IDTuple> tuples) throws OXException {
        HashMap<Integer, Long> idsToFolders = new HashMap<Integer, Long>(tuples.size());
        try {
            for (FileStorageFileAccess.IDTuple idTuple : tuples) {
                idsToFolders.put(Integer.valueOf(idTuple.getId()), Long.valueOf(idTuple.getFolder()));
            }
        }
        catch (NumberFormatException e) {
            throw InfostoreExceptionCodes.NOT_EXIST.create();
        }
        return idsToFolders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Integer, EffectiveInfostoreFolderPermission> gatherVisibleFolders(InfostoreSecurity security, Connection connection, Context context, User user, UserPermissionBits userPermissions, int[] requestedFolderIDs, Collection<Integer> all, Collection<Integer> own) throws OXException {
        HashMap<Integer, EffectiveInfostoreFolderPermission> permissionsByFolderID = new HashMap<Integer, EffectiveInfostoreFolderPermission>();
        if (null != requestedFolderIDs) {
            for (int folderID : requestedFolderIDs) {
                EffectiveInfostoreFolderPermission infostorePermission = security.getFolderPermission(folderID, context, user, userPermissions, connection);
                if (!infostorePermission.canReadOwnObjects()) {
                    throw InfostoreExceptionCodes.NO_READ_PERMISSION.create();
                }
                Tools.trackEffectivePermission(infostorePermission, permissionsByFolderID, all, own);
            }
        } else {
            SearchIterator<FolderObject> searchIterator = null;
            try {
                searchIterator = OXFolderIteratorSQL.getAllVisibleFoldersIteratorOfModule(user.getId(), user.getGroups(), userPermissions.getAccessibleModules(), 8, context, connection);
                while (searchIterator.hasNext()) {
                    FolderObject folder = (FolderObject)searchIterator.next();
                    if (16 == folder.getType()) continue;
                    EffectivePermission permission = folder.getEffectiveUserPermission(user.getId(), userPermissions);
                    EffectiveInfostoreFolderPermission infostorePermission = new EffectiveInfostoreFolderPermission(permission, folder.getCreatedBy());
                    Tools.trackEffectivePermission(infostorePermission, permissionsByFolderID, all, own);
                }
            }
            finally {
                SearchIterators.close(searchIterator);
            }
            int sharedFilesFolderID = 10;
            EffectiveInfostoreFolderPermission infostorePermission = security.getFolderPermission(sharedFilesFolderID, context, user, userPermissions, connection);
            Tools.trackEffectivePermission(infostorePermission, permissionsByFolderID, all, own);
        }
        return permissionsByFolderID;
    }

    private static Map<Integer, EffectiveInfostoreFolderPermission> gatherVisibleFolders(InfostoreSecurity security, Connection connection, Context context, User user, UserPermissionBits userPermissions, int rootFolderID, boolean ignoreTrash, Collection<Integer> all, Collection<Integer> own) throws OXException {
        HashMap<Integer, EffectiveInfostoreFolderPermission> permissionsByFolderID = new HashMap<Integer, EffectiveInfostoreFolderPermission>();
        SearchIterator<FolderObject> searchIterator = null;
        try {
            searchIterator = OXFolderIteratorSQL.getVisibleSubfoldersIterator(rootFolderID, user.getId(), user.getGroups(), context, userPermissions, null, connection);
            while (searchIterator.hasNext()) {
                FolderObject folder = (FolderObject)searchIterator.next();
                if (ignoreTrash && 16 == folder.getType()) continue;
                EffectivePermission permission = folder.getEffectiveUserPermission(user.getId(), userPermissions);
                EffectiveInfostoreFolderPermission infostorePermission = new EffectiveInfostoreFolderPermission(permission, folder.getCreatedBy());
                Tools.trackEffectivePermission(infostorePermission, permissionsByFolderID, all, own);
                permissionsByFolderID.putAll(Tools.gatherVisibleFolders(security, connection, context, user, userPermissions, folder.getObjectID(), ignoreTrash, all, own));
            }
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            SearchIterators.close(searchIterator);
        }
        return permissionsByFolderID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DocumentMetadata> removeNonPrivate(SearchIterator<DocumentMetadata> searchIterator, ServerSession session, DBProvider dbProvider) throws OXException {
        Connection connection = null;
        try {
            connection = dbProvider.getReadConnection(session.getContext());
            List<DocumentMetadata> list = Tools.removeNonPrivate(searchIterator, session, connection);
            return list;
        }
        finally {
            if (null != connection) {
                dbProvider.releaseReadConnection(session.getContext(), connection);
            }
        }
    }

    public static List<DocumentMetadata> removeNonPrivate(SearchIterator<DocumentMetadata> searchIterator, ServerSession session, Connection connection) throws OXException {
        ArrayList<DocumentMetadata> documents = new ArrayList<DocumentMetadata>();
        HashMap<Integer, Boolean> knownFolders = new HashMap<Integer, Boolean>();
        OXFolderAccess folderAccess = new OXFolderAccess(connection, session.getContext());
        int defaultFolderID = folderAccess.getDefaultFolderID(session.getUserId(), 8);
        knownFolders.put(Autoboxing.I((int)defaultFolderID), Boolean.TRUE);
        while (searchIterator.hasNext()) {
            DocumentMetadata document = (DocumentMetadata)searchIterator.next();
            Integer folderID = Autoboxing.I((int)((int)document.getFolderId()));
            ArrayList<Integer> seenFolders = new ArrayList<Integer>();
            while (!knownFolders.containsKey(folderID) && 20 < folderID) {
                seenFolders.add(folderID);
                folderID = Autoboxing.I((int)folderAccess.getParentFolderID(folderID));
            }
            Boolean isPrivate = (Boolean)knownFolders.get(folderID);
            if (null == isPrivate) {
                isPrivate = Boolean.FALSE;
            } else if (isPrivate.booleanValue()) {
                documents.add(document);
            }
            for (Integer seenFolder : seenFolders) {
                knownFolders.put(seenFolder, isPrivate);
            }
        }
        return documents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, EffectiveInfostoreFolderPermission> gatherVisibleFolders(ServerSession session, InfostoreSecurity security, DBProvider dbProvider, int[] requestedFolderIDs, Collection<Integer> all, Collection<Integer> own) throws OXException {
        Connection connection = null;
        try {
            connection = dbProvider.getReadConnection(session.getContext());
            Map<Integer, EffectiveInfostoreFolderPermission> map = Tools.gatherVisibleFolders(security, connection, session.getContext(), session.getUser(), session.getUserPermissionBits(), requestedFolderIDs, all, own);
            return map;
        }
        finally {
            if (null != connection) {
                dbProvider.releaseReadConnection(session.getContext(), connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, EffectiveInfostoreFolderPermission> gatherVisibleFolders(ServerSession session, InfostoreSecurity security, DBProvider dbProvider, int rootFolderID, Collection<Integer> all, Collection<Integer> own) throws OXException {
        HashMap<Integer, EffectiveInfostoreFolderPermission> permissionsByFolderID = new HashMap<Integer, EffectiveInfostoreFolderPermission>();
        Connection connection = null;
        try {
            connection = dbProvider.getReadConnection(session.getContext());
            FolderObject rootFolder = new OXFolderAccess(connection, session.getContext()).getFolderObject(rootFolderID);
            EffectivePermission permission = rootFolder.getEffectiveUserPermission(session.getUserId(), session.getUserPermissionBits());
            EffectiveInfostoreFolderPermission infostorePermission = new EffectiveInfostoreFolderPermission(permission, rootFolder.getCreatedBy());
            Tools.trackEffectivePermission(infostorePermission, permissionsByFolderID, all, own);
            boolean ignoreTrash = 16 != rootFolder.getType();
            permissionsByFolderID.putAll(Tools.gatherVisibleFolders(security, connection, session.getContext(), session.getUser(), session.getUserPermissionBits(), rootFolderID, ignoreTrash, all, own));
            HashMap<Integer, EffectiveInfostoreFolderPermission> hashMap = permissionsByFolderID;
            return hashMap;
        }
        finally {
            if (null != connection) {
                dbProvider.releaseReadConnection(session.getContext(), connection);
            }
        }
    }

    public static Metadata[] getFieldsToQuery(Metadata[] requestedFields, Metadata ... requiredFields) {
        if (null == requestedFields) {
            return Metadata.VALUES_ARRAY;
        }
        if (null == requiredFields || 0 == requiredFields.length) {
            return requestedFields;
        }
        HashSet<Metadata> fields = new HashSet<Metadata>(Arrays.asList(requestedFields));
        fields.addAll(Arrays.asList(requiredFields));
        return fields.toArray(new Metadata[fields.size()]);
    }

    private static void trackEffectivePermission(EffectiveInfostoreFolderPermission infostorePermission, Map<Integer, EffectiveInfostoreFolderPermission> permissionsByFolderID, Collection<Integer> all, Collection<Integer> own) throws OXException {
        Integer id = Autoboxing.I((int)infostorePermission.getFuid());
        if (infostorePermission.canReadAllObjects()) {
            all.add(id);
        } else if (infostorePermission.canReadOwnObjects()) {
            own.add(id);
        }
        permissionsByFolderID.put(id, infostorePermission);
    }

    private Tools() {
    }
}

