/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.container;

import com.openexchange.groupware.container.ChangeExceptionsDiffer;
import com.openexchange.groupware.container.CommonObject;
import com.openexchange.groupware.container.ConfirmationsDiffer;
import com.openexchange.groupware.container.DeleteExceptionsDiffer;
import com.openexchange.groupware.container.Differ;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.ParticipantsDiffer;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.container.UsersDiffer;
import com.openexchange.groupware.container.participants.ConfirmableParticipant;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class CalendarObject
extends CommonObject {
    private static final long serialVersionUID = 8108851156436746900L;
    public static final int TITLE = 200;
    public static final int START_DATE = 201;
    public static final int END_DATE = 202;
    public static final int NOTE = 203;
    public static final int ALARM = 204;
    public static final int RECURRENCE_ID = 206;
    public static final int RECURRENCE_POSITION = 207;
    public static final int RECURRENCE_DATE_POSITION = 208;
    public static final int RECURRENCE_TYPE = 209;
    public static final int CHANGE_EXCEPTIONS = 210;
    public static final int DELETE_EXCEPTIONS = 211;
    public static final int DAYS = 212;
    public static final int DAY_IN_MONTH = 213;
    public static final int MONTH = 214;
    public static final int INTERVAL = 215;
    public static final int UNTIL = 216;
    public static final int NOTIFICATION = 217;
    public static final int RECURRENCE_CALCULATOR = 218;
    public static final int PARTICIPANTS = 220;
    public static final int USERS = 221;
    public static final int RECURRENCE_COUNT = 222;
    public static final int ORGANIZER = 224;
    public static final int SEQUENCE = 225;
    public static final int CONFIRMATIONS = 226;
    public static final int ORGANIZER_ID = 227;
    public static final int PRINCIPAL = 228;
    public static final int PRINCIPAL_ID = 229;
    public static final int FULL_TIME = 401;
    public static final int NONE = 0;
    public static final int ACCEPT = 1;
    public static final int DECLINE = 2;
    public static final int TENTATIVE = 3;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 4;
    public static final int WEDNESDAY = 8;
    public static final int THURSDAY = 16;
    public static final int FRIDAY = 32;
    public static final int SATURDAY = 64;
    public static final int DAY = 127;
    public static final int WEEKDAY = 62;
    public static final int WEEKENDDAY = 65;
    public static final int NO_RECURRENCE = 0;
    public static final int DAILY = 1;
    public static final int WEEKLY = 2;
    public static final int MONTHLY = 3;
    public static final int YEARLY = 4;
    protected Participant[] participants;
    protected UserParticipant[] users;
    protected ConfirmableParticipant[] confirmations;
    protected String title;
    protected Date start_date;
    protected Date end_date;
    protected String note;
    protected int recurrence_id;
    protected int recurrence_position;
    protected Date recurrence_date_position;
    protected int recurrence_type = 0;
    protected Date[] change_exceptions;
    protected Date[] delete_exceptions;
    protected int days;
    protected int day_in_month;
    protected int month;
    protected int interval;
    protected Date until;
    protected boolean notification;
    protected int recurrence_calculator;
    protected boolean alarmFlag;
    protected int occurrence;
    protected int recurrence_count;
    protected int confirm;
    protected String confirmMessage;
    protected String organizer;
    protected int sequence;
    protected int organizerId;
    protected String principal;
    protected int principalId;
    protected String attachmentLink;
    protected boolean fulltime;
    protected boolean b_title;
    protected boolean b_start_date;
    protected boolean b_end_date;
    protected boolean b_note;
    protected boolean b_recurrence_id;
    protected boolean b_recurrence_position;
    protected boolean b_recurrence_date_position;
    protected boolean b_recurrence_count;
    protected boolean b_change_exceptions;
    protected boolean b_delete_exceptions;
    protected boolean b_days;
    protected boolean b_day_in_month;
    protected boolean b_month;
    protected boolean b_interval;
    protected boolean b_recurrence_type;
    protected boolean b_until;
    protected boolean b_notification;
    protected boolean b_participants;
    protected boolean b_users;
    protected boolean bConfirmations;
    protected boolean b_confirm;
    protected boolean b_confirmMessage;
    protected boolean b_occurrence;
    protected boolean b_organizer;
    protected boolean b_sequence;
    protected boolean b_organizerId;
    protected boolean b_principal;
    protected boolean b_principalId;
    protected boolean b_fulltime;
    protected boolean bAttachmentLink;
    public static Set<Differ<? super CalendarObject>> differ = new HashSet<Differ<? super CalendarObject>>();

    public String getTitle() {
        return this.title;
    }

    public Date getStartDate() {
        return this.start_date;
    }

    public Date getEndDate() {
        return this.end_date;
    }

    public String getNote() {
        return this.note;
    }

    public int getRecurrenceID() {
        return this.recurrence_id;
    }

    public int getRecurrencePosition() {
        return this.recurrence_position;
    }

    public Date getRecurrenceDatePosition() {
        return this.recurrence_date_position;
    }

    public int getRecurrenceType() {
        return this.recurrence_type;
    }

    public Date[] getChangeException() {
        return this.change_exceptions;
    }

    public Date[] getDeleteException() {
        return this.delete_exceptions;
    }

    public int getDays() {
        return this.days;
    }

    public int getDayInMonth() {
        return this.day_in_month;
    }

    public int getMonth() {
        return this.month;
    }

    public int getInterval() {
        return this.interval;
    }

    public Date getUntil() {
        return this.until;
    }

    public boolean getNotification() {
        return this.notification;
    }

    public int getRecurrenceCalculator() {
        return this.recurrence_calculator;
    }

    public void setRecurrenceCalculator(int recurrence_calculator) {
        this.recurrence_calculator = recurrence_calculator;
    }

    public int getConfirm() {
        return this.confirm;
    }

    public String getConfirmMessage() {
        return this.confirmMessage;
    }

    public boolean getAlarmFlag() {
        return this.alarmFlag;
    }

    public int getOccurrence() {
        return this.occurrence;
    }

    public String getOrganizer() {
        return this.organizer;
    }

    public int getSequence() {
        return this.sequence;
    }

    public int getOrganizerId() {
        return this.organizerId;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public int getPrincipalId() {
        return this.principalId;
    }

    public boolean getFullTime() {
        return this.fulltime;
    }

    public void setTitle(String title) {
        this.title = title;
        this.b_title = true;
    }

    public void setStartDate(Date start_date) {
        this.start_date = start_date;
        this.b_start_date = true;
    }

    public void setEndDate(Date end_date) {
        this.end_date = end_date;
        this.b_end_date = true;
    }

    public void setNote(String note) {
        this.note = note;
        this.b_note = true;
    }

    public void setRecurrenceID(int recurrence_id) {
        this.recurrence_id = recurrence_id;
        this.b_recurrence_id = true;
    }

    public void setRecurrencePosition(int recurrence_position) {
        this.recurrence_position = recurrence_position;
        this.b_recurrence_position = true;
    }

    public void setRecurrenceDatePosition(Date recurrence_date_position) {
        this.recurrence_date_position = recurrence_date_position;
        this.b_recurrence_date_position = true;
    }

    public void setRecurrenceType(int recurrence_type) {
        this.recurrence_type = recurrence_type;
        this.b_recurrence_type = true;
    }

    public void setChangeExceptions(Date[] change_exceptions) {
        this.change_exceptions = change_exceptions;
        this.b_change_exceptions = true;
    }

    public void setChangeExceptions(List<? extends Date> change_exceptions) {
        this.change_exceptions = change_exceptions.toArray(new Date[change_exceptions.size()]);
        this.b_change_exceptions = true;
    }

    public void addChangeException(Date change_exception) {
        if (this.change_exceptions == null) {
            this.setChangeExceptions(new Date[]{change_exception});
        } else {
            Date[] tmp = this.change_exceptions;
            this.change_exceptions = new Date[tmp.length + 1];
            System.arraycopy(tmp, 0, this.change_exceptions, 0, tmp.length);
            this.change_exceptions[this.change_exceptions.length - 1] = change_exception;
        }
    }

    public void setDeleteExceptions(Date[] delete_exceptions) {
        this.delete_exceptions = delete_exceptions;
        this.b_delete_exceptions = true;
    }

    public void setDeleteExceptions(List<? extends Date> delete_exceptions) {
        this.delete_exceptions = delete_exceptions.toArray(new Date[delete_exceptions.size()]);
        this.b_delete_exceptions = true;
    }

    public void addDeleteException(Date delete_exception) {
        if (this.delete_exceptions == null) {
            this.setDeleteExceptions(new Date[]{delete_exception});
        } else {
            Date[] tmp = this.delete_exceptions;
            this.delete_exceptions = new Date[tmp.length + 1];
            System.arraycopy(tmp, 0, this.delete_exceptions, 0, tmp.length);
            this.delete_exceptions[this.delete_exceptions.length - 1] = delete_exception;
        }
    }

    public void setDays(int days) {
        this.days = days;
        this.b_days = true;
    }

    public void setDayInMonth(int day_in_month) {
        this.day_in_month = day_in_month;
        this.b_day_in_month = true;
    }

    public void setMonth(int month) {
        this.month = month;
        this.b_month = true;
    }

    public void setInterval(int interval) {
        this.interval = interval;
        this.b_interval = true;
    }

    public void setUntil(Date until) {
        this.until = until;
        this.b_until = true;
    }

    public void setNotification(boolean notification) {
        this.notification = notification;
        this.b_notification = true;
    }

    public void setConfirm(int confirm) {
        this.confirm = confirm;
        this.b_confirm = true;
    }

    public void setConfirmMessage(String confirmMessage) {
        this.confirmMessage = confirmMessage;
        this.b_confirmMessage = true;
    }

    public void setAlarmFlag(boolean alarmFlag) {
        this.alarmFlag = alarmFlag;
    }

    public void setOccurrence(int occurrence) {
        this.occurrence = occurrence;
        this.b_occurrence = true;
    }

    public void setOrganizer(String organizer) {
        this.organizer = organizer;
        this.b_organizer = true;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
        this.b_sequence = true;
    }

    public void setOrganizerId(int organizerId) {
        this.organizerId = organizerId;
        this.b_organizerId = true;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
        this.b_principal = true;
    }

    public void setPrincipalId(int principalId) {
        this.principalId = principalId;
        this.b_principalId = true;
    }

    public void setFullTime(boolean fulltime) {
        this.fulltime = fulltime;
        this.b_fulltime = true;
    }

    public void removeTitle() {
        this.title = null;
        this.b_title = false;
    }

    public void removeStartDate() {
        this.start_date = null;
        this.b_start_date = false;
    }

    public void removeEndDate() {
        this.end_date = null;
        this.b_end_date = false;
    }

    public void removeNote() {
        this.note = null;
        this.b_note = false;
    }

    public void removeRecurrenceID() {
        this.recurrence_id = 0;
        this.b_recurrence_id = false;
    }

    public void removeRecurrencePosition() {
        this.recurrence_position = 0;
        this.b_recurrence_position = false;
    }

    public void removeRecurrenceDatePosition() {
        this.recurrence_date_position = null;
        this.b_recurrence_date_position = false;
    }

    public void removeRecurrenceType() {
        this.recurrence_type = 0;
        this.b_recurrence_type = false;
    }

    public void removeChangeExceptions() {
        this.change_exceptions = null;
        this.b_change_exceptions = false;
    }

    public void removeDeleteExceptions() {
        this.delete_exceptions = null;
        this.b_delete_exceptions = false;
    }

    public void removeDays() {
        this.days = 0;
        this.b_days = false;
    }

    public void removeDayInMonth() {
        this.day_in_month = 0;
        this.b_day_in_month = false;
    }

    public void removeMonth() {
        this.month = 0;
        this.b_month = false;
    }

    public void removeInterval() {
        this.interval = 0;
        this.b_interval = false;
    }

    public void removeUntil() {
        this.until = null;
        this.b_until = false;
    }

    public void removeNotification() {
        this.notification = false;
        this.b_notification = false;
    }

    public void removeConfirm() {
        this.confirm = 0;
        this.b_confirm = false;
    }

    public void removeConfirmMessage() {
        this.confirmMessage = null;
        this.b_confirmMessage = false;
    }

    public void removeOccurrence() {
        this.occurrence = 0;
        this.b_occurrence = false;
    }

    public void removeOrganizer() {
        this.organizer = null;
        this.b_organizer = false;
    }

    public void removeSequence() {
        this.sequence = 0;
        this.b_sequence = false;
    }

    public void removeOrganizerId() {
        this.organizerId = 0;
        this.b_organizerId = false;
    }

    public void removePrincipal() {
        this.principal = null;
        this.b_principal = false;
    }

    public void removePrincipalId() {
        this.principalId = 0;
        this.b_principalId = false;
    }

    public void removeFullTime() {
        this.fulltime = false;
        this.b_fulltime = false;
    }

    public boolean containsTitle() {
        return this.b_title;
    }

    public boolean containsStartDate() {
        return this.b_start_date;
    }

    public boolean containsStartDateAndIsNotNull() {
        return this.b_start_date && null != this.start_date;
    }

    public boolean containsEndDate() {
        return this.b_end_date;
    }

    public boolean containsEndDateAndIsNotNull() {
        return this.b_end_date && null != this.end_date;
    }

    public boolean containsNote() {
        return this.b_note;
    }

    public boolean containsRecurrenceID() {
        return this.b_recurrence_id;
    }

    public boolean containsRecurrencePosition() {
        return this.b_recurrence_position;
    }

    public boolean containsRecurrenceDatePosition() {
        return this.b_recurrence_date_position;
    }

    public boolean containsRecurrenceType() {
        return this.b_recurrence_type;
    }

    public boolean containsChangeExceptions() {
        return this.b_change_exceptions;
    }

    public boolean containsDeleteExceptions() {
        return this.b_delete_exceptions;
    }

    public boolean containsDays() {
        return this.b_days;
    }

    public boolean containsDayInMonth() {
        return this.b_day_in_month;
    }

    public boolean containsMonth() {
        return this.b_month;
    }

    public boolean containsInterval() {
        return this.b_interval;
    }

    public boolean containsUntil() {
        return this.b_until;
    }

    public boolean containsNotification() {
        return this.b_notification;
    }

    public boolean containsConfirm() {
        return this.b_confirm;
    }

    public boolean containsConfirmMessage() {
        return this.b_confirmMessage;
    }

    public boolean containsOccurrence() {
        return this.b_occurrence;
    }

    public void setParticipants(Participant[] participants) {
        this.participants = participants;
        this.b_participants = true;
    }

    public boolean containsOrganizer() {
        return this.b_organizer;
    }

    public boolean containsSequence() {
        return this.b_sequence;
    }

    public boolean containsOrganizerId() {
        return this.b_organizerId;
    }

    public boolean containsPrincipal() {
        return this.b_principal;
    }

    public boolean containsPrincipalId() {
        return this.b_principalId;
    }

    public boolean containsFullTime() {
        return this.b_fulltime;
    }

    public void setParticipants(List<? extends Participant> participants) {
        this.participants = participants.toArray(new Participant[participants.size()]);
        this.b_participants = true;
    }

    public Participant[] getParticipants() {
        return this.participants;
    }

    public void removeParticipants() {
        this.participants = null;
        this.b_participants = false;
    }

    public boolean containsParticipants() {
        return this.b_participants;
    }

    public void addParticipant(Participant p) {
        if (this.participants == null) {
            this.setParticipants(new Participant[]{p});
        } else {
            int newLength = this.participants.length + 1;
            Participant[] tmp = this.participants;
            this.participants = new Participant[newLength];
            System.arraycopy(tmp, 0, this.participants, 0, tmp.length);
            this.participants[newLength - 1] = p;
        }
    }

    public void setUsers(UserParticipant[] users) {
        this.users = users;
        this.b_users = true;
    }

    public void setUsers(List<UserParticipant> users) {
        this.users = users.toArray(new UserParticipant[users.size()]);
        this.b_users = true;
    }

    public UserParticipant[] getUsers() {
        return this.users;
    }

    public void removeUsers() {
        this.users = null;
        this.b_users = false;
    }

    public boolean containsUserParticipants() {
        return this.b_users;
    }

    public ConfirmableParticipant[] getConfirmations() {
        return this.confirmations;
    }

    public void setConfirmations(ConfirmableParticipant[] confirmations) {
        this.confirmations = confirmations;
        this.bConfirmations = true;
    }

    public void removeConfirmations() {
        this.confirmations = null;
        this.bConfirmations = false;
    }

    public void setConfirmations(List<ConfirmableParticipant> value) {
        this.setConfirmations(value.toArray(new ConfirmableParticipant[value.size()]));
    }

    public void removeConfigurations() {
        this.confirmations = null;
        this.bConfirmations = false;
    }

    public boolean containsConfirmations() {
        return this.bConfirmations;
    }

    public String getAttachmentLink() {
        return this.attachmentLink;
    }

    public void setAttachmentLink(String attachmentLink) {
        this.attachmentLink = attachmentLink;
        this.bAttachmentLink = true;
    }

    public void removeAttachmentLink() {
        this.attachmentLink = null;
        this.bAttachmentLink = false;
    }

    public boolean containsAttachmentLink() {
        return this.bAttachmentLink;
    }

    @Override
    public void reset() {
        super.reset();
        this.title = null;
        this.start_date = null;
        this.end_date = null;
        this.recurrence_id = 0;
        this.recurrence_position = 0;
        this.recurrence_date_position = null;
        this.change_exceptions = null;
        this.delete_exceptions = null;
        this.days = 0;
        this.day_in_month = 0;
        this.month = 0;
        this.until = null;
        this.recurrence_count = 0;
        this.notification = false;
        this.participants = null;
        this.users = null;
        this.confirmations = null;
        this.occurrence = 0;
        this.organizer = null;
        this.sequence = 0;
        this.organizerId = 0;
        this.principal = null;
        this.principalId = 0;
        this.fulltime = false;
        this.b_title = false;
        this.b_start_date = false;
        this.b_end_date = false;
        this.b_recurrence_id = false;
        this.b_recurrence_position = false;
        this.b_recurrence_date_position = false;
        this.b_change_exceptions = false;
        this.b_delete_exceptions = false;
        this.b_days = false;
        this.b_day_in_month = false;
        this.b_month = false;
        this.b_until = false;
        this.b_recurrence_count = false;
        this.b_notification = false;
        this.b_participants = false;
        this.b_users = false;
        this.b_occurrence = false;
        this.b_organizer = false;
        this.b_sequence = false;
        this.b_organizerId = false;
        this.b_principal = false;
        this.b_principalId = false;
        this.b_fulltime = false;
    }

    public int getRecurrenceCount() {
        return this.recurrence_count;
    }

    public void setRecurrenceCount(int recurrenceCount) {
        this.recurrence_count = recurrenceCount;
        this.b_recurrence_count = true;
    }

    public void removeRecurrenceCount() {
        this.recurrence_count = 0;
        this.b_recurrence_count = false;
    }

    public boolean containsRecurrenceCount() {
        return this.b_recurrence_count;
    }

    public boolean isPartOfSeries() {
        return this.getRecurrenceID() != 0;
    }

    public boolean isSpecificOcurrence() {
        return this.isException();
    }

    public boolean isException() {
        return this.isPartOfSeries() && (this.getRecurrencePosition() != 0 || this.getRecurrenceDatePosition() != null);
    }

    public boolean isMaster() {
        return this.getRecurrenceID() == this.getObjectID() && !this.isSpecificOcurrence();
    }

    public boolean isSingle() {
        return !this.isPartOfSeries();
    }

    @Override
    public void set(int field, Object value) {
        switch (field) {
            case 216: {
                this.setUntil((Date)value);
                break;
            }
            case 221: {
                if (List.class.isInstance(value)) {
                    this.setUsers((List)value);
                    break;
                }
                this.setUsers((UserParticipant[])value);
                break;
            }
            case 203: {
                this.setNote((String)value);
                break;
            }
            case 208: {
                this.setRecurrenceDatePosition((Date)value);
                break;
            }
            case 202: {
                this.setEndDate((Date)value);
                break;
            }
            case 207: {
                this.setRecurrencePosition((Integer)value);
                break;
            }
            case 218: {
                this.setRecurrenceCalculator((Integer)value);
                break;
            }
            case 212: {
                this.setDays((Integer)value);
                break;
            }
            case 217: {
                this.setNotification((Boolean)value);
                break;
            }
            case 214: {
                this.setMonth((Integer)value);
                break;
            }
            case 222: {
                this.setRecurrenceCount((Integer)value);
                this.setOccurrence(this.getRecurrenceCount());
                break;
            }
            case 213: {
                this.setDayInMonth((Integer)value);
                break;
            }
            case 209: {
                this.setRecurrenceType((Integer)value);
                break;
            }
            case 201: {
                this.setStartDate((Date)value);
                break;
            }
            case 215: {
                this.setInterval((Integer)value);
                break;
            }
            case 200: {
                this.setTitle((String)value);
                break;
            }
            case 206: {
                this.setRecurrenceID((Integer)value);
                break;
            }
            case 220: {
                if (List.class.isInstance(value)) {
                    this.setParticipants((List)value);
                    break;
                }
                this.setParticipants((Participant[])value);
                break;
            }
            case 226: {
                if (List.class.isInstance(value)) {
                    this.setConfirmations((List)value);
                    break;
                }
                this.setConfirmations((ConfirmableParticipant[])value);
                break;
            }
            case 210: {
                if (List.class.isInstance(value)) {
                    this.setChangeExceptions((List)value);
                    break;
                }
                this.setChangeExceptions((Date[])value);
                break;
            }
            case 211: {
                if (List.class.isInstance(value)) {
                    this.setDeleteExceptions((List)value);
                    break;
                }
                this.setDeleteExceptions((Date[])value);
                break;
            }
            case 224: {
                this.setOrganizer((String)value);
                break;
            }
            case 225: {
                this.setSequence((Integer)value);
                break;
            }
            case 227: {
                this.setOrganizerId((Integer)value);
                break;
            }
            case 228: {
                this.setPrincipal((String)value);
                break;
            }
            case 229: {
                this.setPrincipalId((Integer)value);
                break;
            }
            case 401: {
                this.setFullTime((Boolean)value);
                break;
            }
            default: {
                super.set(field, value);
            }
        }
    }

    @Override
    public Object get(int field) {
        switch (field) {
            case 216: {
                return this.getUntil();
            }
            case 221: {
                return this.getUsers();
            }
            case 203: {
                return this.getNote();
            }
            case 208: {
                return this.getRecurrenceDatePosition();
            }
            case 202: {
                return this.getEndDate();
            }
            case 207: {
                return this.getRecurrencePosition();
            }
            case 218: {
                return this.getRecurrenceCalculator();
            }
            case 212: {
                return this.getDays();
            }
            case 217: {
                return this.getNotification();
            }
            case 214: {
                return this.getMonth();
            }
            case 222: {
                if (this.containsRecurrenceCount()) {
                    return this.getRecurrenceCount();
                }
                return this.getOccurrence();
            }
            case 213: {
                return this.getDayInMonth();
            }
            case 209: {
                return this.getRecurrenceType();
            }
            case 201: {
                return this.getStartDate();
            }
            case 215: {
                return this.getInterval();
            }
            case 200: {
                return this.getTitle();
            }
            case 206: {
                return this.getRecurrenceID();
            }
            case 220: {
                return this.getParticipants();
            }
            case 210: {
                return this.getChangeException();
            }
            case 211: {
                return this.getDeleteException();
            }
            case 224: {
                return this.getOrganizer();
            }
            case 225: {
                return this.getSequence();
            }
            case 226: {
                return this.getConfirmations();
            }
            case 227: {
                return this.getOrganizerId();
            }
            case 228: {
                return this.getPrincipal();
            }
            case 229: {
                return this.getPrincipalId();
            }
            case 401: {
                return this.getFullTime();
            }
        }
        return super.get(field);
    }

    @Override
    public boolean contains(int field) {
        switch (field) {
            case 216: {
                return this.containsUntil();
            }
            case 221: {
                return this.containsUserParticipants();
            }
            case 203: {
                return this.containsNote();
            }
            case 208: {
                return this.containsRecurrenceDatePosition();
            }
            case 202: {
                return this.containsEndDate();
            }
            case 207: {
                return this.containsRecurrencePosition();
            }
            case 212: {
                return this.containsDays();
            }
            case 217: {
                return this.containsNotification();
            }
            case 214: {
                return this.containsMonth();
            }
            case 222: {
                return this.containsRecurrenceCount() || this.containsOccurrence();
            }
            case 213: {
                return this.containsDayInMonth();
            }
            case 209: {
                return this.containsRecurrenceType();
            }
            case 201: {
                return this.containsStartDate();
            }
            case 215: {
                return this.containsInterval();
            }
            case 200: {
                return this.containsTitle();
            }
            case 206: {
                return this.containsRecurrenceID();
            }
            case 220: {
                return this.containsParticipants();
            }
            case 226: {
                return this.containsConfirmations();
            }
            case 210: {
                return this.containsChangeExceptions();
            }
            case 211: {
                return this.containsDeleteExceptions();
            }
            case 218: {
                return true;
            }
            case 224: {
                return this.containsOrganizer();
            }
            case 225: {
                return this.containsSequence();
            }
            case 227: {
                return this.containsOrganizerId();
            }
            case 228: {
                return this.containsPrincipal();
            }
            case 229: {
                return this.containsPrincipalId();
            }
            case 401: {
                return this.containsFullTime();
            }
        }
        return super.contains(field);
    }

    @Override
    public void remove(int field) {
        switch (field) {
            case 216: {
                this.removeUntil();
                break;
            }
            case 221: {
                this.removeUsers();
                break;
            }
            case 203: {
                this.removeNote();
                break;
            }
            case 208: {
                this.removeRecurrenceDatePosition();
                break;
            }
            case 202: {
                this.removeEndDate();
                break;
            }
            case 207: {
                this.removeRecurrencePosition();
                break;
            }
            case 212: {
                this.removeDays();
                break;
            }
            case 217: {
                this.removeNotification();
                break;
            }
            case 214: {
                this.removeMonth();
                break;
            }
            case 222: {
                this.removeRecurrenceCount();
                this.removeOccurrence();
                break;
            }
            case 213: {
                this.removeDayInMonth();
                break;
            }
            case 209: {
                this.removeRecurrenceType();
                break;
            }
            case 201: {
                this.removeStartDate();
                break;
            }
            case 215: {
                this.removeInterval();
                break;
            }
            case 200: {
                this.removeTitle();
                break;
            }
            case 206: {
                this.removeRecurrenceID();
                break;
            }
            case 220: {
                this.removeParticipants();
                break;
            }
            case 226: {
                this.removeConfirmations();
                break;
            }
            case 210: {
                this.removeChangeExceptions();
            }
            case 211: {
                this.removeDeleteExceptions();
            }
            case 218: {
                return;
            }
            case 224: {
                this.removeOrganizer();
                break;
            }
            case 225: {
                this.removeSequence();
                break;
            }
            case 227: {
                this.removeOrganizerId();
                break;
            }
            case 228: {
                this.removePrincipal();
                break;
            }
            case 229: {
                this.removePrincipalId();
                break;
            }
            case 401: {
                this.removeFullTime();
                break;
            }
            default: {
                super.remove(field);
            }
        }
    }

    public String toString() {
        return "[" + this.getObjectID() + "] " + this.getTitle();
    }

    public CalendarObject clone() {
        CalendarObject retval;
        try {
            int i;
            retval = (CalendarObject)super.clone();
            if (this.getParticipants() != null) {
                Participant[] clonedParticipants = new Participant[this.getParticipants().length];
                for (i = 0; i < this.getParticipants().length; ++i) {
                    clonedParticipants[i] = this.getParticipants()[i].getClone();
                }
                retval.setParticipants(clonedParticipants);
            }
            if (this.getConfirmations() != null) {
                ConfirmableParticipant[] clonedConfirmations = new ConfirmableParticipant[this.getConfirmations().length];
                for (i = 0; i < this.getConfirmations().length; ++i) {
                    clonedConfirmations[i] = this.getConfirmations()[i].getClone();
                }
                retval.setConfirmations(clonedConfirmations);
            }
            if (this.getUsers() != null) {
                UserParticipant[] clonedUsers = new UserParticipant[this.getUsers().length];
                for (i = 0; i < this.getUsers().length; ++i) {
                    clonedUsers[i] = this.getUsers()[i].getClone();
                }
                retval.setUsers(clonedUsers);
            }
            if (this.containsFullTime()) {
                retval.setFullTime(this.getFullTime());
            }
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
        return retval;
    }

    static {
        differ.add(new ChangeExceptionsDiffer());
        differ.add(new DeleteExceptionsDiffer());
        differ.add(new ParticipantsDiffer());
        differ.add(new UsersDiffer());
        differ.add(new ConfirmationsDiffer());
    }
}

