/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarListener;
import com.openexchange.groupware.calendar.OXCalendarExceptionCodes;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarCallbacks
implements CalendarListener {
    private final List<CalendarListener> listeners = new ArrayList<CalendarListener>();
    private List<CalendarListener> copyForReading = new ArrayList<CalendarListener>();
    private static final CalendarCallbacks INSTANCE = new CalendarCallbacks();
    private static final Logger LOG = LoggerFactory.getLogger(CalendarCallbacks.class);
    private boolean mustCopy;
    private final Lock lock = new ReentrantLock();

    public static CalendarCallbacks getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(CalendarListener listener) {
        try {
            this.lock.lock();
            this.mustCopy = true;
            this.listeners.add(listener);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(CalendarListener listener) {
        try {
            this.lock.lock();
            this.mustCopy = true;
            this.listeners.remove(listener);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CalendarListener> getListeners() {
        if (this.mustCopy) {
            try {
                this.lock.lock();
                this.copyForReading = new ArrayList<CalendarListener>(this.listeners);
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.copyForReading;
    }

    public void createdChangeExceptionInRecurringAppointment(Appointment master, Appointment changeException, int inFolder, Session session) throws OXException {
        ServerSession serverSession = this.getServerSession(session);
        this.createdChangeExceptionInRecurringAppointment(master, changeException, inFolder, serverSession);
    }

    private ServerSession getServerSession(Session session) throws OXException {
        if (ServerSession.class.isAssignableFrom(session.getClass())) {
            return (ServerSession)session;
        }
        return ServerSessionAdapter.valueOf(session);
    }

    @Override
    public void createdChangeExceptionInRecurringAppointment(Appointment master, Appointment changeException, int inFolder, ServerSession serverSession) throws OXException {
        ArrayList<String> exceptionIDs = new ArrayList<String>();
        for (CalendarListener listener : this.getListeners()) {
            try {
                listener.createdChangeExceptionInRecurringAppointment(master, changeException, inFolder, serverSession);
            }
            catch (OXException x) {
                LOG.error("", (Throwable)x);
                exceptionIDs.add(x.getExceptionId());
            }
        }
        if (!exceptionIDs.isEmpty()) {
            throw OXCalendarExceptionCodes.CALLBACK_EXCEPTIONS.create(((Object)exceptionIDs).toString());
        }
    }
}

