/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.osgi;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.Weighers;
import com.openexchange.ajax.customizer.AdditionalFieldsUtils;
import com.openexchange.ajax.customizer.folder.AdditionalFolderField;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.ContentTypeDiscoveryService;
import com.openexchange.folderstorage.FolderService;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.cache.osgi.CacheFolderStorageActivator;
import com.openexchange.folderstorage.database.osgi.DatabaseFolderStorageActivator;
import com.openexchange.folderstorage.filestorage.osgi.FileStorageFolderStorageActivator;
import com.openexchange.folderstorage.internal.ContentTypeRegistry;
import com.openexchange.folderstorage.internal.FolderServiceImpl;
import com.openexchange.folderstorage.mail.osgi.MailFolderStorageActivator;
import com.openexchange.folderstorage.messaging.osgi.MessagingFolderStorageActivator;
import com.openexchange.folderstorage.osgi.FolderStorageServices;
import com.openexchange.folderstorage.osgi.FolderStorageTracker;
import com.openexchange.folderstorage.outlook.osgi.OutlookFolderStorageActivator;
import com.openexchange.folderstorage.virtual.osgi.VirtualFolderStorageActivator;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.objectusecount.ObjectUseCountService;
import com.openexchange.osgi.Tools;
import com.openexchange.share.ShareService;
import com.openexchange.share.notification.ShareNotificationService;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.user.UserService;
import com.openexchange.userconf.UserPermissionService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.json.JSONObject;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FolderStorageActivator
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(FolderStorageActivator.class);
    private List<ServiceRegistration<?>> serviceRegistrations;
    private List<ServiceTracker<?, ?>> serviceTrackers;
    private List<BundleActivator> activators;
    private static final Class<?>[] TRACKED_SERVICES = new Class[]{ShareService.class, ShareNotificationService.class, UserService.class, DatabaseService.class, UserPermissionService.class, ObjectUseCountService.class};

    public void start(BundleContext context) throws Exception {
        try {
            this.serviceRegistrations = new ArrayList(4);
            this.serviceRegistrations.add(context.registerService(FolderService.class.getName(), (Object)new FolderServiceImpl(), null));
            this.serviceRegistrations.add(context.registerService(ContentTypeDiscoveryService.class.getName(), (Object)ContentTypeRegistry.getInstance(), null));
            this.serviceRegistrations.add(context.registerService(AdditionalFolderField.class.getName(), (Object)new DisplayNameFolderField(), null));
            this.serviceTrackers = new ArrayList(2);
            this.serviceTrackers.add(new ServiceTracker(context, FolderStorage.class.getName(), (ServiceTrackerCustomizer)new FolderStorageTracker(context)));
            FolderStorageServices services = FolderStorageServices.init(context, TRACKED_SERVICES);
            this.serviceTrackers.add(new ServiceTracker(context, Tools.generateServiceFilter((BundleContext)context, (Class[])TRACKED_SERVICES), (ServiceTrackerCustomizer)services));
            for (ServiceTracker<?, ?> serviceTracker : this.serviceTrackers) {
                serviceTracker.open();
            }
            this.activators = new ArrayList<BundleActivator>(8);
            this.activators.add((BundleActivator)new DatabaseFolderStorageActivator());
            this.activators.add((BundleActivator)new MailFolderStorageActivator());
            this.activators.add((BundleActivator)new MessagingFolderStorageActivator());
            this.activators.add((BundleActivator)new FileStorageFolderStorageActivator());
            this.activators.add((BundleActivator)new CacheFolderStorageActivator());
            this.activators.add((BundleActivator)new OutlookFolderStorageActivator());
            this.activators.add((BundleActivator)new VirtualFolderStorageActivator());
            BundleActivator activator = null;
            Iterator<BundleActivator> iter = this.activators.iterator();
            while (iter.hasNext()) {
                try {
                    if (FolderStorageActivator.isBundleResolved(context)) {
                        if (null != activator) {
                            FolderStorageActivator.logFailedStartup(activator);
                        }
                        return;
                    }
                }
                catch (IllegalStateException e) {
                    if (null != activator) {
                        FolderStorageActivator.logFailedStartup(activator);
                    }
                    return;
                }
                activator = iter.next();
                activator.start(context);
            }
            LOG.info("Bundle \"com.openexchange.folderstorage\" successfully started!");
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
    }

    private static boolean isBundleResolved(BundleContext context) {
        return 4 == context.getBundle().getState();
    }

    private static void logFailedStartup(BundleActivator activator) {
        StringBuilder sb = new StringBuilder(32);
        sb.append("Failed start of folder storage bundle \"");
        sb.append(activator.getClass().getName());
        sb.append("\"!");
        LOG.error(sb.toString(), new Throwable());
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (null != this.activators) {
                for (BundleActivator bundleActivator : this.activators) {
                    bundleActivator.stop(context);
                }
                this.activators.clear();
                this.activators = null;
            }
            if (null != this.serviceTrackers) {
                for (ServiceTracker serviceTracker : this.serviceTrackers) {
                    serviceTracker.close();
                }
                this.serviceTrackers.clear();
                this.serviceTrackers = null;
            }
            if (null != this.serviceRegistrations) {
                for (ServiceRegistration serviceRegistration : this.serviceRegistrations) {
                    serviceRegistration.unregister();
                }
                this.serviceRegistrations.clear();
                this.serviceRegistrations = null;
            }
            LOG.info("Bundle \"com.openexchange.folderstorage\" successfully stopped!");
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
    }

    private static final class DisplayNameFolderField
    implements AdditionalFolderField {
        private final ConcurrentMap<Key, String> cache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(1024L).weigher(Weighers.entrySingleton()).build();

        protected DisplayNameFolderField() {
        }

        @Override
        public Object renderJSON(AJAXRequestData requestData, Object value) {
            return value == null ? JSONObject.NULL : value;
        }

        @Override
        public Object getValue(FolderObject folder, ServerSession session) {
            int createdBy = folder.getCreatedBy();
            if (createdBy <= 0) {
                return JSONObject.NULL;
            }
            Context context = session.getContext();
            String displayName = (String)this.cache.get(Key.valueOf(createdBy, context.getContextId()));
            try {
                return null == displayName ? UserStorage.getInstance().getUser(createdBy, context).getDisplayName() : displayName;
            }
            catch (OXException e) {
                return null;
            }
        }

        @Override
        public String getColumnName() {
            return "com.openexchange.folderstorage.displayName";
        }

        @Override
        public int getColumnID() {
            return 3030;
        }

        @Override
        public List<Object> getValues(List<FolderObject> folder, ServerSession session) {
            return AdditionalFieldsUtils.bulk(this, folder, session);
        }
    }

    private static final class Key {
        private final int userId;
        private final int cid;
        private final int hash;

        public static Key valueOf(int userId, int cid) {
            return new Key(userId, cid);
        }

        public Key(int userId, int cid) {
            this.userId = userId;
            this.cid = cid;
            int prime = 31;
            int result = 1;
            result = 31 * result + cid;
            this.hash = result = 31 * result + userId;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            if (this.cid != other.cid) {
                return false;
            }
            return this.userId == other.userId;
        }
    }
}

