/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal.performers;

import com.openexchange.concurrent.CallerRunsCompletionService;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderServiceDecorator;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageDiscoverer;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.SortableId;
import com.openexchange.folderstorage.StorageParameters;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.UserizedFolder;
import com.openexchange.folderstorage.internal.CalculatePermission;
import com.openexchange.folderstorage.internal.performers.AbstractUserizedFolderPerformer;
import com.openexchange.folderstorage.internal.performers.InstanceStorageParametersProvider;
import com.openexchange.folderstorage.internal.performers.SessionStorageParametersProvider;
import com.openexchange.folderstorage.internal.performers.StorageParametersProvider;
import com.openexchange.folderstorage.type.SharedType;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.threadpool.ThreadPoolCompletionService;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.tools.session.ServerSession;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VisibleFoldersPerformer
extends AbstractUserizedFolderPerformer {
    private static final Logger LOG = LoggerFactory.getLogger(VisibleFoldersPerformer.class);

    public VisibleFoldersPerformer(ServerSession session, FolderServiceDecorator decorator) throws OXException {
        super(session, decorator);
    }

    public VisibleFoldersPerformer(User user, Context context, FolderServiceDecorator decorator) {
        super(user, context, decorator);
    }

    public VisibleFoldersPerformer(ServerSession session, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) throws OXException {
        super(session, decorator, folderStorageDiscoverer);
    }

    public VisibleFoldersPerformer(User user, Context context, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) {
        super(user, context, decorator, folderStorageDiscoverer);
    }

    public List<UserizedFolder[]> doVisibleFolders(String treeId, ContentType contentType, boolean all, Type type, Type ... otherTypes) throws OXException {
        if (null == otherTypes || 0 == otherTypes.length) {
            return Collections.singletonList(this.doVisibleFolders(treeId, contentType, type, all));
        }
        ArrayList<UserizedFolder[]> list = new ArrayList<UserizedFolder[]>(otherTypes.length + 1);
        list.add(this.doVisibleFolders(treeId, contentType, type, all));
        for (Type otherType : otherTypes) {
            list.add(this.doVisibleFolders(treeId, contentType, otherType, all));
        }
        return list;
    }

    public UserizedFolder[] doVisibleFolders(final String treeId, ContentType contentType, Type type, final boolean all) throws OXException {
        FolderStorage folderStorage = this.folderStorageDiscoverer.getFolderStorageByContentType(treeId, contentType);
        if (null == folderStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_CT.create(treeId, contentType);
        }
        boolean started = folderStorage.startTransaction(this.storageParameters, false);
        try {
            StorageParametersProvider paramsProvider;
            ThreadPoolCompletionService completionService;
            List<SortableId> allSubfolderIds;
            try {
                allSubfolderIds = Arrays.asList(folderStorage.getVisibleFolders(treeId, contentType, type, this.storageParameters));
            }
            catch (UnsupportedOperationException e) {
                LOG.warn("Operation is not supported for folder storage {} (content-type={})", new Object[]{folderStorage.getClass().getSimpleName(), contentType, e});
                return new UserizedFolder[0];
            }
            Collections.sort(allSubfolderIds);
            int size = allSubfolderIds.size();
            final UserizedFolder[] subfolders = new UserizedFolder[size];
            HashMap<FolderStorage, TIntList> map = new HashMap<FolderStorage, TIntList>(4);
            for (int i = 0; i < size; ++i) {
                String id = allSubfolderIds.get(i).getId();
                FolderStorage tmp = this.folderStorageDiscoverer.getFolderStorage(treeId, id);
                if (null == tmp) {
                    throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, id);
                }
                TIntList list = (TIntList)map.get(tmp);
                if (null == list) {
                    list = new TIntArrayList();
                    map.put(tmp, list);
                }
                list.add(i);
            }
            if (1 == map.size()) {
                completionService = new CallerRunsCompletionService();
                paramsProvider = new InstanceStorageParametersProvider(this.storageParameters);
            } else {
                completionService = new ThreadPoolCompletionService(ServerServiceRegistry.getInstance().getService(ThreadPoolService.class, true));
                paramsProvider = null == this.session ? new SessionStorageParametersProvider(this.user, this.context) : new SessionStorageParametersProvider(this.session);
            }
            int taskCount = 0;
            final VisibleFoldersPerformer performer = this;
            for (Map.Entry entry : map.entrySet()) {
                final FolderStorage tmp = (FolderStorage)entry.getKey();
                final int[] indexes = ((TIntList)entry.getValue()).toArray();
                final Logger log = LOG;
                completionService.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        StorageParameters newParameters = paramsProvider.getStorageParameters();
                        ArrayList<FolderStorage> openedStorages = new ArrayList<FolderStorage>(2);
                        if (tmp.startTransaction(newParameters, false)) {
                            openedStorages.add(tmp);
                        }
                        try {
                            List<Folder> folders2;
                            try {
                                ArrayList<String> ids = new ArrayList<String>(indexes.length);
                                for (int index : indexes) {
                                    ids.add(((SortableId)allSubfolderIds.get(index)).getId());
                                }
                                folders2 = tmp.getFolders(treeId, ids, newParameters);
                                Set<OXException> warnings = newParameters.getWarnings();
                                if (!warnings.isEmpty()) {
                                    VisibleFoldersPerformer.this.addWarning(warnings.iterator().next());
                                }
                            }
                            catch (OXException e) {
                                log.warn("Batch loading of folder failed. Fall-back to one-by-one loading.", (Throwable)e);
                                folders2 = null;
                            }
                            if (null == folders2) {
                                for (int index : indexes) {
                                    Permission userPermission;
                                    Folder subfolder;
                                    String id = ((SortableId)allSubfolderIds.get(index)).getId();
                                    try {
                                        subfolder = tmp.getFolder(treeId, id, newParameters);
                                    }
                                    catch (OXException e) {
                                        log.warn("The folder with ID \"{}\" in tree \"{}\" could not be fetched from storage \"{}\"", new Object[]{id, treeId, tmp.getClass().getSimpleName(), e});
                                        VisibleFoldersPerformer.this.addWarning(e);
                                        continue;
                                    }
                                    if (!all && !subfolder.isSubscribed() && !subfolder.hasSubscribedSubfolders() || !(userPermission = CalculatePermission.calculate(subfolder, performer, VisibleFoldersPerformer.this.getAllowedContentTypes())).isVisible()) continue;
                                    subfolders[index] = VisibleFoldersPerformer.this.getUserizedFolder(subfolder, userPermission, treeId, all, true, newParameters, openedStorages);
                                }
                            } else {
                                int size = folders2.size();
                                int j = 0;
                                for (int index : indexes) {
                                    Permission userPermission;
                                    if (j >= size) continue;
                                    Folder subfolder = folders2.get(j++);
                                    if (!all && !subfolder.isSubscribed() && !subfolder.hasSubscribedSubfolders() || !(userPermission = CalculatePermission.calculate(subfolder, performer, VisibleFoldersPerformer.this.getAllowedContentTypes())).isVisible()) continue;
                                    subfolders[index] = VisibleFoldersPerformer.this.getUserizedFolder(subfolder, userPermission, treeId, all, true, newParameters, openedStorages);
                                }
                            }
                            for (FolderStorage fs : openedStorages) {
                                fs.commitTransaction(newParameters);
                            }
                            return null;
                        }
                        catch (OXException e) {
                            for (FolderStorage fs : openedStorages) {
                                fs.rollback(newParameters);
                            }
                            throw e;
                        }
                        catch (RuntimeException e) {
                            for (FolderStorage fs : openedStorages) {
                                fs.rollback(newParameters);
                            }
                            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
                        }
                    }
                });
                ++taskCount;
            }
            ThreadPools.takeCompletionService((CompletionService)completionService, (int)taskCount, (ThreadPools.ExpectedExceptionFactory)FACTORY);
            UserizedFolder[] ret = VisibleFoldersPerformer.trimArray(subfolders);
            if (SharedType.getInstance().equals(type)) {
                int userId = this.storageParameters.getUserId();
                int len = "u:".length();
                StringBuilder sb = new StringBuilder("u:");
                for (UserizedFolder userizedFolder : ret) {
                    int createdBy = userizedFolder.getCreatedBy();
                    if (createdBy <= 0 || createdBy == userId) continue;
                    sb.setLength(len);
                    userizedFolder.setParentID(sb.append(createdBy).toString());
                }
            }
            if (started) {
                folderStorage.commitTransaction(this.storageParameters);
            }
            return ret;
        }
        catch (OXException e) {
            if (started) {
                folderStorage.rollback(this.storageParameters);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (started) {
                folderStorage.rollback(this.storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }
}

