/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.configuration;

import com.openexchange.ajax.writer.LoginWriter;
import com.openexchange.config.ConfigTools;
import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Reloadable;
import com.openexchange.configuration.ClientWhitelist;
import com.openexchange.configuration.ConfigurationExceptionCodes;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentConfig;
import com.openexchange.groupware.calendar.CalendarConfig;
import com.openexchange.groupware.infostore.InfostoreConfig;
import com.openexchange.groupware.notify.NotificationConfig;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.Strings;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerConfig
implements Reloadable {
    private static final Logger LOG = LoggerFactory.getLogger(ServerConfig.class);
    private static final ServerConfig SINGLETON = new ServerConfig();
    private static final String FILENAME = "server.properties";
    private static final String[] PROPERTIES = new String[]{"all properties in file"};
    private final Properties props = new Properties();
    private String uploadDirectory = "/tmp/";
    private int maxFileUploadSize = 10000;
    private int maxUploadIdleTimeMillis = 300000;
    private boolean prefetchEnabled;
    private String defaultEncoding;
    private int jmxPort;
    private String jmxBindAddress;
    private Boolean checkIP;
    private String ipMaskV4;
    private String ipMaskV6;
    private final ClientWhitelist clientWhitelist = new ClientWhitelist();
    private String uiWebPath;
    private int cookieTTL;
    private boolean cookieHttpOnly;
    private int maxBodySize;
    private int defaultMaxConcurrentAJAXRequests;

    public static ServerConfig getInstance() {
        return SINGLETON;
    }

    private ServerConfig() {
    }

    public void reloadConfiguration(ConfigurationService configService) {
        Properties newProps = configService.getFile(FILENAME);
        this.props.clear();
        if (null == newProps) {
            LOG.info("Configuration file {} is missing. Using defaults.", (Object)FILENAME);
        } else {
            this.props.putAll((Map<?, ?>)newProps);
            LOG.info("Read configuration file {}.", (Object)FILENAME);
        }
        this.reinit();
        try {
            AttachmentConfig attachmentConfig = AttachmentConfig.getInstance();
            attachmentConfig.stop();
            attachmentConfig.start();
        }
        catch (Exception e) {
            LOG.warn("Could not reload attachment configuration.", (Throwable)e);
        }
        try {
            CalendarConfig calendarConfig = CalendarConfig.getInstance();
            calendarConfig.stop();
            calendarConfig.start();
        }
        catch (Exception e) {
            LOG.warn("Could not reload calendar configuration.", (Throwable)e);
        }
        try {
            InfostoreConfig infostoreConfig = InfostoreConfig.getInstance();
            infostoreConfig.stop();
            infostoreConfig.start();
        }
        catch (Exception e) {
            LOG.warn("Could not reload infostore configuration.", (Throwable)e);
        }
        try {
            NotificationConfig notificationConfig = NotificationConfig.getInstance();
            notificationConfig.stop();
            notificationConfig.start();
        }
        catch (Exception e) {
            LOG.warn("Could not reload infostore configuration.", (Throwable)e);
        }
        LoginWriter.invalidateRandomTokenEnabled();
    }

    public void initialize(ConfigurationService confService) {
        Properties newProps = confService.getFile(FILENAME);
        if (null == newProps) {
            LOG.info("Configuration file {} is missing. Using defaults.", (Object)FILENAME);
        } else {
            this.props.clear();
            this.props.putAll((Map<?, ?>)newProps);
            LOG.info("Read configuration file {}.", (Object)FILENAME);
        }
        this.reinit();
    }

    public void shutdown() {
        this.props.clear();
        this.reinit();
    }

    private void reinit() {
        this.uploadDirectory = this.getPropertyInternal(Property.UploadDirectory);
        if (!this.uploadDirectory.endsWith("/")) {
            this.uploadDirectory = this.uploadDirectory + "/";
        }
        this.uploadDirectory = this.uploadDirectory + ".OX/";
        try {
            if (new File(this.uploadDirectory).mkdir()) {
                Runtime.getRuntime().exec("chmod 700 " + this.uploadDirectory);
                Runtime.getRuntime().exec("chown open-xchange:open-xchange " + this.uploadDirectory);
                LOG.info("Temporary upload directory created");
            }
        }
        catch (Exception e) {
            LOG.error("Temporary upload directory could NOT be properly created", (Throwable)e);
        }
        try {
            this.maxFileUploadSize = Integer.parseInt(this.getPropertyInternal(Property.MaxFileUploadSize));
        }
        catch (NumberFormatException e) {
            this.maxFileUploadSize = 10000;
        }
        try {
            this.maxUploadIdleTimeMillis = Integer.parseInt(this.getPropertyInternal(Property.MaxUploadIdleTimeMillis));
        }
        catch (NumberFormatException e) {
            this.maxUploadIdleTimeMillis = 300000;
        }
        this.prefetchEnabled = Boolean.parseBoolean(this.getPropertyInternal(Property.PrefetchEnabled));
        this.defaultEncoding = this.getPropertyInternal(Property.DefaultEncoding);
        this.jmxPort = Integer.parseInt(this.getPropertyInternal(Property.JMX_PORT));
        this.jmxBindAddress = this.getPropertyInternal(Property.JMX_BIND_ADDRESS);
        this.checkIP = Boolean.valueOf(this.getPropertyInternal(Property.IP_CHECK));
        this.ipMaskV4 = this.getPropertyInternal(Property.IP_MASK_V4);
        this.ipMaskV6 = this.getPropertyInternal(Property.IP_MASK_V6);
        this.clientWhitelist.clear();
        this.clientWhitelist.add(this.getPropertyInternal(Property.IP_CHECK_WHITELIST));
        this.uiWebPath = this.getPropertyInternal(Property.UI_WEB_PATH);
        this.cookieTTL = (int)ConfigTools.parseTimespan((String)this.getPropertyInternal(Property.COOKIE_TTL));
        this.cookieHttpOnly = Boolean.parseBoolean(this.getPropertyInternal(Property.COOKIE_HTTP_ONLY));
        this.maxBodySize = Integer.parseInt(this.getPropertyInternal(Property.MAX_BODY_SIZE));
        this.defaultMaxConcurrentAJAXRequests = Integer.parseInt(this.getPropertyInternal(Property.DEFAULT_MAX_CONCURRENT_AJAX_REQUESTS));
    }

    private String getPropertyInternal(Property property) {
        return this.props.getProperty(property.getPropertyName(), property.getDefaultValue());
    }

    private static String getProperty(String key) {
        return ServerConfig.SINGLETON.props.getProperty(key);
    }

    public static <V> V getPropertyObject(Property property) {
        try {
            Object value;
            switch (property) {
                case UploadDirectory: {
                    value = ServerConfig.SINGLETON.uploadDirectory;
                    break;
                }
                case MaxFileUploadSize: {
                    value = ServerConfig.SINGLETON.maxFileUploadSize;
                    break;
                }
                case MaxUploadIdleTimeMillis: {
                    value = ServerConfig.SINGLETON.maxUploadIdleTimeMillis;
                    break;
                }
                case PrefetchEnabled: {
                    value = ServerConfig.SINGLETON.prefetchEnabled;
                    break;
                }
                case DefaultEncoding: {
                    value = ServerConfig.SINGLETON.defaultEncoding;
                    break;
                }
                case JMX_PORT: {
                    value = ServerConfig.SINGLETON.jmxPort;
                    break;
                }
                case JMX_BIND_ADDRESS: {
                    value = ServerConfig.SINGLETON.jmxBindAddress;
                    break;
                }
                case UI_WEB_PATH: {
                    value = ServerConfig.SINGLETON.uiWebPath;
                    break;
                }
                case COOKIE_TTL: {
                    value = ServerConfig.SINGLETON.cookieTTL;
                    break;
                }
                case COOKIE_HTTP_ONLY: {
                    value = ServerConfig.SINGLETON.cookieHttpOnly;
                    break;
                }
                case IP_CHECK: {
                    value = ServerConfig.SINGLETON.checkIP;
                    break;
                }
                case IP_MASK_V4: {
                    value = ServerConfig.SINGLETON.ipMaskV4;
                    break;
                }
                case IP_MASK_V6: {
                    value = ServerConfig.SINGLETON.ipMaskV6;
                    break;
                }
                case IP_CHECK_WHITELIST: {
                    value = ServerConfig.SINGLETON.clientWhitelist;
                    break;
                }
                case MAX_BODY_SIZE: {
                    value = ServerConfig.SINGLETON.maxBodySize;
                    break;
                }
                case DEFAULT_MAX_CONCURRENT_AJAX_REQUESTS: {
                    value = ServerConfig.SINGLETON.defaultMaxConcurrentAJAXRequests;
                    break;
                }
                default: {
                    value = ServerConfig.getProperty(property.getPropertyName());
                }
            }
            return (V)value;
        }
        catch (ClassCastException e) {
            LOG.debug("", (Throwable)e);
            return null;
        }
    }

    public static String getProperty(Property property) {
        String value;
        switch (property) {
            case UploadDirectory: {
                value = ServerConfig.SINGLETON.uploadDirectory;
                break;
            }
            case MaxFileUploadSize: {
                value = Integer.toString(ServerConfig.SINGLETON.maxFileUploadSize);
                break;
            }
            case MaxUploadIdleTimeMillis: {
                value = Integer.toString(ServerConfig.SINGLETON.maxUploadIdleTimeMillis);
                break;
            }
            case PrefetchEnabled: {
                value = String.valueOf(ServerConfig.SINGLETON.prefetchEnabled);
                break;
            }
            case DefaultEncoding: {
                value = ServerConfig.SINGLETON.defaultEncoding;
                break;
            }
            case JMX_PORT: {
                value = Integer.toString(ServerConfig.SINGLETON.jmxPort);
                break;
            }
            case JMX_BIND_ADDRESS: {
                value = ServerConfig.SINGLETON.jmxBindAddress;
                break;
            }
            case UI_WEB_PATH: {
                value = ServerConfig.SINGLETON.uiWebPath;
                break;
            }
            case COOKIE_TTL: {
                value = Integer.toString(ServerConfig.SINGLETON.cookieTTL);
                break;
            }
            case COOKIE_HTTP_ONLY: {
                value = String.valueOf(ServerConfig.SINGLETON.cookieHttpOnly);
                break;
            }
            case IP_CHECK: {
                value = ServerConfig.SINGLETON.checkIP.toString();
                break;
            }
            case IP_MASK_V4: {
                value = ServerConfig.SINGLETON.ipMaskV4.toString();
                break;
            }
            case IP_MASK_V6: {
                value = ServerConfig.SINGLETON.ipMaskV6.toString();
                break;
            }
            case MAX_BODY_SIZE: {
                value = Integer.toString(ServerConfig.SINGLETON.maxBodySize);
                break;
            }
            case DEFAULT_MAX_CONCURRENT_AJAX_REQUESTS: {
                value = Integer.toString(ServerConfig.SINGLETON.defaultMaxConcurrentAJAXRequests);
                break;
            }
            default: {
                value = ServerConfig.getProperty(property.getPropertyName());
            }
        }
        return value;
    }

    public static boolean getBoolean(Property property) {
        boolean value = Property.PrefetchEnabled == property ? ServerConfig.SINGLETON.prefetchEnabled : (Property.COOKIE_HTTP_ONLY == property ? ServerConfig.SINGLETON.cookieHttpOnly : Boolean.parseBoolean(ServerConfig.SINGLETON.props.getProperty(property.getPropertyName())));
        return value;
    }

    public static Integer getInteger(Property property) throws OXException {
        Integer value;
        switch (property) {
            case MaxFileUploadSize: {
                value = Autoboxing.I((int)ServerConfig.SINGLETON.maxFileUploadSize);
                break;
            }
            case MaxUploadIdleTimeMillis: {
                value = Autoboxing.I((int)ServerConfig.SINGLETON.maxUploadIdleTimeMillis);
                break;
            }
            case JMX_PORT: {
                value = Autoboxing.I((int)ServerConfig.SINGLETON.jmxPort);
                break;
            }
            case COOKIE_TTL: {
                value = Autoboxing.I((int)ServerConfig.SINGLETON.cookieTTL);
                break;
            }
            case MAX_BODY_SIZE: {
                value = Autoboxing.I((int)ServerConfig.SINGLETON.maxBodySize);
                break;
            }
            case DEFAULT_MAX_CONCURRENT_AJAX_REQUESTS: {
                value = Autoboxing.I((int)ServerConfig.SINGLETON.defaultMaxConcurrentAJAXRequests);
                break;
            }
            default: {
                try {
                    String prop = ServerConfig.getProperty(property.getPropertyName());
                    if (prop == null) {
                        throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(property.getPropertyName());
                    }
                    value = Integer.valueOf(ServerConfig.getProperty(property.getPropertyName()));
                    break;
                }
                catch (NumberFormatException e) {
                    throw ConfigurationExceptionCodes.PROPERTY_NOT_AN_INTEGER.create(property.getPropertyName());
                }
            }
        }
        return value;
    }

    public static int getInt(Property property) throws OXException {
        int value;
        switch (property) {
            case MaxFileUploadSize: {
                value = ServerConfig.SINGLETON.maxFileUploadSize;
                break;
            }
            case MaxUploadIdleTimeMillis: {
                value = ServerConfig.SINGLETON.maxUploadIdleTimeMillis;
                break;
            }
            case JMX_PORT: {
                value = ServerConfig.SINGLETON.jmxPort;
                break;
            }
            case COOKIE_TTL: {
                value = ServerConfig.SINGLETON.cookieTTL;
                break;
            }
            case MAX_BODY_SIZE: {
                value = ServerConfig.SINGLETON.maxBodySize;
                break;
            }
            case DEFAULT_MAX_CONCURRENT_AJAX_REQUESTS: {
                value = ServerConfig.SINGLETON.defaultMaxConcurrentAJAXRequests;
                break;
            }
            default: {
                try {
                    String prop = ServerConfig.getProperty(property.getPropertyName());
                    if (Strings.isEmpty((String)prop)) {
                        throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(property.getPropertyName());
                    }
                    value = Integer.parseInt(prop.trim());
                    break;
                }
                catch (NumberFormatException e) {
                    throw ConfigurationExceptionCodes.PROPERTY_NOT_AN_INTEGER.create(e, property.getPropertyName());
                }
            }
        }
        return value;
    }

    public static Long getLong(Property property) throws OXException {
        Long value;
        switch (property) {
            case MaxFileUploadSize: {
                value = Autoboxing.L((long)ServerConfig.SINGLETON.maxFileUploadSize);
                break;
            }
            case MaxUploadIdleTimeMillis: {
                value = Autoboxing.L((long)ServerConfig.SINGLETON.maxUploadIdleTimeMillis);
                break;
            }
            case JMX_PORT: {
                value = Autoboxing.L((long)ServerConfig.SINGLETON.jmxPort);
                break;
            }
            case COOKIE_TTL: {
                value = Autoboxing.L((long)ServerConfig.SINGLETON.cookieTTL);
                break;
            }
            case MAX_BODY_SIZE: {
                value = Autoboxing.L((long)ServerConfig.SINGLETON.maxBodySize);
                break;
            }
            case DEFAULT_MAX_CONCURRENT_AJAX_REQUESTS: {
                value = Autoboxing.L((long)ServerConfig.SINGLETON.defaultMaxConcurrentAJAXRequests);
                break;
            }
            default: {
                try {
                    String prop = ServerConfig.getProperty(property.getPropertyName());
                    if (prop == null) {
                        throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(property.getPropertyName());
                    }
                    value = Long.valueOf(ServerConfig.getProperty(property.getPropertyName()));
                    break;
                }
                catch (NumberFormatException e) {
                    throw ConfigurationExceptionCodes.PROPERTY_NOT_AN_INTEGER.create(property.getPropertyName());
                }
            }
        }
        return value;
    }

    public Map<String, String[]> getConfigFileNames() {
        HashMap<String, String[]> map = new HashMap<String, String[]>(1);
        map.put(FILENAME, PROPERTIES);
        return map;
    }

    public static enum Property {
        UploadDirectory("UPLOAD_DIRECTORY", "/tmp/"),
        MaxFileUploadSize("MAX_UPLOAD_FILE_SIZE", "10000"),
        PrefetchEnabled("PrefetchEnabled", Boolean.FALSE.toString()),
        DefaultEncoding("DefaultEncoding", "UTF-8"),
        MAX_UPLOAD_SIZE("MAX_UPLOAD_SIZE", "104857600"),
        JMX_PORT("JMXPort", "9999"),
        JMX_BIND_ADDRESS("JMXBindAddress", "localhost"),
        MaxUploadIdleTimeMillis("MAX_UPLOAD_IDLE_TIME_MILLIS", "300000"),
        MINIMUM_SEARCH_CHARACTERS("com.openexchange.MinimumSearchCharacters", "0"),
        IP_CHECK("com.openexchange.IPCheck", Boolean.TRUE.toString()),
        IP_MASK_V4("com.openexchange.IPMaskV4", ""),
        IP_MASK_V6("com.openexchange.IPMaskV6", ""),
        IP_CHECK_WHITELIST("com.openexchange.IPCheckWhitelist", ""),
        UI_WEB_PATH("com.openexchange.UIWebPath", "/appsuite/"),
        COOKIE_TTL("com.openexchange.cookie.ttl", "1W"),
        COOKIE_HTTP_ONLY("com.openexchange.cookie.httpOnly", Boolean.TRUE.toString()),
        COOKIE_HASH_FIELDS("com.openexchange.cookie.hash.fields", ""),
        COOKIE_HASH("com.openexchange.cookie.hash", "calculate"),
        COOKIE_FORCE_HTTPS("com.openexchange.forceHTTPS", Boolean.FALSE.toString()),
        FORCE_HTTPS("com.openexchange.forceHTTPS", Boolean.FALSE.toString()),
        MAX_BODY_SIZE("MAX_BODY_SIZE", "104857600"),
        DEFAULT_MAX_CONCURRENT_AJAX_REQUESTS("com.openexchange.defaultMaxConcurrentAJAXRequests", "100");

        private final String propertyName;
        private final String defaultValue;

        private Property(String propertyName, String defaultValue) {
            this.propertyName = propertyName;
            this.defaultValue = defaultValue;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

