/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.concurrent;

import com.openexchange.concurrent.Synchronizer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class NonBlockingSynchronizer
implements Synchronizer,
Runnable {
    private static final Object PRESENT = new Object();
    private volatile Runnable runnable;
    private volatile boolean obtainLock;
    private final AtomicInteger running;
    private final AtomicInteger writeCounter = new AtomicInteger();
    private final Lock runLock;
    private final Map<Thread, Object> reentrant;

    public NonBlockingSynchronizer() {
        this(null);
    }

    public NonBlockingSynchronizer(Runnable runnable) {
        this.running = new AtomicInteger();
        this.runLock = new ReentrantLock();
        this.runnable = runnable;
        this.reentrant = new ConcurrentHashMap<Thread, Object>();
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public void setRunnable(Runnable runnable) {
        this.runnable = runnable;
    }

    public Runnable setSynchronized(boolean synchronize) {
        if (this.reentrant.containsKey(Thread.currentThread())) {
            throw new IllegalStateException("Current thread acquired synchronizer, but wants to alter sync mode");
        }
        int value = this.writeCounter.get();
        while ((value & 1) == 1) {
            value = this.writeCounter.get();
        }
        while (!this.writeCounter.compareAndSet(value, value + 1)) {
            while (((value = this.writeCounter.get()) & 1) == 1) {
            }
        }
        while (this.running.get() > 0) {
        }
        this.obtainLock = synchronize;
        this.writeCounter.getAndIncrement();
        return this;
    }

    @Override
    public Lock acquire() {
        if (this.reentrant.containsKey(Thread.currentThread())) {
            return null;
        }
        int save = 0;
        Lock lock = null;
        while (true) {
            if (((save = this.writeCounter.get()) & 1) == 1) {
                continue;
            }
            Lock lock2 = lock = this.obtainLock ? this.runLock : null;
            if (save == this.writeCounter.get()) break;
        }
        this.running.incrementAndGet();
        this.reentrant.put(Thread.currentThread(), PRESENT);
        if (null != lock) {
            lock.lock();
        }
        return lock;
    }

    @Override
    public void release(Lock lock) {
        if (null != lock) {
            lock.unlock();
        }
        this.reentrant.remove(Thread.currentThread());
        this.running.decrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Lock lock = this.acquire();
        try {
            if (null != this.runnable) {
                this.runnable.run();
            }
        }
        finally {
            this.release(lock);
        }
    }

    @Override
    public void synchronize() {
        this.setSynchronized(true);
    }

    @Override
    public void unsynchronize() {
        this.setSynchronized(false);
    }
}

