/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.authentication.basic;

import com.openexchange.authentication.Authenticated;
import com.openexchange.authentication.BasicAuthenticationService;
import com.openexchange.authentication.LoginExceptionCodes;
import com.openexchange.authentication.LoginInfo;
import com.openexchange.context.ContextService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.LdapExceptionCode;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserExceptionCode;
import com.openexchange.user.UserService;

public class DefaultBasicAuthentication
implements BasicAuthenticationService {
    private final ContextService contextService;
    private final UserService userService;

    public DefaultBasicAuthentication(ContextService contextService, UserService userService) {
        this.contextService = contextService;
        this.userService = userService;
    }

    public Authenticated handleLoginInfo(int userId, int contextId) throws OXException {
        Context ctx = this.contextService.getContext(contextId);
        User user = this.userService.getUser(userId, ctx);
        return new AuthenticatedImpl(new String[]{ctx.getLoginInfo()[0], user.getLoginInfo()});
    }

    public Authenticated handleLoginInfo(int userId, int contextId, String password) throws OXException {
        Context ctx = this.contextService.getContext(contextId);
        User user = this.userService.getUser(userId, ctx);
        if (!this.userService.authenticate(user, password)) {
            throw LoginExceptionCodes.INVALID_CREDENTIALS.create();
        }
        return new AuthenticatedImpl(new String[]{ctx.getLoginInfo()[0], user.getLoginInfo()});
    }

    public Authenticated handleLoginInfo(LoginInfo loginInfo) throws OXException {
        int userId;
        int ctxId;
        String password = loginInfo.getPassword();
        if (null == password || 0 == password.length()) {
            throw LoginExceptionCodes.INVALID_CREDENTIALS.create();
        }
        String[] splitted = this.split(loginInfo.getUsername());
        try {
            ctxId = this.contextService.getContextId(splitted[0]);
        }
        catch (OXException e) {
            throw LoginExceptionCodes.COMMUNICATION.create((Throwable)e, new Object[0]);
        }
        if (-1 == ctxId) {
            throw LoginExceptionCodes.INVALID_CREDENTIALS_MISSING_CONTEXT_MAPPING.create(new Object[]{splitted[0]});
        }
        Context ctx = this.contextService.getContext(ctxId);
        try {
            userId = this.userService.getUserId(splitted[1], ctx);
        }
        catch (OXException e) {
            if (e.equalsCode(LdapExceptionCode.USER_NOT_FOUND.getNumber(), UserExceptionCode.PROPERTY_MISSING.getPrefix())) {
                throw LoginExceptionCodes.INVALID_CREDENTIALS_MISSING_USER_MAPPING.create(new Object[]{splitted[1]});
            }
            throw e;
        }
        User user = this.userService.getUser(userId, ctx);
        if (!this.userService.authenticate(user, password)) {
            throw LoginExceptionCodes.INVALID_CREDENTIALS.create();
        }
        return new AuthenticatedImpl(splitted);
    }

    public Authenticated handleAutoLoginInfo(LoginInfo loginInfo) throws OXException {
        throw LoginExceptionCodes.NOT_SUPPORTED.create(new Object[]{DefaultBasicAuthentication.class.getName()});
    }

    private String[] split(String loginInfo) {
        return this.split(loginInfo, '@');
    }

    private String[] split(String loginInfo, char separator) {
        int pos = loginInfo.lastIndexOf(separator);
        String[] splitted = -1 == pos ? new String[]{"defaultcontext", loginInfo} : new String[]{loginInfo.substring(pos + 1), loginInfo.substring(0, pos)};
        return splitted;
    }

    private static final class AuthenticatedImpl
    implements Authenticated {
        private final String[] splitted;

        protected AuthenticatedImpl(String[] splitted) {
            this.splitted = splitted;
        }

        public String getContextInfo() {
            return this.splitted[0];
        }

        public String getUserInfo() {
            return this.splitted[1];
        }
    }
}

