/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.text;

import com.openexchange.html.HtmlSanitizeResult;
import com.openexchange.html.HtmlService;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.text.HtmlProcessing;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.utils.DisplayMode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={UserSettingMail.class, MailPath.class, ServerServiceRegistry.class})
public class HtmlProcessingTest {
    private String htmlContent = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\"><head>\n    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n \n </head><body>\n \n  <ol>\n   <li>fadskjfdaksjf&#246;ldksajfdkl&#246;jadksf<br /></li>\n   <li>dkfj&#246;adsadjksf&#246;ladjksfl&#246;kdjsfl&#246;kadjs<br /></li>\n   <li>das&#246;fjkds&#246;lkfjdsl&#246;kfjdsadls&#246;<br /></li>\n   <li>\n    <ul>\n     <li>gfhdgd<br /></li>\n     <li>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. <br /><br />Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. <br /><br />Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te</li>\n    </ul></li>\n   <li>\n    <ul>\n     <li>gfhdgd<br /></li>\n     <li>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. <br /><br />Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. <br /><br />Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te</li>\n     <li>\n      <ul>\n       <li>gfhdgd<br /></li>\n       <li>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. <br /><br />Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. <br /><br />Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te</li>\n      </ul></li>\n     <li>\n      <ul>\n       <li>gfhdgd<br /></li>\n       <li>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. <br /><br />Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. <br /><br />Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te</li>\n      </ul></li>\n    </ul></li>\n   <li>\n    <ul>\n     <li>gfhdgd<br /></li>\n     <li>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. <br /><br />Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. <br /><br />Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te</li>\n    </ul></li>\n   <li>\n    <ul>\n     <li>gfhdgd<br /></li>\n     <li>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. <br /><br />Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. <br /><br />Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te</li>\n    </ul></li>\n  </ol>\n  <blockquote type=\"cite\">\n   ---------- Urspr&#252;ngliche Nachricht ----------\n   <br />Von: Martin Schneider &#60;martin.schneider@premium&#62;\n   <br />An: Martin Schneider &#60;martin.schneider@premium&#62;\n   <br />Datum: 24. Juni 2014 um 14:47\n   <br />Betreff: HTML-Mail\n   <br />\n   <br />\n   <p>Tolle html mail <br /></p>\n   <ul>\n    <li>hgfhghdgdhdg<br /></li>\n    <li>gfhdgd<br /></li>\n    <li>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. <br /><br />Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. <br /><br />Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. <br /><br />Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet doming id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. <br /><br />Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis. <br /><br />At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita ea et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua. est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat. <br /><br />Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus. <br /><br />Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. <br /><br />Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. <br /><br /><span style=\"color: rgb(255, 0, 0);\">Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. </span><br /><br /><span style=\"color: rgb(255, 0, 0);\">Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet doming id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo</span></li>\n    <li><br /></li>\n   </ul>\n  </blockquote>\n  <p><br />&#160;</p>\n \n</body></html>";
    private String sanitizedHtmlContent = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\"><head>\n    \n \n </head><body>\n \n  <ol>\n   <li>fadskjfdaksjf&#246;ldksajfdkl&#246;jadksf<br/></li>\n   <li>dkfj&#246;adsadjksf&#246;ladjksfl&#246;kdjsfl&#246;kadjs<br/></li>\n   <li>das&#246;fjkds&#246;lkfjdsl&#246;kfjdsadls&#246;<br/></li>\n   <li>\n    <ul>\n     <li>gfhdgd<br/></li>\n     <li>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. <br/><br/>Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. <br/><br/>Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te</li>\n    </ul></li>\n   <li>\n    <ul>\n     <li>gfhdgd<br/></li>\n     <li>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. <br/><br/>Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. <br/><br/>Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te</li>\n     <li>\n      <ul>\n       <li>gfhdgd<br/></li>\n       <li>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. <br/><br/>Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. <br/><br/>Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te</li>\n      </ul></li>\n     <li>\n      <ul>\n       <li>gfhdgd<br/></li>\n       <li>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. <br/><br/>Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. <br/><br/>Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te</li>\n      </ul></li>\n    </ul></li>\n   <li>\n    <ul>\n     <li>gfhdgd<br/></li>\n     <li>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. <br/><br/>Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. <br/><br/>Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te</li>\n    </ul></li>\n   <li>\n    <ul>\n     <li>gfhdgd<br/></li>\n     <li>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. <br/><br/>Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. <br/><br/>Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te</li>\n    </ul></li>\n  </ol>\n  <blockquote type=\"cite\">\n   ---------- Urspr&#252;ngliche Nachricht ----------\n   <br/>Von: Martin Schneider &#60;martin.schneider@premium&#62;\n   <br/>An: Martin Schneider &#60;martin.schneider@premium&#62;\n   <br/>Datum: 24. Juni 2014 um 14:47\n   <br/>Betreff: HTML-Mail\n   <br/>\n   <br/>\n   <p>Tolle html mail <br/></p>\n   <ul>\n    <li>hgfhghdgdhdg<br/></li>\n    <li>gfhdgd<br/></li>\n    <li>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. <br/><br/>Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. <br/><br/>Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. <br/><br/>Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet doming id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. <br/><br/>Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis. <br/><br/>At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita ea et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua. est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat. <br/><br/>Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus. <br/><br/>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. <br/><br/>Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. <br/><br/><span style=\"color: rgb(255,0,0);\">Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. </span><br/><br/><span style=\"color: rgb(255,0,0);\">Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet doming id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo</span></li>\n    <li><br/></li>\n   </ul>\n  </blockquote>\n  <p><br/>&#160;</p>\n \n</body></html>";
    private String textContent = "\n\n> Martin Schneider <martin.schneider@premium> hat am 26. Juni 2014 um 13:45\n> geschrieben:\n> \n> \n> Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy\n> eirmod\n> tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At\n> vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd\n> gubergren,\n> no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit\n> amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut\n> labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et\n> accusam\n> et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata\n> sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur\n> sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore\n> magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo\n> dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est\n> Lorem ipsum dolor sit amet. \n> \n> Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie\n> consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et\n> accumsan\n> et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis\n> dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer\n> adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore\n> magna\n> aliquam erat volutpat. \n> \n> Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit\n> lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure\n> dolor in hendrerit in vulputate velit esse molestie consequat, vel illum\n> dolore\n> eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim\n> qui\n> blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla\n> facilisi. \n> \n> Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet\n> doming\n> id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet,\n> consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut\n> laoreet\n> dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud\n> exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo\n> consequat. \n> \n> Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie\n> consequat, vel illum dolore eu feugiat nulla facilisis. \n> \n> At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd\n> gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum\n> dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor\n> invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero\n> eos\n> et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea\n> takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet,\n> consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo\n> eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita\n> ea\n> et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua.\n> est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur\n> sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore\n> magna aliquyam erat. \n> \n> Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore\n> et\n> dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo\n> duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus\n> est\n> Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing\n> elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna\n> aliquyam\n> erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea\n> rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum\n> dolor\n> sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam\n> nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed\n> diam\n> voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita\n> kasd gubergren, no sea takimata sanctus. Lorem ipsum dolor sit amet,\n> consetetur\n> sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore\n> magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo\n> dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est\n> Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing\n> elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna\n> aliquyam\n> erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea\n> rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum\n> dolor\n> sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam\n> nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed\n> diam\n> voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita\n> kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. \n> \n> Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie\n> consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et\n> accumsan\n> et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis\n> dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer\n> adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore\n> magna\n> aliquam erat volutpat. \n> \n> Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit\n> lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure\n> dolor in hendrerit in vulputate velit esse molestie consequat, vel illum\n> dolore\n> eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim\n> qui\n> blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla\n> facilisi. \n> \n> Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet\n> doming\n> id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet,\n> consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut\n> laoreet\n> dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud\n> exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo\n> consequat. \n> \n> Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie\n> consequat, vel illum dolore eu feugiat nulla facilisis. \n> \n> At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd\n> gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum\n> dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor\n> invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero\n> eos\n> et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea\n> takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet,\n> consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo\n> eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita\n> ea\n> et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua.\n> est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur\n> sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore\n> magna aliquyam erat. \n> \n> Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore\n> et\n> dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo\n> duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus\n> est\n> Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing\n> elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna\n> aliquyam\n> erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea\n> rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum\n> dolor\n> sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam\n> nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed\n> diam\n> voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita\n> kasd gubergren, no sea takimata sanctus. Lorem ipsum dolor sit amet,\n> consetetur\n> sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore\n> magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo\n> dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est\n> Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing\n> elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna\n> aliquyam\n> erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea\n> rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum\n> dolor\n> sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam\n> nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed\n> diam\n> voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita\n> kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. \n> \n> Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie\n> consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et\n> accumsan\n> et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis\n> dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer\n> adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore\n> magna\n> aliquam erat volutpat. \n> \n> Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit\n> lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure\n> dolor in hendrerit in vulputate velit esse molestie consequat, vel illum\n> dolore\n> eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim\n> qui\n> blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla\n> facilisi. \n> \n> Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet\n> doming\n> id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet,\n> consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut\n> laoreet\n> dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud\n> exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo\n> consequat. \n> \n> Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie\n> consequat, vel illum dolore eu feugiat nulla facilisis. \n> \n> At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd\n> gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum\n> dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor\n> invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero\n> eos\n> et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea\n> takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet,\n> consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo\n> eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita\n> ea\n> et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua.\n> est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur\n> sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore\n> magna aliquyam erat. \n> \n> Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore\n> et\n> dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo\n> duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus\n> est\n> Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing\n> elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna\n> aliquyam\n> erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea\n> rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum\n> dolor\n> sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam\n> nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed\n> diam\n> voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita\n> kasd gubergren, no sea takimata sanctus. Lorem ipsum dolor sit amet,\n> consetetur\n> sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore\n> magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo\n> dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est\n> Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing\n> elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna\n> aliquyam\n> erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea\n> rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum\n> dolor\n> sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam\n> nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed\n> diam\n> voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita\n> kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. \n> \n> Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie\n> consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et\n> accumsan\n> et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis\n> dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer\n> adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore\n> magna\n> aliquam erat volutpat. \n> \n> Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit\n> lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure\n> dolor in hendrerit in vulputate velit esse molestie consequat, vel illum\n> dolore\n> eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim\n> qui\n> blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla\n> facilisi. \n> \n> Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet\n> doming\n> id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet,\n> consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut\n> laoreet\n> dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud\n> exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo\n> consequat. \n> \n> Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie\n> consequat, vel illum dolore eu feugiat nulla facilisis. \n> \n> At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd\n> gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum\n> dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor\n> invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero\n> eos\n> et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea\n> takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet,\n> consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo\n> eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita\n> ea\n> et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua.\n> est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur\n> sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore\n> magna aliquyam erat. \n> \n> Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore\n> et\n> dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo\n> duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus\n> est\n> Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing\n> elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna\n> aliquyam\n> erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea\n> rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum\n> dolor\n> sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam\n> nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed\n> diam\n> voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita\n> kasd gubergren, no sea takimata sanctus. Lorem ipsum dolor sit amet,\n> consetetur\n> sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore\n> magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo\n> dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est\n> Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing\n> elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna\n> aliquyam\n> erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea\n> rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum\n> dolor\n> sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam\n> nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed\n> diam\n> voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita\n> kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. \n> \n> Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie\n> consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et\n> accumsan\n> et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis\n> dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer\n> adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore\n> magna\n> aliquam erat volutpat. \n> \n> Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit\n> lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure\n> dolor in hendrerit in vulputate velit esse molestie consequat, vel illum\n> dolore\n> eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim\n> qui\n> blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla\n> facilisi. \n> \n> Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet\n> doming\n> id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet,\n> consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut\n> laoreet\n> dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud\n> exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo\n> consequat. \n> \n> Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie\n> consequat, vel illum dolore eu feugiat nulla facilisis. \n> \n> At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd\n> gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum\n> dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor\n> invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero\n> eos\n> et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea\n> takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet,\n> consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo\n> eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita\n> ea\n> et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua.\n> est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur\n> sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore\n> magna aliquyam erat. \n> \n> Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore\n> et\n> dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo\n> duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus\n> est\n> Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing\n> elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna\n> aliquyam\n> erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea\n> rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum\n> dolor\n> sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam\n> nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed\n> diam\n> voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita\n> kasd gubergren, no sea takimata sanctus. Lorem ipsum dolor sit amet,\n> consetetur\n> sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore\n> magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo\n> dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est\n> Lorem ipsum dolor\n";
    @Mock
    private UserSettingMail userSettingMail;
    @Mock
    private Session session;
    @Mock
    private MailPath mailPath;
    @Mock
    private ServerServiceRegistry serverServiceRegistry;
    @Mock
    private HtmlService htmlService;
    private boolean[] modified = new boolean[1];

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        PowerMockito.mockStatic(ServerServiceRegistry.class, (Class[])new Class[0]);
        PowerMockito.when((Object)ServerServiceRegistry.getInstance()).thenReturn((Object)this.serverServiceRegistry);
        PowerMockito.when((Object)this.serverServiceRegistry.getService(HtmlService.class)).thenReturn((Object)this.htmlService);
        PowerMockito.when((Object)this.htmlService.sanitize(Matchers.anyString(), Matchers.anyString(), Matchers.anyBoolean(), (boolean[])Matchers.any(), Matchers.anyString(), Matchers.anyInt())).thenReturn((Object)new HtmlSanitizeResult(this.sanitizedHtmlContent));
    }

    @Test
    public void testFormatContentForDisplay_isHtmlNoInlineContentInUserSettingMail_onlyDroppedScriptTagsInHeader() {
        Mockito.when((Object)this.htmlService.dropScriptTagsInHeader(this.htmlContent)).thenReturn((Object)this.htmlContent);
        HtmlSanitizeResult formatTextForDisplay = HtmlProcessing.formatContentForDisplay((String)this.htmlContent, (String)"UTF-8", (boolean)true, (Session)this.session, (MailPath)this.mailPath, (UserSettingMail)this.userSettingMail, (boolean[])this.modified, (DisplayMode)DisplayMode.DISPLAY, (boolean)true, (int)-1);
        Assert.assertEquals((Object)this.htmlContent, (Object)formatTextForDisplay.getContent());
    }

    @Test
    public void testFormatContentForDisplay_isHtmlModeRaw_returnUnchanged() {
        HtmlSanitizeResult formatTextForDisplay = HtmlProcessing.formatContentForDisplay((String)this.htmlContent, (String)"UTF-8", (boolean)true, (Session)this.session, (MailPath)this.mailPath, (UserSettingMail)this.userSettingMail, (boolean[])this.modified, (DisplayMode)DisplayMode.RAW, (boolean)true, (int)-1);
        Assert.assertEquals((Object)this.htmlContent, (Object)formatTextForDisplay.getContent());
    }

    @Test
    public void testFormatContentForDisplay_isHtmlAllowedExternalImages_sanitizeCalled() {
        Mockito.when((Object)this.htmlService.dropScriptTagsInHeader(this.htmlContent)).thenReturn((Object)this.htmlContent);
        Mockito.when((Object)this.userSettingMail.isAllowHTMLImages()).thenReturn((Object)true);
        Mockito.when((Object)this.userSettingMail.isDisplayHtmlInlineContent()).thenReturn((Object)true);
        HtmlProcessing.formatContentForDisplay((String)this.htmlContent, (String)"UTF-8", (boolean)true, (Session)this.session, (MailPath)this.mailPath, (UserSettingMail)this.userSettingMail, (boolean[])this.modified, (DisplayMode)DisplayMode.DISPLAY, (boolean)true, (int)-1);
        ((HtmlService)Mockito.verify((Object)this.htmlService, (VerificationMode)Mockito.times((int)1))).sanitize(Matchers.anyString(), Matchers.anyString(), Matchers.anyBoolean(), (boolean[])Matchers.any(), Matchers.anyString(), Matchers.anyInt());
    }

    @Test
    public void testFormatContentForDisplay_isHtmlAllowedExternalImagesMailPathNull_sanitizeCalled() {
        Mockito.when((Object)this.htmlService.dropScriptTagsInHeader(this.htmlContent)).thenReturn((Object)this.htmlContent);
        Mockito.when((Object)this.userSettingMail.isAllowHTMLImages()).thenReturn((Object)true);
        Mockito.when((Object)this.userSettingMail.isDisplayHtmlInlineContent()).thenReturn((Object)true);
        HtmlProcessing.formatContentForDisplay((String)this.htmlContent, (String)"UTF-8", (boolean)true, (Session)this.session, null, (UserSettingMail)this.userSettingMail, (boolean[])this.modified, (DisplayMode)DisplayMode.DISPLAY, (boolean)true, (int)-1);
        ((HtmlService)Mockito.verify((Object)this.htmlService, (VerificationMode)Mockito.times((int)1))).sanitize(Matchers.anyString(), Matchers.anyString(), Matchers.anyBoolean(), (boolean[])Matchers.any(), Matchers.anyString(), Matchers.anyInt());
    }

    @Test
    public void testFormatContentForDisplay_isHtmlUseSanitize_sanitizeCalled() {
        Mockito.when((Object)this.userSettingMail.isDisplayHtmlInlineContent()).thenReturn((Object)true);
        Mockito.when((Object)this.htmlService.dropScriptTagsInHeader(this.htmlContent)).thenReturn((Object)this.htmlContent);
        HtmlSanitizeResult sanitizeResult = HtmlProcessing.formatContentForDisplay((String)this.htmlContent, (String)"UTF-8", (boolean)true, (Session)this.session, (MailPath)this.mailPath, (UserSettingMail)this.userSettingMail, (boolean[])this.modified, (DisplayMode)DisplayMode.DISPLAY, (boolean)false, (int)-1);
        Assert.assertTrue((!sanitizeResult.getContent().contains("<br />") ? 1 : 0) != 0);
        Assert.assertTrue((!sanitizeResult.getContent().contains("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />") ? 1 : 0) != 0);
        ((HtmlService)Mockito.verify((Object)this.htmlService, (VerificationMode)Mockito.times((int)1))).sanitize(Matchers.anyString(), Matchers.anyString(), Matchers.anyBoolean(), (boolean[])Matchers.any(), Matchers.anyString(), Matchers.anyInt());
    }

    @Test
    public void testFormatContentForDisplay_noHtmlDisplayMode_formatCalled() {
        HtmlProcessing.formatContentForDisplay((String)this.textContent, (String)"UTF-8", (boolean)false, (Session)this.session, (MailPath)this.mailPath, (UserSettingMail)this.userSettingMail, (boolean[])this.modified, (DisplayMode)DisplayMode.DISPLAY, (boolean)true, (int)-1);
        ((HtmlService)Mockito.verify((Object)this.htmlService, (VerificationMode)Mockito.times((int)1))).htmlFormat(Matchers.anyString(), Matchers.anyBoolean(), Matchers.anyString(), Matchers.anyInt());
    }

    @Test
    public void testFormatContentForDisplay_noHtml_formatCalledOnce() {
        HtmlProcessing.formatContentForDisplay((String)this.textContent, (String)"UTF-8", (boolean)false, (Session)this.session, (MailPath)this.mailPath, (UserSettingMail)this.userSettingMail, (boolean[])this.modified, (DisplayMode)DisplayMode.MODIFYABLE, (boolean)true, (int)-1);
        ((HtmlService)Mockito.verify((Object)this.htmlService, (VerificationMode)Mockito.times((int)1))).htmlFormat(Matchers.anyString(), Matchers.anyBoolean(), Matchers.anyString(), Matchers.anyInt());
    }
}

