/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.messaging.generic.internet;

import com.openexchange.exception.OXException;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.messaging.MessagingAddressHeader;
import com.openexchange.messaging.MessagingExceptionCodes;
import com.openexchange.messaging.MessagingHeader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class MimeAddressMessagingHeader
implements MessagingAddressHeader {
    private final QuotedInternetAddress internetAddress;
    private final String name;

    public static Collection<MimeAddressMessagingHeader> parseRFC822(String name, String addressList) throws OXException {
        try {
            InternetAddress[] internetAddresses = QuotedInternetAddress.parse((String)addressList);
            ArrayList<MimeAddressMessagingHeader> retval = new ArrayList<MimeAddressMessagingHeader>(internetAddresses.length);
            for (InternetAddress internetAddresse : internetAddresses) {
                retval.add(new MimeAddressMessagingHeader(name, (QuotedInternetAddress)internetAddresse));
            }
            return retval;
        }
        catch (AddressException e) {
            throw MessagingExceptionCodes.ADDRESS_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (IllegalArgumentException e) {
            throw MessagingExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public static MimeAddressMessagingHeader valueOfRFC822(String name, String address) throws OXException {
        try {
            return new MimeAddressMessagingHeader(name, new QuotedInternetAddress(address));
        }
        catch (AddressException e) {
            throw MessagingExceptionCodes.ADDRESS_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (IllegalArgumentException e) {
            throw MessagingExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public static MimeAddressMessagingHeader valueOfPlain(String name, String personal, String address) {
        return new MimeAddressMessagingHeader(name, personal, address);
    }

    private MimeAddressMessagingHeader(String name, String personal, String address) {
        if (null == address) {
            throw new IllegalArgumentException("Address is null.");
        }
        this.name = name;
        this.internetAddress = new QuotedInternetAddress();
        try {
            this.internetAddress.setPersonal(personal, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        this.internetAddress.setAddress(address);
    }

    private MimeAddressMessagingHeader(String name, QuotedInternetAddress internetAddress) {
        if (null == internetAddress) {
            throw new IllegalArgumentException("Internet address is null.");
        }
        this.name = name;
        this.internetAddress = internetAddress;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.internetAddress.toString();
    }

    public MessagingHeader.HeaderType getHeaderType() {
        return MessagingHeader.HeaderType.ADDRESS;
    }

    public String getUnicodeValue() {
        return this.internetAddress.toUnicodeString();
    }

    public String getPersonal() {
        return this.internetAddress.getPersonal();
    }

    public String getAddress() {
        return this.internetAddress.getAddress();
    }

    public void setAddress(String address) throws OXException {
        if (null == address) {
            IllegalArgumentException e = new IllegalArgumentException("Address is null.");
            throw MessagingExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        this.internetAddress.setAddress(address);
    }

    public void setPersonal(String personal) {
        try {
            this.internetAddress.setPersonal(personal, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

