/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import com.openexchange.java.BoundaryExceededException;
import java.io.Serializable;

public class BoundedStringBuilder
implements Serializable,
CharSequence {
    private static final long serialVersionUID = 298165706640235317L;
    private final StringBuilder sb;
    private final int maxCount;

    public BoundedStringBuilder(int maxCount) {
        if (maxCount <= 0) {
            throw new IllegalArgumentException("maxCount must be positive");
        }
        this.sb = new StringBuilder();
        this.maxCount = maxCount;
    }

    public BoundedStringBuilder(int capacity, int maxCount) {
        if (maxCount <= 0) {
            throw new IllegalArgumentException("maxCount must be positive");
        }
        if (capacity < 0) {
            throw new NegativeArraySizeException("capacity is less than zero");
        }
        if (capacity > maxCount) {
            throw new BoundaryExceededException("capacity is bigger than maxCount");
        }
        this.sb = new StringBuilder(capacity);
        this.maxCount = maxCount;
    }

    public BoundedStringBuilder(String str, int maxCount) {
        if (maxCount <= 0) {
            throw new IllegalArgumentException("maxCount must be positive");
        }
        if (null == str) {
            throw new NullPointerException("str is null");
        }
        if (str.length() > maxCount) {
            throw new BoundaryExceededException("str is bigger than maxCount");
        }
        this.sb = new StringBuilder(str);
        this.maxCount = maxCount;
    }

    public BoundedStringBuilder(CharSequence seq, int maxCount) {
        if (maxCount <= 0) {
            throw new IllegalArgumentException("maxCount must be positive");
        }
        if (null == seq) {
            throw new NullPointerException("seq is null");
        }
        if (seq.length() > maxCount) {
            throw new BoundaryExceededException("seq is bigger than maxCount");
        }
        this.sb = new StringBuilder(seq);
        this.maxCount = maxCount;
    }

    private void checkLength() {
        if (this.sb.length() > this.maxCount) {
            throw new BoundaryExceededException("maxCount exceeded");
        }
    }

    @Override
    public int length() {
        return this.sb.length();
    }

    public int capacity() {
        return this.sb.capacity();
    }

    public void trimToSize() {
        this.sb.trimToSize();
    }

    public void setLength(int newLength) {
        this.sb.setLength(newLength);
    }

    public BoundedStringBuilder append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public BoundedStringBuilder append(String str) {
        this.sb.append(str);
        this.checkLength();
        return this;
    }

    public BoundedStringBuilder append(StringBuffer sb) {
        this.sb.append(sb);
        this.checkLength();
        return this;
    }

    @Override
    public char charAt(int index) {
        return this.sb.charAt(index);
    }

    public BoundedStringBuilder append(CharSequence s) {
        this.sb.append(s);
        this.checkLength();
        return this;
    }

    public BoundedStringBuilder append(CharSequence s, int start, int end) {
        this.sb.append(s, start, end);
        this.checkLength();
        return this;
    }

    public int codePointAt(int index) {
        return this.sb.codePointAt(index);
    }

    public BoundedStringBuilder append(char[] str) {
        this.sb.append(str);
        this.checkLength();
        return this;
    }

    public BoundedStringBuilder append(char[] str, int offset, int len) {
        this.sb.append(str, offset, len);
        this.checkLength();
        return this;
    }

    public BoundedStringBuilder append(boolean b) {
        this.sb.append(b);
        this.checkLength();
        return this;
    }

    public BoundedStringBuilder append(char c) {
        this.sb.append(c);
        this.checkLength();
        return this;
    }

    public BoundedStringBuilder append(int i) {
        this.sb.append(i);
        this.checkLength();
        return this;
    }

    public BoundedStringBuilder append(long lng) {
        this.sb.append(lng);
        this.checkLength();
        return this;
    }

    public BoundedStringBuilder append(float f) {
        this.sb.append(f);
        this.checkLength();
        return this;
    }

    public BoundedStringBuilder append(double d) {
        this.sb.append(d);
        this.checkLength();
        return this;
    }

    public BoundedStringBuilder appendCodePoint(int codePoint) {
        this.sb.appendCodePoint(codePoint);
        this.checkLength();
        return this;
    }

    public BoundedStringBuilder delete(int start, int end) {
        this.sb.delete(start, end);
        return this;
    }

    public int codePointBefore(int index) {
        return this.sb.codePointBefore(index);
    }

    public BoundedStringBuilder deleteCharAt(int index) {
        this.sb.deleteCharAt(index);
        return this;
    }

    public BoundedStringBuilder replace(int start, int end, String str) {
        this.sb.replace(start, end, str);
        return this;
    }

    public BoundedStringBuilder insert(int index, char[] str, int offset, int len) {
        this.sb.insert(index, str, offset, len);
        this.checkLength();
        return this;
    }

    public BoundedStringBuilder insert(int offset, Object obj) {
        this.sb.insert(offset, obj);
        this.checkLength();
        return this;
    }

    public BoundedStringBuilder insert(int offset, String str) {
        this.sb.insert(offset, str);
        this.checkLength();
        return this;
    }

    public BoundedStringBuilder insert(int offset, char[] str) {
        this.sb.insert(offset, str);
        this.checkLength();
        return this;
    }

    public BoundedStringBuilder insert(int dstOffset, CharSequence s) {
        this.sb.insert(dstOffset, s);
        this.checkLength();
        return this;
    }

    public int codePointCount(int beginIndex, int endIndex) {
        return this.sb.codePointCount(beginIndex, endIndex);
    }

    public BoundedStringBuilder insert(int dstOffset, CharSequence s, int start, int end) {
        this.sb.insert(dstOffset, s, start, end);
        this.checkLength();
        return this;
    }

    public BoundedStringBuilder insert(int offset, boolean b) {
        this.sb.insert(offset, b);
        this.checkLength();
        return this;
    }

    public BoundedStringBuilder insert(int offset, char c) {
        this.sb.insert(offset, c);
        this.checkLength();
        return this;
    }

    public BoundedStringBuilder insert(int offset, int i) {
        this.sb.insert(offset, i);
        this.checkLength();
        return this;
    }

    public BoundedStringBuilder insert(int offset, long l) {
        this.sb.insert(offset, l);
        this.checkLength();
        return this;
    }

    public int offsetByCodePoints(int index, int codePointOffset) {
        return this.sb.offsetByCodePoints(index, codePointOffset);
    }

    public BoundedStringBuilder insert(int offset, float f) {
        this.sb.insert(offset, f);
        this.checkLength();
        return this;
    }

    public BoundedStringBuilder insert(int offset, double d) {
        this.sb.insert(offset, d);
        this.checkLength();
        return this;
    }

    public int indexOf(String str) {
        return this.sb.indexOf(str);
    }

    public int indexOf(String str, int fromIndex) {
        return this.sb.indexOf(str, fromIndex);
    }

    public int lastIndexOf(String str) {
        return this.sb.lastIndexOf(str);
    }

    public int lastIndexOf(String str, int fromIndex) {
        return this.sb.lastIndexOf(str, fromIndex);
    }

    public StringBuilder reverse() {
        return this.sb.reverse();
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        this.sb.getChars(srcBegin, srcEnd, dst, dstBegin);
    }

    @Override
    public String toString() {
        return this.sb.toString();
    }

    public void setCharAt(int index, char ch) {
        this.sb.setCharAt(index, ch);
    }

    public String substring(int start) {
        return this.sb.substring(start);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.sb.subSequence(start, end);
    }

    public String substring(int start, int end) {
        return this.sb.substring(start, end);
    }
}

