/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.arrays;

import gnu.trove.set.hash.TIntHashSet;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;

public final class Arrays {
    private Arrays() {
    }

    public static boolean contains(int[] array, int search) {
        boolean found = false;
        for (int test : array) {
            if (test != search) continue;
            found = true;
            break;
        }
        return found;
    }

    public static int[] addUniquely(int[] toExtend, int ... other) {
        if (toExtend == null || other == null) {
            return toExtend;
        }
        TIntHashSet tmp = new TIntHashSet(toExtend.length + other.length);
        for (int i : toExtend) {
            tmp.add(i);
        }
        for (int i : other) {
            tmp.add(i);
        }
        return tmp.toArray();
    }

    public static <T> T[] remove(T[] removeFrom, T ... toRemove) {
        ArrayList<T> tmp = new ArrayList<T>();
        for (T copy : removeFrom) {
            tmp.add(copy);
        }
        for (T remove : toRemove) {
            tmp.remove(remove);
        }
        Object[] retval = tmp.toArray((Object[])Array.newInstance(removeFrom.getClass().getComponentType(), tmp.size()));
        return retval;
    }

    public static <T> T[] add(T[] toExtend, T ... other) {
        if (other == null) {
            return toExtend;
        }
        Object[] tmp = (Object[])Array.newInstance(toExtend.getClass().getComponentType(), toExtend.length + other.length);
        System.arraycopy(toExtend, 0, tmp, 0, toExtend.length);
        System.arraycopy(other, 0, tmp, toExtend.length, other.length);
        return tmp;
    }

    public static <T> T[] clone(T[] toClone) {
        Object[] retval = (Object[])Array.newInstance(toClone.getClass().getComponentType(), toClone.length);
        System.arraycopy(toClone, 0, retval, 0, toClone.length);
        return retval;
    }

    public static int[] extract(int[] source, int start) {
        return Arrays.extract(source, start, source.length - start);
    }

    public static int[] extract(int[] source, int start, int length) {
        int realLength = Arrays.determineRealSize(source.length, start, length);
        int[] retval = new int[realLength];
        System.arraycopy(source, start, retval, 0, realLength);
        return retval;
    }

    public static <T> T[] extract(T[] source, int start, int length, Class<? extends T> clazz) {
        int realLength = Arrays.determineRealSize(source.length, start, length);
        Object[] retval = (Object[])Array.newInstance(clazz, realLength);
        System.arraycopy(source, start, retval, 0, realLength);
        return retval;
    }

    public static int determineRealSize(int size, int start, int length) {
        return start + length > size ? size - start : length;
    }

    public static Serializable[] toSerializable(Integer[] ids) {
        Serializable[] retval = new Serializable[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            retval[i] = ids[i];
        }
        return retval;
    }

    public static <T> void reverse(T[] array) {
        for (int i = 0; i < array.length / 2; ++i) {
            T t = array[i];
            array[i] = array[array.length - i - 1];
            array[array.length - i - 1] = t;
        }
    }

    public static <T> boolean contains(T[] array, T t) {
        if (null != t) {
            for (int i = 0; i < array.length; ++i) {
                if (!t.equals(array[i])) continue;
                return true;
            }
        }
        return false;
    }
}

