/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.global.osgi;

import com.openexchange.exception.OXException;
import com.openexchange.server.Initialization;
import java.security.Security;

final class ServerInitialization
implements Initialization {
    private volatile String previousTTL;
    private volatile String previousNegativeTTL;

    ServerInitialization() {
    }

    @Override
    public void start() throws OXException {
        this.previousTTL = Security.getProperty("networkaddress.cache.ttl");
        this.previousNegativeTTL = Security.getProperty("networkaddress.cache.negative.ttl");
        Security.setProperty("networkaddress.cache.ttl", Integer.toString(3600));
        System.setProperty("sun.net.inetaddr.ttl", Integer.toString(3600));
        Security.setProperty("networkaddress.cache.negative.ttl", Integer.toString(10));
    }

    @Override
    public void stop() throws OXException {
        String previousTTL = this.previousTTL;
        if (null == previousTTL) {
            Security.setProperty("networkaddress.cache.ttl", "-1");
        } else {
            Security.setProperty("networkaddress.cache.ttl", previousTTL);
            this.previousTTL = null;
        }
        String previousNegativeTTL = this.previousNegativeTTL;
        if (null == previousNegativeTTL) {
            Security.setProperty("networkaddress.cache.negative.ttl", "10");
        } else {
            Security.setProperty("networkaddress.cache.negative.ttl", previousNegativeTTL);
            this.previousNegativeTTL = null;
        }
    }
}

