/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.cli;

import com.openexchange.auth.mbean.AuthenticatorMBean;
import com.openexchange.cli.AbstractAdministrativeCLI;
import com.openexchange.cli.ExecutionFault;
import com.openexchange.java.Strings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public abstract class AbstractMBeanCLI<R>
extends AbstractAdministrativeCLI<R, MBeanServerConnection> {
    protected AbstractMBeanCLI() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public R execute(String[] args) {
        options = this.newOptions();
        error = true;
        try {
            options.addOption("h", "help", false, "Prints a help text");
            options.addOption("t", "host", true, "The optional JMX host (default:localhost)");
            options.addOption("p", "port", true, "The optional JMX port (default:9999)");
            options.addOption(new Option(null, "responsetimeout", true, "The optional response timeout in seconds when reading data from server (default: 0s; infinite)"));
            options.addOption("l", "login", true, "The optional JMX login (if JMX authentication is enabled)");
            options.addOption("s", "password", true, "The optional JMX password (if JMX authentication is enabled)");
            requiresAdministrativePermission = this.requiresAdministrativePermission();
            if (requiresAdministrativePermission) {
                options.addOption("A", "adminuser", true, "Admin username");
                options.addOption("P", "adminpass", true, "Admin password");
            }
            this.addOptions(options);
            parser = new PosixParser();
            cmd = parser.parse((Options)options, args);
            if (cmd.hasOption('h')) {
                this.printHelp(options);
                System.exit(0);
                var7_14 = null;
                return var7_14;
            }
            host = cmd.getOptionValue('t', "localhost");
            port = this.parsePort('p', 9999, cmd, options);
            jmxLogin = null;
            if (cmd.hasOption('l')) {
                jmxLogin = cmd.getOptionValue('l');
            }
            jmxPassword = null;
            if (cmd.hasOption('s')) {
                jmxPassword = cmd.getOptionValue('s');
            }
            if (cmd.hasOption("responsetimeout") && (responseTimeout = this.parseInt("responsetimeout", 0, cmd, (Options)options)) > 0) {
                System.setProperty("sun.rmi.transport.tcp.responseTimeout", Integer.toString(responseTimeout * 1000));
            }
            this.checkOptions(cmd, options);
            if (jmxLogin == null || jmxPassword == null) {
                environment = null;
            } else {
                environment = new HashMap<String, String[]>(1);
                creds = new String[]{jmxLogin, jmxPassword};
                environment.put("jmx.remote.credentials", creds);
            }
            url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + host + ":" + port + "/server");
            jmxConnector = JMXConnectorFactory.connect(url, environment);
            retval = null;
            try {
                mbsc = jmxConnector.getMBeanServerConnection();
                try {
                    if (requiresAdministrativePermission && this.isAuthEnabled(authenticator = this.authenticatorMBean(mbsc))) {
                        adminLogin = cmd.getOptionValue('A');
                        if (Strings.isEmpty((String)adminLogin)) {
                            System.out.println("You must provide administrative credentials to proceed.");
                            this.printHelp(options);
                            System.exit(104);
                            var18_29 = null;
                            return var18_29;
                        }
                    }
                    ** GOTO lbl80
                }
                catch (Exception e) {
                    t = e.getCause();
                    if (null == t) {
                        v0 /* !! */  = e;
                        throw new ExecutionFault(v0 /* !! */ );
                    }
                    v0 /* !! */  = t;
                    throw new ExecutionFault(v0 /* !! */ );
                }
                adminPassword = cmd.getOptionValue('P');
                if (!Strings.isEmpty((String)adminPassword)) ** GOTO lbl-1000
                System.out.println("You must provide administrative credentials to proceed.");
                this.printHelp(options);
                System.exit(104);
                var19_32 = null;
                return var19_32;
lbl-1000:
                // 1 sources

                {
                    this.administrativeAuth(adminLogin, adminPassword, cmd, authenticator);
lbl80:
                    // 2 sources

                    retval = this.invoke((Options)options, cmd, mbsc);
                }
            }
            finally {
                try {
                    jmxConnector.close();
                }
                catch (Exception e) {}
            }
            error = false;
            var15_24 = retval;
            return var15_24;
        }
        catch (ExecutionFault e) {
            t = e.getCause();
            message = t.getMessage();
            System.err.println(null == message ? "An error occurred." : message);
            return null;
        }
        catch (ParseException e) {
            System.err.println("Unable to parse command line: " + e.getMessage());
            this.printHelp(options);
            return null;
        }
        catch (MalformedURLException e) {
            System.err.println("URL to connect to server is invalid: " + e.getMessage());
            return null;
        }
        catch (IOException e) {
            System.err.println("Unable to communicate with the server: " + e.getMessage());
            return null;
        }
        catch (RuntimeException e) {
            message = e.getMessage();
            clazzName = e.getClass().getName();
            System.err.println("A runtime error occurred: " + (null == message ? clazzName : clazzName + ": " + message));
            return null;
        }
        catch (Error e) {
            message = e.getMessage();
            clazzName = e.getClass().getName();
            System.err.println("A JVM problem occurred: " + (null == message ? clazzName : clazzName + ": " + message));
            return null;
        }
        catch (Throwable t) {
            message = t.getMessage();
            clazzName = t.getClass().getName();
            System.err.println("A JVM problem occurred: " + (null == message ? clazzName : clazzName + ": " + message));
            return null;
        }
        finally {
            if (error) {
                System.exit(1);
            }
        }
    }

    protected AuthenticatorMBean authenticatorMBean(MBeanServerConnection mbsc) throws MalformedObjectNameException {
        return AbstractMBeanCLI.getMBean(mbsc, AuthenticatorMBean.class, "com.openexchange.auth");
    }

    protected boolean isAuthEnabled(AuthenticatorMBean authenticator) throws MBeanException {
        return !authenticator.isMasterAuthenticationDisabled();
    }

    protected abstract void administrativeAuth(String var1, String var2, CommandLine var3, AuthenticatorMBean var4) throws MBeanException;

    @Override
    protected abstract void addOptions(Options var1);

    @Override
    protected abstract R invoke(Options var1, CommandLine var2, MBeanServerConnection var3) throws Exception;

    protected static <MBean> MBean getMBean(MBeanServerConnection mbsc, Class<? extends MBean> clazz, String domain) throws MalformedObjectNameException {
        return MBeanServerInvocationHandler.newProxyInstance(mbsc, AbstractMBeanCLI.getObjectName(clazz.getName(), domain), clazz, false);
    }

    protected static ObjectName getObjectName(String className, String domain) throws MalformedObjectNameException {
        int pos = className.lastIndexOf(46);
        return new ObjectName(domain, "name", pos == -1 ? className : className.substring(pos + 1));
    }
}

