/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage;

import com.openexchange.file.storage.AbstractFileFieldHandler;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.meta.FileComparator;
import com.openexchange.file.storage.meta.FileFieldGet;
import com.openexchange.file.storage.meta.FileFieldHandling;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class AbstractFile
implements File {
    protected AbstractFile() {
    }

    @Override
    public File dup() {
        return FileFieldHandling.dup(this);
    }

    @Override
    public void copyInto(File other) {
        FileFieldHandling.copy(this, other);
    }

    @Override
    public void copyFrom(File other) {
        FileFieldHandling.copy(other, this);
    }

    @Override
    public void copyInto(File other, File.Field ... fields) {
        FileFieldHandling.copy(this, other, fields);
    }

    @Override
    public void copyFrom(File other, File.Field ... fields) {
        FileFieldHandling.copy(other, this, fields);
    }

    @Override
    public Set<File.Field> differences(final File other) {
        return File.Field.inject(new AbstractFileFieldHandler(){

            @Override
            public Object handle(File.Field field, Object ... args) {
                Set set = this.get(0, Set.class, args);
                int comparison = new FileComparator(field).compare(AbstractFile.this, other);
                if (comparison != 0) {
                    set.add(field);
                }
                return set;
            }
        }, new HashSet(), new Object[0]);
    }

    @Override
    public boolean equals(File other, File.Field criterium, File.Field ... criteria) {
        ArrayList fields = new ArrayList(1 + criteria.length);
        for (File.Field field : fields) {
            if (0 == new FileComparator(field).compare(this, other)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        return this.equals((File)other, File.Field.ID, File.Field.values());
    }

    public String toString() {
        return FileFieldHandling.toString(this);
    }

    @Override
    public boolean matches(String pattern, File.Field ... fields) {
        Pattern regex = Pattern.compile(AbstractFile.wildcardToRegex(pattern), 2);
        FileFieldGet fileFieldGet = new FileFieldGet();
        for (File.Field field : null == fields || 0 == fields.length ? DEFAULT_SEARCH_FIELDS : EnumSet.copyOf(Arrays.asList(fields))) {
            Object value = field.doSwitch(fileFieldGet, this);
            if (null == value || !regex.matcher(value.toString()).matches()) continue;
            return true;
        }
        return false;
    }

    private static String wildcardToRegex(String wildcard) {
        StringBuilder s = new StringBuilder(wildcard.length());
        s.append('^');
        int len = wildcard.length();
        for (int i = 0; i < len; ++i) {
            char c = wildcard.charAt(i);
            if (c == '*') {
                s.append(".*");
                continue;
            }
            if (c == '?') {
                s.append('.');
                continue;
            }
            if (c == '(' || c == ')' || c == '[' || c == ']' || c == '$' || c == '^' || c == '.' || c == '{' || c == '}' || c == '|' || c == '\\' || c == '+') {
                s.append('\\');
                s.append(c);
                continue;
            }
            s.append(c);
        }
        s.append('$');
        return s.toString();
    }
}

