/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.infostore.internal;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.infostore.internal.VirtualFolderInfostoreFacade;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.java.Strings;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class InfostoreAccess {
    protected static final InfostoreFacade VIRTUAL_INFOSTORE = new VirtualFolderInfostoreFacade();
    protected static final Set<Long> VIRTUAL_FOLDERS;
    protected final InfostoreFacade infostore;

    protected InfostoreAccess(InfostoreFacade infostore) {
        this.infostore = infostore;
    }

    protected InfostoreFacade getInfostore(String folderId) throws OXException {
        if (Strings.isNotEmpty((String)folderId)) {
            try {
                if (VIRTUAL_FOLDERS.contains(Long.valueOf(folderId))) {
                    return VIRTUAL_INFOSTORE;
                }
            }
            catch (NumberFormatException e) {
                throw InfostoreExceptionCodes.NOT_INFOSTORE_FOLDER.create((Throwable)e, new Object[]{folderId});
            }
        }
        return this.infostore;
    }

    protected static int ID(String id) {
        return Integer.parseInt(id);
    }

    protected static long FOLDERID(String folderId) {
        return Long.parseLong(folderId);
    }

    protected static int VERSION(String version) {
        int iVersion = -1;
        if (version != FileStorageFileAccess.CURRENT_VERSION) {
            iVersion = Integer.parseInt(version);
        }
        return iVersion;
    }

    static {
        HashSet<Long> set = new HashSet<Long>(4);
        set.add(14L);
        set.add(9L);
        set.add(15L);
        VIRTUAL_FOLDERS = Collections.unmodifiableSet(set);
    }
}

