/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com 
 * 
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 * 
 */

/**
 * Change the inital expert tree setting when matching the given
 * conditions. Can be used with version >= 6.18.1
 * 
 * Pre-Condition: The user never manually changed the expert tree
 * setting!
 */

var _pn_expTree_settings = ox.api.config.get(["modules","com.openexchange.settings.folder"]) || { };

/*
 * Sets the condition to force the expert tree setting. 
 * -1 = no check (by default)
 *  1 = every user
 *  2 = every user with module infostore enabled
 *  3 = every user with module infostore enabled which
 *      contains at least 'n' files
 */
var _pn_expTree_condition = -1;
if (_pn_expTree_settings.condition) {
    _pn_expTree_condition = parseInt(_pn_expTree_settings.condition);
}

/*
 * Sets the minimum file a user must have in infostore. 
 * Pre-condition: _pn_expTree_condition has been set to 3
 */
var _pn_expTree_min_files = 1;
if (parseInt(_pn_expTree_settings.minFiles)) {
    _pn_expTree_min_files = parseInt(_pn_expTree_settings.minFiles);
}

function _pn_expTree_enable() {    
    // using set method added with >= 6.18.2-Rev6
    if (jQuery.isFunction(ox.UIController.setExpertTree)) {
        ox.UIController.setExpertTree(true);
        return;
    }
    
    // seems like an older version, some more steps required
    ox.UIController.showExpertTree = true;
    ox.widgets.sidepanel.toggle(false);
    ox.UIController.changeIconState("foldertree");
    ox.widgets.sidepanelViewControl.showView("ox-sidepanel-foldertree");
    ox.api.config.set("gui.global.expert_tree", 1);
}

function _pn_expTree_checkFiles() {
    var id = "tmp-" + new Date().getTime() + "-ox";
    // disable UI by adding a transparent layer
    jQuery("body").append(
            jQuery("<div/>").addClass(id).
            css({ position: "absolute", top: 0, left: 0, right: 0, 
                bottom: 0, background: "black", opacity: 0.5 })
    );
    
    // fallback: just in case something went wrong we'll 
    // force removing the transparent layer after 15 sec.
    setTimeout(function() {
     // remove transparent div
        jQuery("." + id).remove();
    }, 15000);
    
    // fire-up search in infostore
    OXCache.newRequest(null, "infostore", { columns: [], criteria: [], search: { title: "*"} }, 
            jQuery.noop, 
            function(data) {
                // remove transparent layer
                jQuery("." + id).remove();
                if (data && data.objects.length >= 
                    _pn_expTree_min_files) {
                    _pn_expTree_enable();
                } else {
                    ox.api.config.set("gui.global.expert_tree", 0);
                }
            }
    );
}

// condition is != -1 and user not changed the 
// expert tree setting.
if (_pn_expTree_condition !== -1 && 
        ox.api.config.get("gui.global.expert_tree") === null) {
    // force expert tree for all users
    if (_pn_expTree_condition === 1) {
        _pn_expTree_enable();
        return;
    } else if (ox.api.config.get("modules.infostore.module") === true) {
        // user must have infostore module enabled
        if (_pn_expTree_condition === 2) {
            _pn_expTree_enable();
            return;
        } else if (_pn_expTree_condition === 3) { 
            // check number of files in infostore
            _pn_expTree_checkFiles();
            return;
        }
    }
    ox.api.config.set("gui.global.expert_tree", 0);
}