/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com 
 * 
 * @author  Alexander Quast <alexander.quast@open-xchange.com>
 */

ox.gui.initToolBarNewWindowContact = function () {

    var $p = ox.gui.initToolBarNewWindow(),
        upsell = corewindow.ox.upsell;
    
    /*
     * Meta data
     */
    var meta = $.extend(ox.widgets.toolBar.meta, {
        /*
         * New Mail Window
         */
        "window_contact": {
            "save": {
                title: _("Save"),
                icons: ["save.png"],
                big: true
               
            },
            "add-picture": {
                title: _("Add picture"),
                icons: ["picture_add.png"],
                big: true
            },
            "remove-picture": {
                title: _("Remove picture"),
                icons: ["picture_remove.png"],
                big: true
            },
            "attachment-add": {
                title: _("Add attachment"),
                icons: ["attachment_add.png"],
                big: false, 
                requires: function() {
                    return ox.api.config.get('modules.infostore.module');
                },
                mousedown: function (options, e) {
                    if (ox.api.config.get("modules.infostore.module") == false) {
                        corewindow.triggerEvent("Feature_Not_Available", "modules/contacts/new/add_attachment", window);
                    }
                },
                visible: upsell.visible("infostore")
            },
            "attachment-remove": {
                title: _("Remove attachment"),
                icons: ["attachment_remove.png"],
                selection: "attachments",
                requires: function(ability) {
                    return currentpath[1] === "attachment" &&
                        ox.api.config.get('modules.infostore.module') &&
                        ability.some;
                },
                mousedown: function (options, e) {
                    if (ox.api.config.get("modules.infostore.module") == false) {
                        corewindow.triggerEvent("Feature_Not_Available", "modules/contacts/new/delete_attachment", window);
                    }
                },
                big: false,
                visible: upsell.visible("infostore")
            },
            "cancel": {
                 title: _("Cancel"),
                 big: true,
                 icons: ["cancel.png"]
            }
        }
    });
    
    
    /*
     * Add widgets
     */
    
    // vars
    var tabs = ox.widgets.toolBar.tabs;
    var items = ox.widgets.toolBar.menuItems;
    var toolbar, tab, section;
    
    // fn
    var add = $p.add;
    
    // create toolbar instance
    toolbar = ox.widgets.toolBar.views.contact = new ox.gui.TabMenu(
        $p.getOptions({
            id: "new-contact-menu",
            showSectionNames: false
        })
    );
    
    // main tab
    tab = tabs.newMailWindow = new ox.gui.PanelMenu(
        "window-contact-main", _("Contact")).addTo(toolbar);
    
    // Section 1, save contact
    section = new ox.gui.PanelMenuSection(_("Contact")).addTo(tab);
    add(section, ox.widgets.toolBar.meta.window_contact, "contact_new",
        ["save"]);

    // Section 2, add/remove contact picture
    section = new ox.gui.PanelMenuSection(_("Picture")).addTo(tab);
    add(section, ox.widgets.toolBar.meta.window_contact, "contact_new",
        ["add-picture","remove-picture"]);
    
    // Section 3, add/remove attachment
    if (upsell.isVisible("infostore") && upsell.isVisible("contacts-attachments")) {
        section = new ox.gui.PanelMenuSection(_("Attachment")).addTo(tab);
        add(section, ox.widgets.toolBar.meta.window_contact, "contact_new",
            ["attachment-add","attachment-remove"]
        );
    }
    // Section 4, cancel
    section = new ox.gui.PanelMenuSection(_("Cancel")).addTo(tab);
    add(section, ox.widgets.toolBar.meta.window_contact, "contact_new",
        ["cancel"]);
    
    // add to top-level element
    toolbar.addTo(ox.widgets.toolBar.viewControl);
    
    $p.postInit();
    
    register("OX_View_Changed", function() {
        ox.ToolBarController.processSelection("default", false, [], true);
        ox.ToolBarController.processSelection("attachments", false,
            tmp_attachment ? tmp_attachment.liveGrid.selection.getSelected()
                           : [],
            true);
    });
    
    // event mapping
    var events = {
            "contact_new-save" : "OX_SAVE_OBJECT",
            "contact_new-attachment-add" : "OX_Object_Add_Attachment",
            "contact_new-attachment-remove" : "OX_Object_Attachment_Delete",
            "contact_new-add-picture" : "OX_Picture_Add",
            "contact_new-remove-picture" : "OX_Picture_Remove",
            "contact_new-cancel" : "OX_Cancel_Object"
    }
  
    // add handler function (must return true when action taken)
    ox.ToolBarController.addHandler(function (id) {
        // defined by event?
        if (events[id] !== undefined) {
            // change tab?
            if (id === "contact_new-add-picture" || id === "contact_new-remove-picture") {
                // change tab
                changeView("contact_new/personal");
            } else if (id === "contact_new-attachment-add") {
                // change tab
                changeView("contact_new/attachment");
            }
            // trigger
            triggerEvent(events[id]);
            return true;
        }
    });
    
    ox.desktop.validate();
    
    // initial redraw to update icon state
    triggerEvent("OX_View_Changed");
    
    ox.api.window.core.triggerEvent("OX_Window_Toolbar_Ready", {
            handle : window.url.guid,
            type : "contact"
    });
    ox.ToolBarController.processSelection("attachments", false, [], true);
};